/*********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

// Java Classes
import gov.va.med.esr.common.model.lookup.SelfIdentifiedGenderIdentity;
// Framework Classes
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
// Library Classes

/**
 * Struts Action Form for person search screen.
 *
 * @author vhaivmbapooh & Andrew Pach & Madhu Katikala
 * @version 3.0
 */
public class SearchActionForm extends AbstractForm
{
    private static final long serialVersionUID = 3713850842945159892L;
    
    private static final String MINIMUM_REQUIRED_FIELDS = "error.searchCriteria.required";
    private static final String SSN_REQUIRED_FOR_SEARCH = "error.ssn.required";
    private static final String LAST_NAME_REQUIRED_FOR_SEARCH = "error.lastName.required";
    private static final String FIRST_NAME_REQUIRED = "error.firstName.required";
    private static final String DOB_REQUIRED = "error.dateOfBirth.required";
    private static final String BIRTH_SEX_REQUIRED_FOR_SEARCH = "error.birthSex.required";
    private static final String VPID_EXCLUSIVE_SEARCH_ONLY= "error.vpid.exclusivesearchonly";
    
    // CCR 10471 ADD A PERSON
    private static final String ADD_A_PERSON_MINIMUM_REQUIRED_FIELDS = "error.searchNewCriteria.required";
    private static final String SSN_REQUIRED = "error.searchNewCriteria.ssn.required";
    private static final String LAST_NAME_REQUIRED = "error.searchNewCriteria.lastname.required";
    private static final String DATE_OF_BIRTH_REQUIRED = "error.searchNewCriteria.dob.required";
    private static final String PREFERRED_FACILITY_REQUIRED = "error.searchNewCriteria.preferredFacility.required";
    private static final String GENDER_REQUIRED = "error.searchNewCriteria.birthSex.required";

    private String ssn = null;
    private String givenName = null;
    private String middleName = null;
    private String familyName = null;
    private String dateOfBirth = null;
    private String gender = null;
    private String claimFolderNumber = null;
    private String militaryServiceNumber = null;
    private String vpid = null;
    private String selectedPersonId = null;
    private String extscHiddenId = null;
    private String selectedVpid = null;
    private String addAPersonSsn = null;
    
    // CCR 10471 Add a person
    //private String otherNames= null;
    //private String multipleBirth = null;
    //private String mothersMaidenName = null;
    private String preferredFacility = null;
    //private String placeOfBirthCity = null;
    //private String placeOfBirthState = null;   
    private String addressLine1 = null;
    private String addressLine2 = null;
    private String addressLine3 = null;
    private String city = null;
    private String state = null;
    private String zipCode = null;
    private String zipPlus4 = null;
    private String prevZip = null;
    private String postalCode = null;
    private String country = null;
    private String province = null;
    private String county = null;
    private String homePhoneNumber = null;
    private boolean addButtonDisabled = true;
    // Status History
    private String appSignatureDate = null;
    private String appMethod = null;
    private String appEntryDate = null;
    private String appStatus = null;
    private String appStatusTimeStamp = null;
    private String appCompletedDate = null;
    private String appUser = null;
    
    private SelfIdentifiedGenderIdentity selfIdentifiedGenderIdentity = null;
    private boolean disableSelfIdentifiedGenderIdentity = true;
   
    public String getSsn()
    {
    	if(addAPersonSsn != null){
    		ssn = addAPersonSsn;
    	}
        return ssn;
    }

    public String getUnformattedSsn()
    {
        String value = ssn;
        if(value == null)
        {
        	value=addAPersonSsn;
        }
        if (value != null)
        {
            value = value.replaceAll("-", "");
        }
        return value;
    }

    public void setSsn(String value)
    {
        ssn = value;
    }

    public String getFamilyName()
    {
        return familyName;
    }

    public void setFamilyName(String value)
    {
        familyName = value;
    }

    public String getMiddleName()
    {
        return middleName;
    }

    public void setMiddleName(String value)
    {
        middleName = value;
    }

    public String getGivenName()
    {
        return givenName;
    }

    public void setGivenName(String value)
    {
        givenName = value;
    }

    public String getDateOfBirth()
    {
        return dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth)
    {
        this.dateOfBirth = dateOfBirth;
    }

    public String getGender()
    {
        return gender;
    }

    public void setGender(String gender)
    {
        this.gender = gender;
    }

    public String getClaimFolderNumber()
    {
        return claimFolderNumber;
    }

    public void setClaimFolderNumber(String claimFolderNumber)
    {
        this.claimFolderNumber = claimFolderNumber;
    }

    public String getMilitaryServiceNumber()
    {
        return militaryServiceNumber;
    }

    public void setMilitaryServiceNumber(String militaryServiceNumber)
    {
        this.militaryServiceNumber = militaryServiceNumber;
    }

    public String getVpid() {
		return this.vpid;
	}

	public void setVpid(String vpid) {
		this.vpid = vpid;
	}

    public String getSelectedVpid() {
		return this.selectedVpid;
	}

	public void setSelectedVpid(String selectedVpid) {
		this.selectedVpid = selectedVpid;
	}

	public String getSelectedPersonId()
    {
        return selectedPersonId;
    }

    public void setSelectedPersonId(String selectedPersonId)
    {
        this.selectedPersonId = selectedPersonId;
    }

    public String getExtscHiddenId()
    {
        return extscHiddenId;
    }

    public void setExtscHiddenId(String extscHiddenId)
    {
        this.extscHiddenId = extscHiddenId;
    }

    public Boolean getAdditionalSearchCriteriaPresent()
    {
        if (StringUtils.trimToNull(this.claimFolderNumber) != null ||
            StringUtils.trimToNull(this.militaryServiceNumber) != null ||
            StringUtils.trimToNull(this.middleName) != null ||
            StringUtils.trimToNull(this.gender) != null)
        {
            // Additional search criteria has been specified
            return Boolean.TRUE;
        }
        else
        {
            return Boolean.FALSE;
        }
    }

    /**
     * Clear the form data used on the server side
     */
    public void clear()
    {
        ssn = null;
        addAPersonSsn = null;
        givenName = null;
        middleName = null;
        familyName = null;
        dateOfBirth = null;
        gender = null;
        claimFolderNumber = null;
        militaryServiceNumber = null;
        selectedPersonId = null;
        selectedVpid = null;
        vpid = null;
        
        // CCR 10471 Add a person
        //otherNames = null;
        //multipleBirth = null;
        //mothersMaidenName = null;
        //preferredFacility = null;
        //placeOfBirthCity = null;
        //placeOfBirthState = null;
        addressLine1 = null;
        addressLine2 = null;
        addressLine3 = null;
        city = null;
        state = null;
        zipCode = null;
        zipPlus4 = null;
        postalCode = null;
        country = null;
        county = null;
        //province = null;
        //clear the add a person history information
        homePhoneNumber = null;
        appSignatureDate = null;
        appMethod = null;
        appEntryDate = null;
        appStatus = null;
        appStatusTimeStamp = null;
        appCompletedDate = null;
        appUser = null;
       
    }

    public ActionMessages validateForm(ActionMapping mapping, HttpServletRequest request)
    {
    	List errorMessages = new ArrayList();
    	
    	// CCR 10471 Add A Person 	
    	boolean isAddAPerson = false;
    	
    	//request.getSession().getAttribute(ApplicationConstants.SessionData.ADD_A_PERSON);
    	// Use the utility method
    	isAddAPerson = SessionManager.isAddAPerson(request);
    	
    	if (isAddAPerson) {
			// required fields 
			String ssnValue = StringUtils.trimToNull(this.addAPersonSsn);
			String familyNameValue = StringUtils.trimToNull(this.familyName);
			String dateOfBirthValue = StringUtils.trimToNull(this.dateOfBirth);
			//String preferredFacility = StringUtils.trimToNull(this.preferredFacility);
			String genderValue = StringUtils.trimToNull(this.gender);
			
			if (ssnValue == null)
				errorMessages.add(new ActionMessage(SSN_REQUIRED));
			
			if (familyNameValue == null)
				errorMessages.add(new ActionMessage(LAST_NAME_REQUIRED));
			
			if (dateOfBirthValue == null)
				errorMessages.add(new ActionMessage(DATE_OF_BIRTH_REQUIRED));
			
			//			if (preferredFacility == null)
			//				errorMessages.add(new ActionMessage(PREFERRED_FACILITY_REQUIRED));

			if (genderValue == null)
				errorMessages.add(new ActionMessage(GENDER_REQUIRED));		
			
    	} else {
    		  	
	        String ssnValue = StringUtils.trimToNull(this.ssn);
	        String vpidValue = StringUtils.trimToNull(this.vpid);
	        String familyNameValue = StringUtils.trimToNull(this.familyName);
	        String givenNameValue = StringUtils.trimToNull(this.givenName);
	        String dateOfBirthValue = StringUtils.trimToNull(this.dateOfBirth);
	        String claimFolderNumberValue = StringUtils.trimToNull(this.claimFolderNumber);
	        String militaryServiceNumberValue = StringUtils.trimToNull(this.militaryServiceNumber);
	        String genderValue = StringUtils.trimToNull(this.gender);
	
	        //Check for exclusive VPID search
	        if (vpidValue != null){
	        	if (ssnValue == null && 
	        			familyNameValue == null && 
	        			givenNameValue == null &&
	        			dateOfBirthValue== null && 
	        			claimFolderNumberValue == null &&
	                    genderValue == null &&
	                    militaryServiceNumberValue == null)
	        	{
	        		return null;
	        	}
	        	else {
	        		errorMessages.add(new ActionMessage(VPID_EXCLUSIVE_SEARCH_ONLY));
	        	}
	        }
	        else {
 
		        if (claimFolderNumberValue != null || militaryServiceNumberValue != null)
		        {
		            return null;
		        }
		      
		    	//CCR12211 - ensure that last name, first name, ssn and gender are required when searched by person traits other than vpid, claim number or miliary service number
	        	//Check for minimum required fields
		    	if (vpidValue == null && ssnValue == null && familyNameValue == null && givenNameValue == null && 
		    		claimFolderNumberValue == null && genderValue == null && militaryServiceNumberValue == null){
		    			errorMessages.add(new ActionMessage(MINIMUM_REQUIRED_FIELDS));
	        	} 
		    	else {
		    		if (ssnValue == null)
						errorMessages.add(new ActionMessage(SSN_REQUIRED_FOR_SEARCH));
		    		
			        if (familyNameValue == null)
						errorMessages.add(new ActionMessage(LAST_NAME_REQUIRED_FOR_SEARCH));
			        
			        if (givenNameValue == null)
						errorMessages.add(new ActionMessage(FIRST_NAME_REQUIRED));

					if (genderValue == null)
						errorMessages.add(new ActionMessage(BIRTH_SEX_REQUIRED_FOR_SEARCH));	
				
		    	}
	        }
    	}
        
        if (errorMessages.size() > 0)
        {
            ActionMessages messages = new ActionMessages();
            for (int i = 0; i < errorMessages.size(); i++)
                messages.add(ActionMessages.GLOBAL_MESSAGE, (ActionMessage)errorMessages.get(i));
            return messages;
        }
        else
        {
            return null;
        }
    }

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}
	
	public String getHomePhoneNumber() {
		return homePhoneNumber;
	}

	public void setHomePhoneNumber(String homePhoneNumber) {
		this.homePhoneNumber = homePhoneNumber;
	}

	public String getPostalCode() {
		return postalCode;
	}

	public void setPostalCode(String postalCode) {
		this.postalCode = postalCode;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getZipCode() {
		return zipCode;
	}

	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}

	public String getAppEntryDate() {
		return appEntryDate;
	}

	public void setAppEntryDate(String appEntryDate) {
		this.appEntryDate = appEntryDate;
	}

	public String getAppMethod() {
		return appMethod;
	}

	public void setAppMethod(String appMethod) {
		this.appMethod = appMethod;
	}

	public String getAppSignatureDate() {
		return appSignatureDate;
	}

	public void setAppSignatureDate(String appSignatureDate) {
		this.appSignatureDate = appSignatureDate;
	}

	public String getAppStatus() {
		return appStatus;
	}

	public void setAppStatus(String appStatus) {
		this.appStatus = appStatus;
	}

	public String getAppStatusTimeStamp() {
		return appStatusTimeStamp;
	}

	public void setAppStatusTimeStamp(String appStatusTimeStamp) {
		this.appStatusTimeStamp = appStatusTimeStamp;
	}

	public String getAppUser() {
		return appUser;
	}

	public void setAppUser(String appUser) {
		this.appUser = appUser;
	}

	public String getAppCompletedDate() {
		return appCompletedDate;
	}

	public void setAppCompletedDate(String appCompletedDate) {
		this.appCompletedDate = appCompletedDate;
	}

	public boolean isAddButtonDisabled() {
		return addButtonDisabled;
	}

	public void setAddButtonDisabled(boolean addButtonDisabled) {
		this.addButtonDisabled = addButtonDisabled;
	}

	public String getPreferredFacility() {
		return preferredFacility;
	}

	public void setPreferredFacility(String preferredFacility) {
		this.preferredFacility = preferredFacility;
	}
	public String getAddressLine1() {
		return addressLine1;
	}

	public void setAddressLine1(String addressLine1) {
		this.addressLine1 = addressLine1;
	}

	public String getAddressLine2() {
		return addressLine2;
	}

	public void setAddressLine2(String addressLine2) {
		this.addressLine2 = addressLine2;
	}

	public String getAddressLine3() {
		return addressLine3;
	}

	public void setAddressLine3(String addressLine3) {
		this.addressLine3 = addressLine3;
	}

	public String getPrevZip() {
		return prevZip;
	}

	public void setPrevZip(String prevZip) {
		this.prevZip = prevZip;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getZipPlus4() {
		return zipPlus4;
	}

	public void setZipPlus4(String zipPlus4) {
		this.zipPlus4 = zipPlus4;
	}

	public String getAddAPersonSsn() {
    	return addAPersonSsn;
    }

	public void setAddAPersonSsn(String addAPersonSsn) {
    	this.addAPersonSsn = addAPersonSsn;
    }

    public SelfIdentifiedGenderIdentity getSelfIdentifiedGenderIdentity() {
        return selfIdentifiedGenderIdentity;
    }

    public void setSelfIdentifiedGenderIdentity(SelfIdentifiedGenderIdentity selfIdentifiedGenderIdentity) {
        this.selfIdentifiedGenderIdentity = selfIdentifiedGenderIdentity;
    }

    public boolean isDisableSelfIdentifiedGenderIdentity() {
        return disableSelfIdentifiedGenderIdentity;
    }

    public void setDisableSelfIdentifiedGenderIdentity(
            boolean disableSelfIdentifiedGenderIdentity) {
        this.disableSelfIdentifiedGenderIdentity = disableSelfIdentifiedGenderIdentity;
    }
	
	
}