/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.security.CapabilitySet;

import gov.va.med.esr.ui.common.util.DateUtils;

public class RoleForm extends AbstractRoleForm {
    
    private static final long serialVersionUID = 6209075558698381201L;
    
    //User information
    private String roleId;
    private String name;    
    private String description = null;
    private String activeDate = null;
    private String inactiveDate = null;
     
    public RoleForm () {
        super();
        initialize();
    }

    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        initialize();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getActiveDate() {
        return activeDate;
    }

    public void setActiveDate(String activeDate) {
        this.activeDate = activeDate;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInactiveDate() {
        return inactiveDate;
    }

    public void setInactiveDate(String inactiveDate) {
        this.inactiveDate = inactiveDate;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    /**
     * Set assigned Capablities
     * @param assignedCapabilities
     */
    public void setAssignedCapabilities(List assignedCapabilities) {
        //Loop through the list and set the properties
        if (assignedCapabilities != null) {
            Collections.sort(assignedCapabilities);
            for (int i=0; i<assignedCapabilities.size(); i++) {
                Capability capability = (Capability) assignedCapabilities.get(i);
                setAssignedCapabilityCode(i,capability.getCode());
                setAssignedCapabilityName(i,capability.getName()); 
                setAssignedCapabilityInd(i,Boolean.TRUE);  
            }
        }        
    }
        
    /**
     * Set Assigned Capability Sets
     * @param assignedCapabilitySets
     */
    public void setAssignedCapabilitySets(List assignedCapabilitySets) {
        //Loop through the list and set the properties
        if (assignedCapabilitySets != null) {
            Collections.sort(assignedCapabilitySets);
            for (int i=0; i<assignedCapabilitySets.size(); i++) {
                CapabilitySet capabilitySet = (CapabilitySet) assignedCapabilitySets.get(i);                
                setAssignedCapabilitySetId(i,capabilitySet.getEntityKey().getKeyValueAsString());
                setAssignedCapabilitySetName(i,capabilitySet.getName()); 
                setAssignedCapabilitySetInd(i,Boolean.TRUE);  
                setAssignedCapabilitySetActiveDate(i,
                        DateUtils.format(capabilitySet.getActiveDate(),null));
                setAssignedCapabilitySetInactiveDate(i,
                        DateUtils.format(capabilitySet.getInactiveDate(),null));
            }
        }        
    }
            
    /**
     * Initialize 
     */
    private void initialize() {
        roleId = null;
        name = null;
        description = null;
        activeDate = null;
        inactiveDate = null;
    }
}
