/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.ServletRequest;

import org.apache.struts.action.ActionMapping;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.ui.struts.AbstractForm;

import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.SignatureIndicator;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Madhu Katikala (@user)
 */
public class PersonOverviewForm extends AbstractForm {
    
    private static final long serialVersionUID = 3177972848087239132L;

    //Eligibility
    private Integer serviceConnectedPercentage = null;
    private String primaryEligibilityCode = null;
    private EligibilityStatus eligibilityStatus = null;    
    private List secondaryEligibilityCodes = null;
    
//  Health Benefit Plans
    private Integer currentNumberOfHealthBenefitPlans = null;
    
    //Demographic - address
    private String currentMailingAddress = null;
    private String phoneNumber = null;
    private String emergencyResponse = null;
    private String badAddressReason = null;
   
    //Signatue
    private SignatureIndicator signatureOnFile = null;
    private String imageId = null;
    private Date dateIndexed = null;

    
    //Financials
    private String currentTestType = null;
    private String primaryTestType = null;
    private String meansTestStatus = null;
    private String pharmacyCoPayStatus = null;
    private String ltcCoPayStatus = null;
    private String ltcCoPayExemptionStatus = null;
    
    //Enrollment
    private Date applicationDate = null;
    private Date effectiveDateOfChange = null;
    
    //Demographic - Current Status (Live)
    private String currentStatus = null;
    
    //  Handbook
    private boolean handbookInfo = false;
    
    //CCR 11783: the most recent 3 (current + 2 history) handbook & benefit at a glance in decending order
    //List of HandBookInfo objects
    private List handbookHistory = new ArrayList();
    private List benefitGlanceHistory = new ArrayList();
    
    //VHIC Card
    private String vhicCardNum = "No Data";
   	private String vhicCardStatus = "No Data";
    		
    /**
     * 
     */
    public PersonOverviewForm() {
        super();
    }
    public void setPerson(Person person) {
        setVO(person);
    }
    public Person getPerson() {
        return (Person)getVO();
    }
        
    /* (non-Javadoc)
     * @see gov.va.med.fw.ui.struts.AbstractForm#createValueObject()
     */
    protected AbstractEntity createValueObject() {
        return null;
    }
    public String getFormattedSecondaryEligibilityCodes() {
        StringBuffer str = new StringBuffer ();
        if (secondaryEligibilityCodes != null)
            for (int i=0; i<secondaryEligibilityCodes.size(); i++) {
                str.append(secondaryEligibilityCodes.get(i).toString());
                str.append("<br>");
            }
        return str.toString();
    }
    
    public Date getApplicationDate() {
        return applicationDate;
    }
    public String getCurrentMailingAddress() {
        return currentMailingAddress;
    }
    public String getCurrentStatus() {
        return currentStatus;
    }
    public Date getEffectiveDateOfChange() {
        return effectiveDateOfChange;
    }
    public EligibilityStatus getEligibilityStatus() {
        return eligibilityStatus;
    }
    public String getMeansTestStatus() {
        return meansTestStatus;
    }
    public String getPharmacyCoPayStatus() {
        return pharmacyCoPayStatus;
    }
    public String getPhoneNumber() {
        return phoneNumber;
    }
    public String getPrimaryEligibilityCode() {
        return primaryEligibilityCode;
    }
    public String getPrimaryTestType() {
        return primaryTestType;
    }    
    public String getCurrentTestType() {
        return this.currentTestType;
    }
    public void setCurrentTestType(String currentTestType) {
        this.currentTestType = currentTestType;
    }    
    public String getLtcCoPayExemptionStatus() {
        return this.ltcCoPayExemptionStatus;
    }
    public String getLtcCoPayStatus() {
        return this.ltcCoPayStatus;
    }
    public void setLtcCoPayExemptionStatus(String ltcCoPayExemptionStatus) {
        this.ltcCoPayExemptionStatus = ltcCoPayExemptionStatus;
    }
    public void setLtcCoPayStatus(String ltcCoPayStatus) {
        this.ltcCoPayStatus = ltcCoPayStatus;
    }
    public List getSecondaryEligibilityCodes() {        
        return secondaryEligibilityCodes;
    }
    public Integer getServiceConnectedPercentage() {
        return serviceConnectedPercentage;
    }
    
	/**
	 * @return Returns the dateIndexed.
	 */
	public Date getDateIndexed() {
		return dateIndexed;
	}
	/**
	 * @return Returns the imageId.
	 */
	public String getImageId() {
		return imageId;
	}
	/**
	 * @return Returns the signatureOnFile.
	 */
	public SignatureIndicator getSignatureOnFile() {
		return signatureOnFile;
	}
	/**
	 * @param dateIndexed The dateIndexed to set.
	 */
	public void setDateIndexed(Date dateIndexed) {
		this.dateIndexed = dateIndexed;
	}
	/**
	 * @param imageId The imageId to set.
	 */
	public void setImageId(String imageId) {
		this.imageId = imageId;
	}
	/**
	 * @param signatureOnFile The signatureOnFile to set.
	 */
	public void setSignatureOnFile(SignatureIndicator signatureOnFile) {
		this.signatureOnFile = signatureOnFile;
	}
	public void setApplicationDate(Date applicationDate) {
		this.applicationDate = applicationDate;
	}
	public void setCurrentMailingAddress(String currentMailingAddress) {
		this.currentMailingAddress = currentMailingAddress;
	}
	public void setCurrentStatus(String currentStatus) {
		this.currentStatus = currentStatus;
	}
	public void setEffectiveDateOfChange(Date effectiveDateOfChange) {
		this.effectiveDateOfChange = effectiveDateOfChange;
	}
	public void setEligibilityStatus(EligibilityStatus eligibilityStatus) {
		this.eligibilityStatus = eligibilityStatus;
	}
	public void setMeansTestStatus(String meansTestStatus) {
		this.meansTestStatus = meansTestStatus;
	}
	public void setPharmacyCoPayStatus(String pharmacyCoPayStatus) {
		this.pharmacyCoPayStatus = pharmacyCoPayStatus;
	}
	public void setPhoneNumber(String phoneNumber) {
		this.phoneNumber = phoneNumber;
	}
	public void setPrimaryEligibilityCode(String primaryEligibilityCode) {
		this.primaryEligibilityCode = primaryEligibilityCode;
	}
	public void setPrimaryTestType(String primaryTestType) {
		this.primaryTestType = primaryTestType;
	}
	public void setSecondaryEligibilityCodes(List secondaryEligibilityCodes) {
		this.secondaryEligibilityCodes = secondaryEligibilityCodes;
	}
	public void setServiceConnectedPercentage(Integer serviceConnectedPercentage) {
		this.serviceConnectedPercentage = serviceConnectedPercentage;
	}

	public void setCurrentNumberOfHealthBenefitPlans(Integer currentNumberOfHealthBenefitPlans) {
		this.currentNumberOfHealthBenefitPlans = currentNumberOfHealthBenefitPlans;
	}
	
	public Integer getCurrentNumberOfHealthBenefitPlans() {
        return currentNumberOfHealthBenefitPlans;
    }
	
	/**
	 * @return Returns the emergencyResponse.
	 */
	public String getEmergencyResponse() {
		return emergencyResponse;
	}
	/**
	 * @param emergencyResponse The emergencyResponse to set.
	 */
	public void setEmergencyResponse(String emergencyResponse) {
		this.emergencyResponse = emergencyResponse;
	}

    public String getBadAddressReason()
    {
        return badAddressReason;
    }

    public void setBadAddressReason(String badAddressReason)
    {
        this.badAddressReason = badAddressReason;
    }
    
    public boolean getHandbookInfo() {
		return handbookInfo;
	}
	
	public void setHandbookInfo(boolean handbookInfo) {
		this.handbookInfo = handbookInfo;
	}

    /**
	 * reset form data
	 */
	public void reset(ActionMapping arg0, ServletRequest arg1) {
		super.reset(arg0, arg1);
	    //Eligibility
	    serviceConnectedPercentage = null;
	    primaryEligibilityCode = null;
	    eligibilityStatus = null;    
	    secondaryEligibilityCodes = null;
	    
	    //Health Benefit Plans
	    currentNumberOfHealthBenefitPlans = null;
	    
	    //Demographic - address
	    currentMailingAddress = null;
	    phoneNumber = null;
	    emergencyResponse= null;
        badAddressReason = null;

        //Financials
        currentTestType = null;
	    primaryTestType = null;
	    meansTestStatus = null;
	    pharmacyCoPayStatus = null;
        ltcCoPayStatus = null;
        ltcCoPayExemptionStatus = null;
	    
	    //Enrollment
	    applicationDate = null;
	    effectiveDateOfChange = null;
	    
	    //Demographic - Current Status (Live)
	    currentStatus = null;
	    
	   //VHIC Card
	    vhicCardNum = null;
	   	vhicCardStatus = null;
	    
	}
	
	public List getBenefitGlanceHistory() {
		return benefitGlanceHistory;
	}
	public void setBenefitGlanceHistory(List benefitGlanceHistory) {
		this.benefitGlanceHistory = benefitGlanceHistory;
	}
	public List getHandbookHistory() {
		return handbookHistory;
	}
	public void setHandbookHistory(List handbookHistory) {
		this.handbookHistory = handbookHistory;
	}
	public String getVhicCardNum() {
		return vhicCardNum;
	}
	public void setVhicCardNum(String vhicCardNum) {
		this.vhicCardNum = vhicCardNum;
	}
	public String getVhicCardStatus() {
		return vhicCardStatus;
	}
	public void setVhicCardStatus(String vhicCardStatus) {
		this.vhicCardStatus = vhicCardStatus;
	}
	
}
