/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

// Java classes
import java.util.List;
import net.mlw.vlh.ValueList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Library classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// ESR classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.conversion.UIConversionService;
import gov.va.med.fw.ui.struts.ValueListActionUtils;

/**
 * Displays the Person Overview screen.
 *
 * @author Madhu Katikala and Andrew Pach
 * @version 3.0
 */
public class PersonOverviewAction extends PersonAbstractAction
{
    public ActionForward display(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Get the Person object from the cache
        Person person = getSelectedPerson(request);

        PersonOverviewForm overviewForm = (PersonOverviewForm)form;
        overviewForm.setPerson(person);

        UIConversionService uiConversionService = (UIConversionService)conversionService;
        uiConversionService.convert(person, overviewForm);

        // CCR11783
        List handbookLs = overviewForm.getHandbookHistory();
           
        // Get the value list information from the future EGT Settings list
        ValueList valueList = ValueListActionUtils.getValueList(form,
        		request, "handbookTableId", "commsLogAdapter", handbookLs);

        // Backup the ValueListInfo into session and store the resultant ValueList on the request
        ValueListActionUtils.setValueList(request, valueList, "vlhlist");
        
        List benefitAtGlanceLs = overviewForm.getBenefitGlanceHistory();
        
        // Get the value list information from the future EGT Settings list
        ValueList valueList2 = ValueListActionUtils.getValueList(form,
        		request, "benefitsTableId", "commsLogAdapter", benefitAtGlanceLs);

        // Backup the ValueListInfo into session and store the resultant ValueList on the request
        ValueListActionUtils.setValueList(request, valueList2, "vhlbenefit");
        //End of CCR11793
        
        return mapping.findForward("success");
    }

    public void afterPropertiesSet() throws Exception
    {
    }
}