/*********************************************************************
 * Copyright  2009 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

// Java Classes
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/**
 * Struts Action Form for person merge worklist search screen.
 * 
 */
public class PersonMergeWorklistSearchActionForm extends AbstractForm {
	private static final long serialVersionUID = 3713850842945159892L;

	private static final String MINIMUM_REQUIRED_FIELDS = "error.searchCriteria.required";
	private static final String FIRST_NAME_REQUIRED = "error.firstName.required";
	private static final String DOB_REQUIRED = "error.dateOfBirth.required";
	private static final String VPID_EXCLUSIVE_SEARCH_ONLY = "error.vpid.exclusivesearchonly";
// CCR13257 - INC000000956617
	private static final String FIRST_NAME_OR_DOB_REQUIRED = "error.firstNameOrDOB.required";
	
	private String ssn = null;
	private String givenName = null;
	private String middleName = null;
	private String familyName = null;
	private String dateOfBirth = null;
	private String gender = null;
	private String claimFolderNumber = null;
	private String militaryServiceNumber = null;
	private String selectedPersonId = null;
	private String extscHiddenId = null;
	private String vpid = null;

	public String getSsn() {
		return ssn;
	}

	public String getUnformattedSsn() {
		String value = ssn;
		if (value != null) {
			value = value.replaceAll("-", "");
		}
		return value;
	}

	public void setSsn(String value) {
		ssn = value;
	}

	public String getFamilyName() {
		return familyName;
	}

	public void setFamilyName(String value) {
		familyName = value;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String value) {
		middleName = value;
	}

	public String getGivenName() {
		return givenName;
	}

	public void setGivenName(String value) {
		givenName = value;
	}

	public String getDateOfBirth() {
		return dateOfBirth;
	}

	public void setDateOfBirth(String dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getClaimFolderNumber() {
		return claimFolderNumber;
	}

	public void setClaimFolderNumber(String claimFolderNumber) {
		this.claimFolderNumber = claimFolderNumber;
	}

	public String getMilitaryServiceNumber() {
		return militaryServiceNumber;
	}

	public void setMilitaryServiceNumber(String militaryServiceNumber) {
		this.militaryServiceNumber = militaryServiceNumber;
	}

	public String getVpid() {
		return this.vpid;
	}

	public void setVpid(String vpid) {
		this.vpid = vpid;
	}

	public String getSelectedPersonId() {
		return selectedPersonId;
	}

	public void setSelectedPersonId(String selectedPersonId) {
		this.selectedPersonId = selectedPersonId;
	}

	public String getExtscHiddenId() {
		return extscHiddenId;
	}

	public void setExtscHiddenId(String extscHiddenId) {
		this.extscHiddenId = extscHiddenId;
	}

	public Boolean getAdditionalSearchCriteriaPresent() {
		if (StringUtils.trimToNull(this.claimFolderNumber) != null
				|| StringUtils.trimToNull(this.militaryServiceNumber) != null
				|| StringUtils.trimToNull(this.middleName) != null
				|| StringUtils.trimToNull(this.gender) != null) {
			// Additional search criteria has been specified
			return Boolean.TRUE;
		} else {
			return Boolean.FALSE;
		}
	}

	/**
	 * Clear the form data used on the server side
	 */
	public void clear() {
		ssn = null;
		givenName = null;
		middleName = null;
		familyName = null;
		dateOfBirth = null;
		gender = null;
		claimFolderNumber = null;
		militaryServiceNumber = null;
		selectedPersonId = null;
		vpid = null;
	}

	public ActionMessages validateForm(ActionMapping mapping,
			HttpServletRequest request) {
		String ssnValue = StringUtils.trimToNull(this.ssn);
		String vpidValue = StringUtils.trimToNull(this.vpid);
		String familyNameValue = StringUtils.trimToNull(this.familyName);
		String givenNameValue = StringUtils.trimToNull(this.givenName);
		String dateOfBirthValue = StringUtils.trimToNull(this.dateOfBirth);
		String claimFolderNumberValue = StringUtils
				.trimToNull(this.claimFolderNumber);
		String militaryServiceNumberValue = StringUtils
				.trimToNull(this.militaryServiceNumber);
		String genderValue = StringUtils.trimToNull(this.gender);

		List errorMessages = new ArrayList();

		// Check for exclusive VPID search
		if (vpidValue != null) {
			if (ssnValue == null && familyNameValue == null
					&& givenNameValue == null && dateOfBirthValue == null
					&& claimFolderNumberValue == null && genderValue == null
					&& militaryServiceNumberValue == null) {
				return null;
			} else {
				errorMessages
						.add(new ActionMessage(VPID_EXCLUSIVE_SEARCH_ONLY));
			}
		} else {

			// Check for minimum required fields
			if (ssnValue != null || claimFolderNumberValue != null
					|| militaryServiceNumberValue != null) {
				return null;
			}

			if (familyNameValue != null) {
				if (givenNameValue == null && dateOfBirthValue == null) {
// CCR13257 - INC000000956617  comment out FIRST_NAME_REQUIRED add FIRST_NAME_OR_DOB_REQUIRED									
//					errorMessages.add(new ActionMessage(FIRST_NAME_REQUIRED));
					errorMessages.add(new ActionMessage(FIRST_NAME_OR_DOB_REQUIRED));
				}
			} else {
				errorMessages.add(new ActionMessage(MINIMUM_REQUIRED_FIELDS));
			}
		}

		if (errorMessages.size() > 0) {
			ActionMessages messages = new ActionMessages();
			for (int i = 0; i < errorMessages.size(); i++)
				messages.add(ActionMessages.GLOBAL_MESSAGE,
						(ActionMessage) errorMessages.get(i));
			return messages;
		} else {
			return null;
		}
	}
}