// Package 
package gov.va.med.esr.ui.admin.action;

// Java Classes
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;
import java.util.Comparator;
import java.util.Collections;

// Library Classes
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.log4j.Logger;

// Framework Classes
import gov.va.med.fw.ui.valuelist.SearchValueListAdapter;
import gov.va.med.fw.util.SortElement;
import gov.va.med.fw.util.StringUtils;

/**
 * A custom value list adapter for the available reports.
 */
public class Log4jValueListAdapter extends SearchValueListAdapter
{
    private static final long serialVersionUID = 5479718842749865481L;
    private static Comparator logLevelComparator = new LogComparator();
    private static Comparator parentlogComparator = new ParentLogComparator();
    private static final int NO_ROOT_ELEMENTS=1;

    /**
     * Sorts the results list using the sort elements.
     *
     * @param results The results to sort
     * @param sortElements The sort elements
     */
    protected void performSort(List results, List sortElements)
    {
    	List rootElements=new ArrayList();
        if ((sortElements != null) && (sortElements.size() > 0) && (results != null) &&
            (results.size() > 0))
        {
        	for(int i=0; i< NO_ROOT_ELEMENTS; i++)
        	{
        		rootElements.add(results.remove(0));
        	}        	
            ComparatorChain chain = new ComparatorChain();
            for (Iterator iterator = sortElements.iterator(); iterator.hasNext();)
            {
                // Get the sort element and defined a default NullComparator
                SortElement sortElement = (SortElement)iterator.next();
                Comparator sortComparator = new NullComparator(); 
                // If sorting on the standardReport.code, add a custom comparator to handle
                // proper sorting on the alphabetic and numeric portions of the code.
                if ("effectiveLevel".equals(sortElement.getSortColumn()))                
                    sortComparator = logLevelComparator;                
                else if("parent".equals(sortElement.getSortColumn()))
                	sortComparator = parentlogComparator;
                chain.addComparator(
                    new BeanComparator(sortElement.getSortColumn(), sortComparator),
                    sortElement.getSortDirection().equals(SortElement.DESCENDING));
            }
            Collections.sort(results, chain);
            results.addAll(0, rootElements);
        }
    }
}
/**
 * Log Level Comparator.
 * @author DNS   KULLAV
 *
 */
    class LogComparator implements Comparator, Serializable
    {
    	 private static final long serialVersionUID = 4266052596461051197L;

         public int compare(Object object1, Object object2)
         {
        	
         	String str1=object1!=null?object1.toString():"";
         	String str2=object2!=null?object2.toString():"";                   	
             return StringUtils.compareTo(str1, str2);   
            
         }
       
    }

    class ParentLogComparator implements Comparator, Serializable
    {
        private static final long serialVersionUID = 4266052596461051197L;

        public int compare(Object object1, Object object2)
        {
        	Logger logger1=(Logger)object1;
        	Logger logger2=(Logger)object2;
        	String str1=logger1!=null?logger1.getName():"";
        	String str2=logger2!=null?logger2.getName():"";        	
            return StringUtils.compareTo(str1, str2);            
        }
       
    }

