/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import gov.va.med.esr.ui.ApplicationConstants.MessageKeys;
import gov.va.med.fw.security.EncryptionServiceException;
import gov.va.med.fw.ui.DelegatingActionUtils;
import gov.va.med.fw.ui.security.UIEncryptionService;
import gov.va.med.fw.ui.struts.AbstractForm;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.springframework.web.context.WebApplicationContext;

import gov.va.med.esr.ui.ApplicationConstants.MessageKeys;
import gov.va.med.fw.util.StringUtils;

/**
 * Common fields for report actions.
 * 
 * @author Venky Kullampalle
 * @version 1.0
 */
public class Log4jForm extends AbstractForm {

	private static final long serialVersionUID = -7091858596747837785L;
	private String loggerFilter;
	public static final String PATTERN_REGEX = "[\\s\\w=.]*"; // #########

	public void initialize() {
		this.loggerFilter = null;

	}

	public String getLoggerFilter() {
		return loggerFilter;
	}

	public void setLoggerFilter(String loggerFilter) {
		this.loggerFilter = loggerFilter;
	}

	@Override
	public ActionMessages validateForm(ActionMapping mapping,
			HttpServletRequest request) {
		ActionMessages messages = new ActionMessages();
		Map<String, String[]> parameterMap = request.getParameterMap();
		for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
			String key = entry.getKey();
			String[] values = entry.getValue();
			if (!key.equals("OWASP_CSRFTOKEN") && !key.equals("org.apache.struts.taglib.html.TOKEN")) {
				if (key != null) {
					if (StringUtils.validateEntry(key, PATTERN_REGEX)) {
						if (StringUtils.contains(key, "--")) {
							messages.add(ActionMessages.GLOBAL_MESSAGE,
									new ActionMessage(
											MessageKeys.ERRORS_DETAIL, key
													+ " is invalid"));
						}
					} else {
						messages.add(ActionMessages.GLOBAL_MESSAGE,
								new ActionMessage(MessageKeys.ERRORS_DETAIL,
										key + " is invalid"));
					}
				}

				if (values != null) {
					for (int i = 0; i < values.length; i++) {
						String value = values[i];
						boolean validateValue = true;
						if (key.equals("encry")) {
							validateValue = false;
						}
						if (validateValue) {
							if (StringUtils.validateEntry(value, PATTERN_REGEX)) {
								if (StringUtils.contains(value, "--")) {
									messages.add(ActionMessages.GLOBAL_MESSAGE,
											new ActionMessage(
													MessageKeys.ERRORS_DETAIL,
													value + " is invalid"));
								}
							} else {
								messages.add(ActionMessages.GLOBAL_MESSAGE,
										new ActionMessage(
												MessageKeys.ERRORS_DETAIL,
												value + " is invalid"));
							}
						}
					}
				}
			}
		}

		return messages;
	}

}
