package gov.va.med.esr.ui.admin.action;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.mlw.vlh.ValueList;

import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import gov.va.med.esr.common.model.messaging.IrsTransmissionLogDetailEntry;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogEntry;

import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.fw.ui.struts.ValueListActionUtils;

public class IrsRejectAction extends AbstractAction {


    public IrsRejectAction() {
        super();
    }

    /**
     * display
     * @param mapping
     * @param form
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    public ActionForward display(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {

        return mapping.findForward("irsRejectBatch");

    }

    public ActionForward displayIrsRejectBatch(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {

		List<IrsTransmissionLogEntry> submissions = this.getIrsTransmissionService().getFailedBatchTransmissions();

		if (submissions != null && submissions.isEmpty()) submissions = null;

		if (submissions != null) {
			Collections.sort(submissions, new BeanComparator(
					"transmissionDate", new NullComparator()));

			Collections.reverse(submissions);
		}

		request.setAttribute("submissions", submissions);
        return mapping.findForward("irsRejectBatch");

    }

    public ActionForward resubmit(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
		String submissionId = request.getParameter(("submissionId"));

		this.getIrsTransmissionService().retransmitFailedSubmission(new BigDecimal(submissionId));

		this.addInformationMessage(request, "resubmitFailure");
    	return displayIrsRejectBatch(mapping,form,request,response);
    }

    public ActionForward resubmitPerson(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
		String submissionId = request.getParameter(("submissionId"));

		this.getIrsTransmissionService().retransmitFailedPersonSubmission(new BigDecimal(submissionId));

		this.addInformationMessage(request, "resubmitFailure");
    	return displayIrsRejectPerson(mapping,form,request,response);
    }

    public ActionForward displayIrsRejectPerson(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
    	List submissions = this.getIrsTransmissionService().getFailedPersonTransmissions();
    	//if (submissions != null && submissions.isEmpty()) submissions = null;

    	Collections.sort(submissions, new BeanComparator(
				"batchTransmissionEntry.transmissionDate", new NullComparator()));

		Collections.reverse(submissions);

        // Get the value list information
        ValueList valueList = ValueListActionUtils.getValueList(form,
            request, "irsPersonTableId", "irsRejectPersonAdapter", submissions);

        // Backup the ValueListInfo into session and store the resultant ValueList on the request
        ValueListActionUtils.setValueList(request, valueList, "vlhlist");


    	request.setAttribute("submissions", submissions);

        return mapping.findForward("irsRejectPerson");

    }

    public void afterPropertiesSet() throws Exception {
        // TODO Auto-generated method stub
    }

    protected Map getKeyMethodMap()
    {
        Map map = new HashMap();
        map.put("button.display", "display");
        map.put("title.irsReject", "displayIrsRejectBatch");
        map.put("title.irsRejectP", "displayIrsRejectPerson");
        map.put("link.irsReject.resubmit", "resubmit");
        map.put("Resubmit", "resubmit");
        map.put("link.irsReject.resubmitPerson", "resubmitPerson");
        map.put("Resubmit Person", "resubmitPerson");
        return map;
    }





}
