/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.fw.util.StringUtils;

public class HomePageAction extends AbstractAction {

    public ActionForward display(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
        {
    		if (isAnyPermissionGranted(split(Capability.SEARCH)))
    			return mapping.findForward("veteranSearch");
    	
    		//worklist
    		if (isAnyPermissionGranted(split(Capability.MANAGE_WORKLIST)))
    			return mapping.findForward("worklist");

    		//Merge 
    		if (isAnyPermissionGranted(split(Capability.MERGE_VETERAN)))
    			return mapping.findForward("veteranMerge");
    		if (isAnyPermissionGranted(split(Capability.MERGE_DEPENDENTS)))
    			return mapping.findForward("dependentMerge");
    		if (isAnyPermissionGranted(split(Capability.UNMERGE_VETERAN_MERGED_PAIRS.getName())))
    			return mapping.findForward("veteranUnmerge");

    		//system parameters
    		if (isAnyPermissionGranted(split(Capability.MANAGE_SYSTEM_PARAMETERS)))
    			return mapping.findForward("parameters");
    		
            return mapping.findForward("success");	//default home page
        }

    	private String[] split(String delimitedList) {
    		if (StringUtils.isEmpty(delimitedList)) {
    			return null;
    		}
    		else {
    			return delimitedList.split(",");
    		}
    	}
        public void afterPropertiesSet() throws Exception
        {
        }
}
