/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.esr.common.model.lookup.HealthBenefitPlanCategory;
import gov.va.med.esr.common.model.hbp.HealthBenefitPlanDefinition;
import gov.va.med.esr.common.model.hbp.HealthBenefitPlanDescription;
import gov.va.med.esr.common.model.hbp.HealthBenefitPlanName;
import gov.va.med.esr.service.HBPDefinitionService;

import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;

public class HbpInformationConversionService extends UIConversionServiceImpl{

    private HBPDefinitionService hbpDefinitionService = null;
    
    public HbpInformationConversionService() {
        super();
    }
    
    public HBPDefinitionService getHbpDefinitionService() {
        return hbpDefinitionService;
    }

    public void setHbpDefinitionService(HBPDefinitionService hbpDefinitionService) {
        this.hbpDefinitionService = hbpDefinitionService;
    }
    
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        try {
            if (source instanceof HealthBenefitPlanName && target instanceof HbpPlanNameForm) {
                convert((HealthBenefitPlanName)source,(HbpPlanNameForm)target);
            }
            else if (source instanceof HbpPlanNameForm && target instanceof HealthBenefitPlanName) {
                convert((HbpPlanNameForm)source,(HealthBenefitPlanName)target);
            }
            else if (source instanceof HealthBenefitPlanDefinition && target instanceof HbpInformationForm) {
                convert((HealthBenefitPlanDefinition)source, (HbpInformationForm) target);
            }
            else if (source instanceof HbpInformationForm && target instanceof HealthBenefitPlanDefinition) {
                convert((HbpInformationForm)source, (HealthBenefitPlanDefinition)target);
            }
            else 
            {
                throw new Exception("Conversion is not supported");
            }
        }catch (Exception e) {
            throw new ConversionServiceException("Can not convert from " + 
                source.getClass().getName() + " to " + target.getClass().getName(),e); 
        }
    }
    
    /**
     * Convert from set to form
     * @param capabilitySet
     * @param setForm
     * @throws Exception
     */
    
    /*
    private void convert(CapabilitySet capabilitySet, CapabilitySetForm setForm) 
    throws Exception {
        //CapabilitySet could be an unsaved CapabilitySet retuned from Confirmation 
        if (capabilitySet.getEntityKey() != null)
            setForm.setCapabilitySetId(capabilitySet.getEntityKey().getKeyValueAsString());
        
        setForm.setName(capabilitySet.getName());
        setForm.setDescription(capabilitySet.getDescription());
        setForm.setActiveDate(DateUtils.format(capabilitySet.getActiveDate(),null));
        setForm.setInactiveDate(DateUtils.format(capabilitySet.getInactiveDate(),null));
        
        List availableCapabilities = getUserAdminService().getAllCapabilities();        
                
        List assignedCapabilities = new ArrayList (capabilitySet.getCapabilities());

        setForm.setAssignedCapabilities(assignedCapabilities);
        availableCapabilities.removeAll(assignedCapabilities);
        setForm.setAvailableCapabilities(availableCapabilities);            
    }
    */
    /**
     * convert from from to set
     * @param form
     * @param set
     * @throws Exception
     */
    
    /*
    private void convert(CapabilitySetForm form, CapabilitySet set) throws Exception {
        
        //Exclude read only fields while updating an existing Capability Set
        if (set.getEntityKey() == null) {
            set.setName(form.getName());
            set.setDescription(form.getDescription());
        }
        else {

        }
        set.setActiveDate(DateUtils.getDate(form.getActiveDate()));
        set.setInactiveDate(DateUtils.getDate(form.getInactiveDate()));
        
        //Add the selected Capabilities
        //Note: The array could be incomplete or empty as unchecked check boxes are not included 
        List addList = new ArrayList ();
        List idList = form.getCapabilityIndList();
        if (idList != null && idList.size() > 0) {
            for (int i=0; i<idList.size(); i++) {
                //Check whether this capabilitye has been checked
                Boolean selected = (Boolean) form.getCapabilityInd(i);
                if (Boolean.TRUE.equals(selected)) {
                    //get the Capability from lookup service
                    Capability capability = (Capability)
                        getLookupCacheService().getByCodeFromCache(
                                Capability.class, form.getCapabilityCode(i));
                    addList.add(capability);
                }
            }
        }

        //Process Previoulsy assigned list in the edit case        
        idList = form.getAssignedCapabilityCodeList();
        if (idList != null && idList.size() > 0) {
            for (int i=0; i<idList.size(); i++) {
                //Check whether this capabilitye has been checked
                Boolean selected = (Boolean) form.getAssignedCapabilityInd(i);
                //get the Capability from lookup service
                Capability capability = (Capability)
                    getLookupCacheService().getByCodeFromCache(
                            Capability.class, form.getAssignedCapabilityCode(i));                
                if (Boolean.TRUE.equals(selected)) {
                    addList.add(capability);                    
                }
            }        
        }
        */

}
