/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.ui.common.beans.FieldHistoryInfo;
import gov.va.med.esr.ui.common.util.DateUtils;

public class HbpInformationAction extends AbstractHbpInformationAction {
    
    public static final String FWD_DISPLAY_OVERVIEW = "displayHbps"; 
    public static final String FWD_EDIT_PLAN_NAME = "editHbpPlanName";
    public static final String FWD_EDIT_HBP = "editHbp";
    public static final String FWD_ADD_PLAN_NAME = "addHbpPlanName";
    public static final String FWD_ADD_HBP = "addHbp";
    public static final String FWD_TEMP_HISTORY = "tempHistory";
    
    public static final String PAR_PlAN_NAME_ID = "planNameId";
    public static final String ATTR_PLAN_NAME_SETS = "PlanNameSets";
    public static final String ATTR_HBP_DEFINITION_SETS = "HbpDefinitionSets";

    public static final String FIELD_NAME = "name";
    public static final String MSG_ACTIVE_DATE_INVALID = "error.activeDate";
    public static final String FLD_ACTIVE_DATE = "activeDate";
    public static final String FLD_INACTIVE_DATE = "inactiveDate";

    
    public HbpInformationAction() {
        super();
    }
    /**
     * Display all capability sets
     * @param mapping
     * @param form
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    
    public ActionForward displayHbps(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        clearSessionData(request);
        
        // error throws Jean fixed it
         List allPlanNames= getHbpDefinitionService().getAllHealthBenefitPlanNames();
      
        
       // List allPlanNames = new ArrayList();
        
       // System.out.println("At DisplayHbps:all plan Names set size = " + allPlanNames.size());
        
         Collections.sort(allPlanNames);      
        // error out - java.lang.ClassCastException: gov.va.med.esr.common.model.hbp.HealthBenefitPlanName cannot be cast to java.lang.Comparable
       
         request.setAttribute(ATTR_PLAN_NAME_SETS,allPlanNames);
 
        return mapping.findForward(FWD_DISPLAY_OVERVIEW);
    }
    
    
    public ActionForward display(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
             
        return mapping.findForward(FWD_DISPLAY_OVERVIEW);
    }

  
    public ActionForward add(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // System.out.println("In action class add method ");
        if (form instanceof HbpInformationForm) {
            // return super.clear(mapping,form,request,response);
            // System.out.println("In add method Form is HbpInformationForm!");
               return addNewHbp(mapping, form, request, response);
         }
         //clear from edit screen  edit(mapping, form, request, response); from UserProfileAction.java
         else {
             // System.out.println("In add method Form is HbpPlanNameForm!");
             return addNewPlanName(mapping, form, request, response);
         }  
    }
    
    public ActionForward update(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // System.out.println("In action class add method ");
        if (form instanceof HbpInformationForm) {
            // return super.clear(mapping,form,request,response);
            // System.out.println("In add method Form is HbpInformationForm!");
               return editHbp(mapping, form, request, response);
         }
         //clear from edit screen  edit(mapping, form, request, response); from UserProfileAction.java
         else {
             // System.out.println("In add method Form is HbpPlanNameForm!");
             return editPlanName(mapping, form, request, response);
         }  
    }
    
    /**
     * Edit an existing Capability Set
     */
    /*
    public ActionForward edit(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        //we don't need to reset the form as it is request scoped        
        String setId = request.getParameter(PAR_CAPABILITY_SET_ID);
        Validate.notNull(setId,"Capability Set Id can not be null");
        
        //Create Entity Key
        EntityKey entityKey = EntityKeyFactory.createEntityKey(new BigDecimal(setId), CapabilitySet.class);

        //Get Admin service and Retrieve the Capability Set
        CapabilitySet capabilitySet = getUserAdminService().getCapabilitySetById(entityKey);
        
        //place the pristine entity in the session
        setPristineEntity(request,capabilitySet);

        //Convert the set to from and frward to edit screen
        conversionService.convert(capabilitySet,form);
        
        return mapping.findForward(FWD_EDIT);
    }    
    
    public ActionForward add(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        //Validate name for uniqueness
        String setName = ((CapabilitySetForm)form).getName().trim();
        if (getUserAdminService().getCapabilitySetByName(setName) != null) {
            addActionMessageForField(request,MSG_SET_NAME_DUPLICATE,FIELD_NAME);
            return mapping.getInputForward();
        }
        
        CapabilitySet newSet = new CapabilitySet();
        
        //convert from from to set
        conversionService.convert(form,newSet);
        setPristineEntity(request,null);
        setUpdatedEntity(request,newSet);
        
        //Check for Minimum number of required capabilities
        if (isValid(request,newSet)) {
            //Forward to confirmation page
            return confirmation(mapping,form,request,response);   
        }
        return mapping.getInputForward();     
    }
  
    public ActionForward update(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        //validate from
        CapabilitySetForm setForm = (CapabilitySetForm) form;
       
        CapabilitySet pristine = (CapabilitySet) getPristineEntity(request);
        CapabilitySet updated = (CapabilitySet) pristine.clone();
        
        //convert
        conversionService.convert(setForm, updated);
        setUpdatedEntity(request,updated);
        
        //Check for Minimum number of required capabilities
        if (isValid(request,updated)) {
            //Forward to confirmation page
            return confirmation(mapping,form,request,response);   
        }
        return mapping.getInputForward();        
    }

    public ActionForward accept(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        //Get the updated capability set from the session
        CapabilitySet capabilitySet = (CapabilitySet)getUpdatedEntity(request);
        
        if (capabilitySet.getEntityKey() == null ) {
            //add
            getUserAdminService().addCapabilitySet(capabilitySet);
            return mapping.findForward(FWD_DISPLAY_ADD_MSG);
        }
        else {
            //update
            getUserAdminService().updateCapabilitySet(capabilitySet);
            return mapping.findForward(FWD_DISPLAY_UPDATE_MSG);
        }
    }
    
    public ActionForward revise(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        //Retrive the capability set from the session and forward to edit screen
        CapabilitySet capabilitySet = (CapabilitySet)getUpdatedEntity(request);        
        conversionService.convert(capabilitySet,form);           
        return mapping.findForward(FWD_EDIT);
    }

*/
    
    // discard is action method of cancel button
    public ActionForward discard(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        //return the display list discarding all changes     
        // System.out.println("In action class cancel button - discard method");
        // form.reset(mapping,request);
        return displayHbps(mapping, form, request, response);
       // return mapping.findForward(FWD_DISPLAY_OVERVIEW);
    }
       
    
    /**
     * discard the changes and forward back to edit screen
     */
    public ActionForward clear(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
       // System.out.println("In action class clear method ");
        //clear from search action
        form.reset(mapping,request);
        
        if (form instanceof HbpInformationForm) {
           // return super.clear(mapping,form,request,response);
           // System.out.println("Form is HbpInformationForm!");
              return addNewHbp(mapping, form, request, response);
        }
        //clear from edit screen
        else {
          //  System.out.println("clear method Form is HbpPlanNameForm!");
            return addNewPlanName(mapping, form, request, response);
        }  
    }
    
    public void afterPropertiesSet() throws Exception {
        // TODO Auto-generated method stub
    }
    
  
    public ActionForward addNewPlanName(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        //we don't need to reset the form as it is request scoped        
      //  HbpPlanNameForm setForm = (HbpPlanNameForm) form;  error the form is HbpInformationForm
        return mapping.findForward(FWD_ADD_PLAN_NAME);
    }
    
    public ActionForward editPlanName(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        //we don't need to reset the form as it is request scoped        
      //   HbpPlanNameForm setForm = (HbpPlanNameForm) form;
        return mapping.findForward(FWD_EDIT_PLAN_NAME);
    }
    
    
    public ActionForward addNewHbp(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        //we don't need to reset the form as it is request scoped        
      //  HbpInformationForm setForm = (HbpInformationForm) form;
        return mapping.findForward(FWD_ADD_HBP);
    }
 
    public ActionForward editHbp(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        //we don't need to reset the form as it is request scoped        
      //  HbpInformationForm setForm = (HbpInformationForm) form;
        return mapping.findForward(FWD_EDIT_HBP);
    }
    
    public ActionForward viewHistoryNotDone(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        //we don't need to reset the form as it is request scoped        
     //   HbpInformationForm setForm = (HbpInformationForm) form;
        return mapping.findForward(FWD_TEMP_HISTORY);
    }

    
    protected Map getKeyMethodMap()
    {
        Map map = new HashMap();
        map.put("button.cancel", "discard");
        map.put("button.revise", "revise");
        map.put("button.clear", "clear");
        
        map.put("button.displayNew", "displayHbps");
        map.put("button.addPlanName",  "addNewPlanName" );
        map.put("button.editPlanName",  "editPlanName" );
        map.put("button.addHbp",  "addNewHbp" );
        map.put("button.editHbp",  "editHbp" );
        
        map.put("button.display", "display");
        map.put("button.add", "add");
        map.put("button.update", "update");
        map.put("button.edit", "edit");

        map.put("button.viewHistory",  "viewHistoryNotDone" );
        return map;
    }    
}
