package gov.va.med.esr.ui.admin.action;
 


import gov.va.med.esr.common.model.comms.HandbookBatchFileProcessStatistics;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.admin.action.HandBookBatchFileProcessForm;
import gov.va.med.fw.service.ServiceConfigurationException;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


public class HandBookBatchFileProcessAction extends AbstractAction {
	
		
    public static final String FORWARD_HANDBOOK_FILE_DATE_FILTER = "displayHandbookFileDateFilter";
    public static final String FORWARD_HANDBOOK_FILE_STATISTICS = "displayHandbookFileStatistics";
	
	
		
	public ActionForward displayHandbookFileDateFilter(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
									
			HandBookBatchFileProcessForm hbfProcessForm = getHandBookBatchFileProcessForm(form); 
			if((hbfProcessForm.getHbfDateList() == null) || (hbfProcessForm.getHbfDateList().size() == 0)) {
				List<Date> dateList = getHandBookService().getHandbookBatchFileProcessDateList();
				Format formatter = new SimpleDateFormat("MM/dd/yyyy");
				List<String> dateListStr = new ArrayList<String>();
				
				for (Iterator iter = dateList.iterator(); iter.hasNext();) {
				dateListStr.add(formatter.format(iter.next()));
				}
				request.setAttribute("Date_Change_Event_Keys",dateListStr);
		        hbfProcessForm.setHbfDateList(dateListStr);
			}
			else 
				 request.setAttribute("Date_Change_Event_Keys",hbfProcessForm.getHbfDateList());
				
		   return mapping.findForward(FORWARD_HANDBOOK_FILE_DATE_FILTER);
	}
	
    protected HandBookBatchFileProcessForm getHandBookBatchFileProcessForm(ActionForm form) throws ServiceConfigurationException
    {
    	HandBookBatchFileProcessForm hbfProcessForm =
            (form instanceof HandBookBatchFileProcessForm) ? (HandBookBatchFileProcessForm) form : null;
 
        if (hbfProcessForm == null)
        {
            throw new ServiceConfigurationException("HandBookBatchFileProcessForm not properly configured.");
        }
        return hbfProcessForm; 
    }
	
	
    
    public ActionForward displayHandbookFileStatistics(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
    	
    	  // Get the HandBookBatchFileProcess form
    	HandBookBatchFileProcessForm hbfProcessForm = getHandBookBatchFileProcessForm(form); ;
        

        // Set the newly selected date
        String selectedDateStr = new String(hbfProcessForm.getSelectedDate());
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy"); 
		Date selectedDate = dateFormat.parse(selectedDateStr); 
        
        Date minJobStartDate = getHandBookService().getHandbookBatchFileProcessMinJobStartDate(selectedDate);
		
		Date maxJobEndDate = getHandBookService().getHandbookBatchFileProcessMaxJobEndDate(selectedDate);
		
		 hbfProcessForm.setMinJobStartDate(minJobStartDate);
		 hbfProcessForm.setMaxJobEndDate(maxJobEndDate);
	       
		 HandbookBatchFileProcessStatistics handBookBatchFileProcessStatistics = getHandBookService().getHandbookBatchFileProcessStatistics(selectedDate, minJobStartDate, maxJobEndDate);
		if (handBookBatchFileProcessStatistics != null )
			request.setAttribute("handBookBatchFileProcessStat", handBookBatchFileProcessStatistics);

       return mapping.findForward(FORWARD_HANDBOOK_FILE_STATISTICS);
	} 
    
    
  
    
	/**
	 * Initialize and get the Struts lookup dispatch method map hashmap.
	 * 
	 * @return the method map
	 * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
	 */
	protected Map getKeyMethodMap() {
		Map map = new HashMap();
		map.put("link.handBookBatchRequest.handbookFileDateFilters", "displayHandbookFileDateFilter");
		map.put("button.viewData", "displayHandbookFileStatistics");
		
		return map;
	}

	public void afterPropertiesSet() throws Exception {
		//  Auto-generated method stub
		
	}

}