/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;


import gov.va.med.esr.common.model.lookup.Capability;

public class CapabilitySetForm extends AbstractCapabilitySetForm {
    
    private static final long serialVersionUID = 6576762803257948026L;

    //Set attributes
    private String name = null;
    private String description = null;
    private String activeDate = null;
    private String inactiveDate = null;
    private String capabilitySetId = null;

    public CapabilitySetForm () {
        super();
        initialize();
    }

    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        initialize();
    }
    
    public String getActiveDate() {
        return activeDate;
    }

    public void setActiveDate(String activeDate) {
        this.activeDate = activeDate;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInactiveDate() {
        return inactiveDate;
    }

    public void setInactiveDate(String inactiveDate) {
        this.inactiveDate = inactiveDate;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCapabilitySetId() {
        return capabilitySetId;
    }

    public void setCapabilitySetId(String capabilitySetId) {
        this.capabilitySetId = capabilitySetId;
    }
    
    public void setAssignedCapabilities(List assignedCapabilities) {
        //Loop through the list and set the properties
        if (assignedCapabilities != null) {
            Collections.sort(assignedCapabilities);
            for (int i=0; i<assignedCapabilities.size(); i++) {
                Capability capability = (Capability) assignedCapabilities.get(i);
                setAssignedCapabilityCode(i,capability.getCode());
                setAssignedCapabilityName(i,capability.getName());  // Name or Description ??
                setAssignedCapabilityInd(i,Boolean.TRUE);  // Name or Description ??
            }
        }        
    }
    
    private void initialize() {
        name = null;
        description = null;
        activeDate = null;
        inactiveDate = null;
        capabilitySetId = null;       
    }


}
