/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;

import gov.va.med.esr.common.model.security.ESRRolePrincipalImpl;
import gov.va.med.esr.common.model.security.UserRole;

import gov.va.med.esr.ui.common.util.DateUtils;

public abstract class AbstractUserProfileForm extends AbstractRoleForm {        
    
    private static final long serialVersionUID = -1370346746640850300L;
    //Available Individual Capabilities
    private List roleId = null;
    private List roleName = null;
    private List roleInd = null;
    private List roleActiveDate = null;
    private List roleInactiveDate = null;

    //Assigned Individual Capabilities
    private List assignedRoleId = null;
    private List assignedRoleName = null;
    private List assignedRoleInd = null;
    private List assignedRoleActiveDate = null;
    private List assignedRoleInactiveDate = null;
    
    protected AbstractUserProfileForm () {
        super();
        initialize();
    }

    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        initialize();
    }
         
    public List getRoleIdList() {
        return roleId;
    }
    
    private void setRoleIdList(List roleId) {
        this.roleId = roleId;
    }
    
    public List getRoleNameList() {
        return roleName;
    }

    private void setRoleNameList(List roleName) {
        this.roleName = roleName;
    }

    public List getRoleIndList() {
        return roleInd;
    }

    private void setRoleIndList(List roleInd) {
        this.roleInd = roleInd;
    }
    
    public List getRoleActiveDateList() {
        return roleActiveDate;
    }

    private void setRoleActiveDateList(List roleActiveDate) {
        this.roleActiveDate = roleActiveDate;
    }

    public List getRoleInactiveDateList() {
        return roleInactiveDate;
    }

    private void setRoleInactiveDateList(List roleInactiveDate) {
        this.roleInactiveDate = roleInactiveDate;
    }

    //index based access for the role list
    public String getRoleId(int index) {
        return (String) roleId.get(index);
    }
    public void setRoleId(int index, String value) {
        setElement(this.roleId,index,value);
        //Increase the size of the list for the check boxes
    }    
    public String getRoleName(int index) {
        return (String) roleName.get(index);
    }
    public void setRoleName(int index, String value) {
        setElement(this.roleName,index,value);
    } 
    public Boolean getRoleInd(int index) {
        //Increase the checkbox list size if it is not initialized
        setSize(this.roleInd,index,Boolean.FALSE);
        return (Boolean) roleInd.get(index);
    }
    public void setRoleInd(int index, Boolean value) {
        setSize(this.roleInd,index,Boolean.FALSE);
        setElement(this.roleInd,index,value);
    }
    
    public String getRoleActiveDate(int index) {
        return (String)roleActiveDate.get(index);
    }

    public void setRoleActiveDate(int index, String value) {
        setElement(this.roleActiveDate,index,value);
    }

    public String getRoleInactiveDate(int index) {
        return (String) roleInactiveDate.get(index);
    }

    public void setRoleInactiveDate(int index, String value) {
        setElement(this.roleInactiveDate, index, value);
    }
    
    //Assigned list
    public List getAssignedRoleIdList() {
        return assignedRoleId;
    }

    private void setAssignedRoleIdList(List assignedRoleId) {
        this.assignedRoleId = assignedRoleId;
    }

    public List getAssignedRoleIndList() {
        return assignedRoleInd;
    }

    private void setAssignedRoleIndList(List list) {
        this.assignedRoleInd = list;
    }

    public List getAssignedRoleNameList() {
        return assignedRoleName;
    }

    private void setAssignedRoleNameList(List list) {
        this.assignedRoleName = list;
    }

    public List getAssignedRoleActiveDateList() {
        return assignedRoleActiveDate;
    }

    private void setAssignedRoleActiveDateList(List roleActiveDate) {
        this.assignedRoleActiveDate = roleActiveDate;
    }

    public List getAssignedRoleInactiveDateList() {
        return assignedRoleInactiveDate;
    }

    private void setAssignedRoleInactiveDateList(List roleInactiveDate) {
        this.assignedRoleInactiveDate = roleInactiveDate;
    }

    public String getAssignedRoleId(int index) {
        return (String)assignedRoleId.get(index);
    }

    public void setAssignedRoleId(int index, String value) {
        setElement(this.assignedRoleId,index,value);
    }

    public Boolean getAssignedRoleInd(int index) {
        //Increase the checkbox list size if it is not initialized
        setSize(this.assignedRoleInd,index,Boolean.FALSE);
        return (Boolean)assignedRoleInd.get(index);
    }

    public void setAssignedRoleInd(int index, Boolean value) {
        setSize(this.assignedRoleInd,index,Boolean.FALSE);
        setElement(this.assignedRoleInd, index, value);
    }

    public String getAssignedRoleName(int index) {
        return (String)assignedRoleName.get(index);
    }

    public void setAssignedRoleName(int index, String value) {
        setElement(this.assignedRoleName,index,value);
    }
    
    public String getAssignedRoleActiveDate(int index) {
        return (String)assignedRoleActiveDate.get(index);
    }

    public void setAssignedRoleActiveDate(int index, String value) {
        setElement(this.assignedRoleActiveDate,index,value);
    }

    public String getAssignedRoleInactiveDate(int index) {
        return (String) assignedRoleInactiveDate.get(index);
    }

    public void setAssignedRoleInactiveDate(int index, String value) {
        setElement(this.assignedRoleInactiveDate, index, value);
    }
        
    /**
     * Set Available Capability Sets
     * @param availableCapabilitySets
     */
    public void setAvailableRoles(List availableRoles) {
        //Loop through the list and set the properties
        if (availableRoles != null) {
            Collections.sort(availableRoles);
            for (int i=0; i<availableRoles.size(); i++) {
                ESRRolePrincipalImpl rolePrincipal = (ESRRolePrincipalImpl) availableRoles.get(i);
                setRoleId(i,rolePrincipal.getEntityKey().getKeyValueAsString());
                setRoleName(i,rolePrincipal.getName());
                setRoleInd(i,Boolean.FALSE);
                setRoleActiveDate(i,DateUtils.format(rolePrincipal.getActiveDate(),null));
                setRoleInactiveDate(i,DateUtils.format(rolePrincipal.getInactiveDate(),null));                                       
            }
        }
    }

    /**
     * Set Assigned Roles
     * @param assignedRoles
     */
    public void setAssignedRoles(List assignedRoles) {
        //Loop through the list and set the properties
        if (assignedRoles != null) {
            Collections.sort(assignedRoles);
            for (int i=0; i<assignedRoles.size(); i++) {
                ESRRolePrincipalImpl rolePrincipal = (ESRRolePrincipalImpl) assignedRoles.get(i);
                setAssignedRoleId(i,rolePrincipal.getEntityKey().getKeyValueAsString());
                setAssignedRoleName(i,rolePrincipal.getName()); 
                setAssignedRoleInd(i,Boolean.TRUE);  
                setAssignedRoleActiveDate(i,
                        DateUtils.format(rolePrincipal.getActiveDate(),null));
                setAssignedRoleInactiveDate(i,
                        DateUtils.format(rolePrincipal.getInactiveDate(),null));
            }
        }        
    }    
    
    private void initialize() {        
        // Assigned Roles
        assignedRoleId = new ArrayList();
        assignedRoleName = new ArrayList();
        assignedRoleInd = new ArrayList();
        assignedRoleActiveDate = new ArrayList();
        assignedRoleInactiveDate = new ArrayList();
        
        //Available Roles
        roleId = new ArrayList();
        roleName = new ArrayList();
        roleInd = new ArrayList();
        roleActiveDate = new ArrayList();
        roleInactiveDate = new ArrayList();
    }
}
