/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;

import gov.va.med.esr.common.model.security.CapabilitySet;

import gov.va.med.esr.ui.common.util.DateUtils;

public class AbstractRoleForm extends AbstractCapabilitySetForm {
    
    private static final long serialVersionUID = -5302589808106845280L;
    
    //Available Individual Capabilities
    private List capabilitySetId = null;
    private List capabilitySetName = null;
    private List capabilitySetInd = null;
    private List capabilitySetActiveDate = null;
    private List capabilitySetInactiveDate = null;

    //Assigned Individual Capabilities
    private List assignedCapabilitySetId = null;
    private List assignedCapabilitySetName = null;
    private List assignedCapabilitySetInd = null;
    private List assignedCapabilitySetActiveDate = null;
    private List assignedCapabilitySetInactiveDate = null;
     
    protected AbstractRoleForm() {
        super();
        initialize();
    }
    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        initialize();
    }    
    public List getCapabilitySetIdList() {
        return capabilitySetId;
    }
    
    public void setCapabilitySetIdList(List capabilitySetId) {
        this.capabilitySetId = capabilitySetId;
    }
    
    public List getCapabilitySetNameList() {
        return capabilitySetName;
    }

    public void setCapabilitySetNameList(List capabilitySetName) {
        this.capabilitySetName = capabilitySetName;
    }

    public List getCapabilitySetIndList() {
        return capabilitySetInd;
    }

    public void setCapabilitySetIndList(List capabilitySetInd) {
        this.capabilitySetInd = capabilitySetInd;
    }
    
    public List getCapabilitySetActiveDateList() {
        return capabilitySetActiveDate;
    }

    public void setCapabilitySetActiveDateList(List capabilitySetActiveDate) {
        this.capabilitySetActiveDate = capabilitySetActiveDate;
    }

    public List getCapabilitySetInactiveDateList() {
        return capabilitySetInactiveDate;
    }

    public void setCapabilitySetInactiveDateList(List capabilitySetInactiveDate) {
        this.capabilitySetInactiveDate = capabilitySetInactiveDate;
    }

    //index based access for the capabilitySet list
    public String getCapabilitySetId(int index) {
        return (String) capabilitySetId.get(index);
    }
    public void setCapabilitySetId(int index, String value) {
        setElement(this.capabilitySetId,index,value);
        //Increase the size of the list for the check boxes
    }    
    public String getCapabilitySetName(int index) {
        return (String) capabilitySetName.get(index);
    }
    public void setCapabilitySetName(int index, String value) {
        setElement(this.capabilitySetName,index,value);
    } 
    public Boolean getCapabilitySetInd(int index) {
        //Increase the checkbox list size if it is not initialized
        setSize(this.capabilitySetInd,index,Boolean.FALSE);
        return (Boolean) capabilitySetInd.get(index);
    }
    public void setCapabilitySetInd(int index, Boolean value) {
        setSize(this.capabilitySetInd,index,Boolean.FALSE);
        setElement(this.capabilitySetInd,index,value);
    }
    
    public String getCapabilitySetActiveDate(int index) {
        return (String)capabilitySetActiveDate.get(index);
    }

    public void setCapabilitySetActiveDate(int index, String value) {
        setElement(this.capabilitySetActiveDate,index,value);
    }

    public String getCapabilitySetInactiveDate(int index) {
        return (String) capabilitySetInactiveDate.get(index);
    }

    public void setCapabilitySetInactiveDate(int index, String value) {
        setElement(this.capabilitySetInactiveDate, index, value);
    }
    
    //Assigned list
    public List getAssignedCapabilitySetIdList() {
        return assignedCapabilitySetId;
    }

    public void setAssignedCapabilitySetIdList(List assignedCapabilitySetId) {
        this.assignedCapabilitySetId = assignedCapabilitySetId;
    }

    public List getAssignedCapabilitySetIndList() {
        return assignedCapabilitySetInd;
    }

    public void setAssignedCapabilitySetIndList(List list) {
        this.assignedCapabilitySetInd = list;
    }

    public List getAssignedCapabilitySetNameList() {
        return assignedCapabilitySetName;
    }

    public void setAssignedCapabilitySetNameList(List list) {
        this.assignedCapabilitySetName = list;
    }

    public List getAssignedCapabilitySetActiveDateList() {
        return assignedCapabilitySetActiveDate;
    }

    public void setAssignedCapabilitySetActiveDateList(List capabilitySetActiveDate) {
        this.assignedCapabilitySetActiveDate = capabilitySetActiveDate;
    }

    public List getAssignedCapabilitySetInactiveDateList() {
        return assignedCapabilitySetInactiveDate;
    }

    public void setAssignedCapabilitySetInactiveDateList(List capabilitySetInactiveDate) {
        this.assignedCapabilitySetInactiveDate = capabilitySetInactiveDate;
    }

    public String getAssignedCapabilitySetId(int index) {
        return (String)assignedCapabilitySetId.get(index);
    }

    public void setAssignedCapabilitySetId(int index, String value) {
        setElement(this.assignedCapabilitySetId,index,value);
    }

    public Boolean getAssignedCapabilitySetInd(int index) {
        //Increase the checkbox list size if it is not initialized
        setSize(this.assignedCapabilitySetInd,index,Boolean.FALSE);
        return (Boolean)assignedCapabilitySetInd.get(index);
    }

    public void setAssignedCapabilitySetInd(int index, Boolean value) {
        setSize(this.assignedCapabilitySetInd,index,Boolean.FALSE);
        setElement(this.assignedCapabilitySetInd, index, value);
    }

    public String getAssignedCapabilitySetName(int index) {
        return (String)assignedCapabilitySetName.get(index);
    }

    public void setAssignedCapabilitySetName(int index, String value) {
        setElement(this.assignedCapabilitySetName,index,value);
    }
    
    public String getAssignedCapabilitySetActiveDate(int index) {
        return (String)assignedCapabilitySetActiveDate.get(index);
    }

    public void setAssignedCapabilitySetActiveDate(int index, String value) {
        setElement(this.assignedCapabilitySetActiveDate,index,value);
    }

    public String getAssignedCapabilitySetInactiveDate(int index) {
        return (String) assignedCapabilitySetInactiveDate.get(index);
    }

    public void setAssignedCapabilitySetInactiveDate(int index, String value) {
        setElement(this.assignedCapabilitySetInactiveDate, index, value);
    }
    
    /**
     * Set Available Capability Sets
     * @param availableCapabilitySets
     */
    public void setAvailableCapabilitySets(List availableCapabilitySets) {
        //Loop through the list and set the properties
       if (availableCapabilitySets != null) {
            Collections.sort(availableCapabilitySets);           
            for (int i=0; i<availableCapabilitySets.size(); i++) {
                CapabilitySet capabilitySet = (CapabilitySet) availableCapabilitySets.get(i);
                setCapabilitySetId(i,capabilitySet.getEntityKey().getKeyValueAsString());
                setCapabilitySetName(i,capabilitySet.getName());
                setCapabilitySetInd(i,Boolean.FALSE);
                setCapabilitySetActiveDate(i,
                        DateUtils.format(capabilitySet.getActiveDate(),null));
                setCapabilitySetInactiveDate(i,
                        DateUtils.format(capabilitySet.getInactiveDate(),null));                                    
            }
        }
    }        
    
    private void initialize() { 
        // Assigned CapabilitySets
        assignedCapabilitySetId = new ArrayList();
        assignedCapabilitySetName = new ArrayList();
        assignedCapabilitySetInd = new ArrayList();
        assignedCapabilitySetActiveDate = new ArrayList();
        assignedCapabilitySetInactiveDate = new ArrayList();
        
        //Available CapabilitySets
        capabilitySetId = new ArrayList();
        capabilitySetName = new ArrayList();
        capabilitySetInd = new ArrayList();
        capabilitySetActiveDate = new ArrayList();
        capabilitySetInactiveDate = new ArrayList();
    }
}
