/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;

import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.ui.common.util.DateUtils;

public abstract class AbstractHbpInformationForm extends AbstractForm {
       
    // private static final long serialVersionUID = -1370346746640850300L;
    
    private List hbpPlanName = null;
    private List hbpPlanCode= null;
    private List hbpCoverageCode = null;
    private List hbpPlanType = null;
    private List hbpDescriptption = null;
    private List hbpEffectiveDate = null;
    private List hbpExpirationDate = null;
    
    private List hbpPlanNameId = null;
    private List hbpPlanDefinitionId = null;
    
    private List hbpDescriptionDisplay = null;
  
    private List activeHbpPlanNameList = null;
    private List inactiveHbpPlanNameList = null;
    
    protected AbstractHbpInformationForm () {
        super();
        initialize();
    }
    
    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        initialize();
    }
    
    public List getHbpPlanNameList() {
        return hbpPlanName;
    }

    public void setHbpPlanNameList(List hbpPlanName) {
        this.hbpPlanName = hbpPlanName;
    }
    
    
    public List getHbpPlanCodeList() {
        return hbpPlanName;
    }
    
    public void setHbpPlanCodeList(List hbpPlanCode) {
        this.hbpPlanCode = hbpPlanCode;
    } 
   
    
    public List getHbpCoverageCodeList() {
        return hbpCoverageCode;
    }
    
    public void setHbpCoverageCodeList(List hbpCoverageCode) {
        this.hbpCoverageCode = hbpCoverageCode;
    }
    
    
    public List getHbpPlanTypeList() {
        return hbpPlanType;
    }

    public void setHbpPlanTypeList(List hbpPlanType) {
        this.hbpPlanType = hbpPlanType;
    }

    
    public List getHbpExpirationDateList() {
        return hbpExpirationDate;
    }

    public void setHbpExpirationDateList(List hbpExpirationDate) {
        this.hbpExpirationDate = hbpExpirationDate;
    }
    
    
    public List gethbpEffectiveDateList() {
        return hbpEffectiveDate;
    }

    public void sethbpEffectiveDateList(List hbpEffectiveDate) {
        this.hbpEffectiveDate = hbpEffectiveDate;
    }
    
    
    public List getHbpDescriptptionList() {
        return hbpDescriptption;
    }

    public void setHbpDescriptptionList(List hbpDescriptption) {
        this.hbpDescriptption = hbpDescriptption;
    }
       
    
    public List getHbpPlanNameIdList() {
        return hbpPlanNameId;
    }

    public void setHbpPlanNameIdList(List hbpPlanNameId) {
        this.hbpPlanNameId = hbpPlanNameId;
    }
    
    
    public List getHbpPlanDefinitionIdList() {
        return hbpPlanDefinitionId;
    }

    public void setHbpPlanDefinitionIdList(List hbpPlanDefinitionId) {
        this.hbpPlanDefinitionId = hbpPlanDefinitionId;
    }
    
    
    public List getHbpDescriptionDisplayList() {
        return hbpDescriptionDisplay;
    }

    public void setHbpDescriptionDisplayList(List hbpDescriptionDisplay) {
        this.hbpDescriptionDisplay = hbpDescriptionDisplay;
    }
    
    //index based access for the capability list
    public String getHbpPlanName(int index) {
        return (String) hbpPlanName.get(index);
    }
    public void setHbpPlanName(int index, String value) {
        setElement(this.hbpPlanName,index,value);
        //Increase the size of the list for the check boxes
    }    
    
    //index based access for the capability list
    public String getHbpPlanCode(int index) {
        return (String) hbpPlanCode.get(index);
    }
    public void setHbpPlanCode(int index, String value) {
        setElement(this.hbpPlanCode,index,value);
        //Increase the size of the list for the check boxes
    }    
 
    //index based access for the capability list
    public String getHbpCoverageCode(int index) {
        return (String) hbpCoverageCode.get(index);
    }
    public void setHbpCoverageCode(int index, String value) {
        setElement(this.hbpCoverageCode,index,value);
        //Increase the size of the list for the check boxes
    }    
    
    
    /**
     * Set Available Capabilities
     * @param availableCapabilities
     */
    /*
    public void setAvailableCapabilities(List availableCapabilities) {
        //Loop through the list and set the properties
        Date today = new Date ();
        if (availableCapabilities != null) {
            Collections.sort(availableCapabilities);            
            for (int i=0; i<availableCapabilities.size(); i++) {
                Capability capability = (Capability) availableCapabilities.get(i);
                setCapabilityCode(i,capability.getCode());
                setCapabilityName(i,capability.getName());
                setCapabilityInd(i,Boolean.FALSE);
                setCapabilityActiveDate(i,
                        DateUtils.format(today,null));
                setCapabilityInactiveDate(i,null);                                 
            }
        }
    }    
    */

    private void initialize() {                       
        // Assigned Individual Capabilities
        hbpPlanName = new ArrayList();
        hbpPlanCode = new ArrayList();
        hbpCoverageCode = new ArrayList();
        hbpPlanType = new ArrayList();
        hbpPlanCode = new ArrayList();
        hbpDescriptption = new ArrayList();
        hbpEffectiveDate = new ArrayList();        
        hbpExpirationDate = new ArrayList ();
        
        hbpPlanNameId = new ArrayList();
        hbpPlanDefinitionId = new ArrayList();
        hbpDescriptionDisplay = new ArrayList();
        activeHbpPlanNameList = new ArrayList();
        inactiveHbpPlanNameList = new ArrayList();

    }

    public List getActiveHbpPlanNameList() {
        return activeHbpPlanNameList;
    }

    public void setActiveHbpPlanNameList(List activeHbpPlanNameList) {
        this.activeHbpPlanNameList = activeHbpPlanNameList;
    }

    public List getInactiveHbpPlanNameList() {
        return inactiveHbpPlanNameList;
    }

    public void setInactiveHbpPlanNameList(List inactiveHbpPlanNameList) {
        this.inactiveHbpPlanNameList = inactiveHbpPlanNameList;
    }
}
