/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.admin.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;

import gov.va.med.fw.ui.struts.AbstractForm;

import gov.va.med.esr.common.model.lookup.Capability;

import gov.va.med.esr.ui.common.util.DateUtils;

public abstract class AbstractCapabilitySetForm extends AbstractForm {
       
    private static final long serialVersionUID = -1370346746640850300L;
    public static final String ERRORS_ACTIVE_DATE = "error.activeDate";
    public static final String ERRORS_ACTIVE_DATE_PAST = "error.activeDatePast";
    public static final String ERRORS_INACTIVE_DATE_PAST = "error.inactiveDatePast";
        
    //Available Individual Capabilities
    private List capabilityCode = null;
    private List capabilityName = null;
    private List capabilityInd = null;
    private List capabilityActiveDate = null;
    private List capabilityInactiveDate = null;

    //Assigned Individual Capabilities
    private List assignedCapabilityCode = null;
    private List assignedCapabilityName = null;
    private List assignedCapabilityInd = null;
    private List assignedCapabilityActiveDate = null;
    private List assignedCapabilityInactiveDate = null;
    private List assignedUserCapabilityId = null;
    private List assignedCapabilityOldActiveDate = null;
    private List assignedCapabilityOldInactiveDate = null;    
    
    private List capabilityChangeList = null;
    
    protected AbstractCapabilitySetForm () {
        super();
        initialize();
    }
    
    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        initialize();
    }
    
    public List getCapabilityCodeList() {
        return capabilityCode;
    }
    
    public void setCapabilityCodeList(List capabilityCode) {
        this.capabilityCode = capabilityCode;
    }
    
    public List getCapabilityNameList() {
        return capabilityName;
    }

    public void setCapabilityNameList(List capabilityName) {
        this.capabilityName = capabilityName;
    }

    public List getCapabilityIndList() {
        return capabilityInd;
    }

    public void setCapabilityIndList(List capabilityInd) {
        this.capabilityInd = capabilityInd;
    }
    
    public List getCapabilityActiveDateList() {
        return capabilityActiveDate;
    }

    public void setCapabilityActiveDateList(List capabilityActiveDate) {
        this.capabilityActiveDate = capabilityActiveDate;
    }

    public List getCapabilityInactiveDateList() {
        return capabilityInactiveDate;
    }

    public void setCapabilityInactiveDateList(List capabilityInactiveDate) {
        this.capabilityInactiveDate = capabilityInactiveDate;
    }

    //index based access for the capability list
    public String getCapabilityCode(int index) {
        return (String) capabilityCode.get(index);
    }
    public void setCapabilityCode(int index, String value) {
        setElement(this.capabilityCode,index,value);
        //Increase the size of the list for the check boxes
    }    
    public String getCapabilityName(int index) {
        return (String) capabilityName.get(index);
    }
    public void setCapabilityName(int index, String value) {
        setElement(this.capabilityName,index,value);
    } 
    public Boolean getCapabilityInd(int index) {
        //Increase the checkbox list size if it is not initialized
        setSize(this.capabilityInd,index,Boolean.FALSE);
        return (Boolean) capabilityInd.get(index);
    }
    public void setCapabilityInd(int index, Boolean value) {
        setSize(this.capabilityInd,index,Boolean.FALSE);
        setElement(this.capabilityInd,index,value);
    }
    
    public String getCapabilityActiveDate(int index) {
        return (String)capabilityActiveDate.get(index);
    }

    public void setCapabilityActiveDate(int index, String value) {
        setElement(this.capabilityActiveDate,index,value);
    }

    public String getCapabilityInactiveDate(int index) {
        return (String) capabilityInactiveDate.get(index);
    }

    public void setCapabilityInactiveDate(int index, String value) {
        setElement(this.capabilityInactiveDate, index, value);
    }
    
    //Assigned list
    public List getAssignedCapabilityCodeList() {
        return assignedCapabilityCode;
    }

    public void setAssignedCapabilityCodeList(List assignedCapabilityCode) {
        this.assignedCapabilityCode = assignedCapabilityCode;
    }

    public List getAssignedCapabilityIndList() {
        return assignedCapabilityInd;
    }

    public void setAssignedCapabilityIndList(List list) {
        this.assignedCapabilityInd = list;
    }

    public List getAssignedCapabilityNameList() {
        return assignedCapabilityName;
    }

    public void setAssignedCapabilityNameList(List list) {
        this.assignedCapabilityName = list;
    }

    public List getAssignedCapabilityActiveDateList() {
        return assignedCapabilityActiveDate;
    }

    public void setAssignedCapabilityActiveDateList(List capabilityActiveDate) {
        this.assignedCapabilityActiveDate = capabilityActiveDate;
    }

    public List getAssignedCapabilityOldActiveDateList() {
        return assignedCapabilityOldActiveDate;
    }

    public void setAssignedCapabilityOldActiveDateList(List capabilityOldActiveDate) {
        this.assignedCapabilityOldActiveDate = capabilityOldActiveDate;
    }
    
    public List getAssignedCapabilityInactiveDateList() {
        return assignedCapabilityInactiveDate;
    }

    public void setAssignedCapabilityInactiveDateList(List capabilityInactiveDate) {
        this.assignedCapabilityInactiveDate = capabilityInactiveDate;
    }

    public List getAssignedCapabilityOldInactiveDateList() {
        return assignedCapabilityOldInactiveDate;
    }

    public void setAssignedCapabilityOldInactiveDateList(List capabilityOldInactiveDate) {
        this.assignedCapabilityOldInactiveDate = capabilityOldInactiveDate;
    }
    
    public List getAssignedUserCapabilityIdList() {
        return assignedUserCapabilityId;
    }

    public void setAssignedUserCapabilityIdList(List assignedUserCapabilityId) {
        this.assignedUserCapabilityId = assignedUserCapabilityId;
    }    
    
    public String getAssignedCapabilityCode(int index) {
        return (String)assignedCapabilityCode.get(index);
    }

    public void setAssignedCapabilityCode(int index, String value) {
        setElement(this.assignedCapabilityCode,index,value);
    }

    public Boolean getAssignedCapabilityInd(int index) {
        //Increase the checkbox list size if it is not initialized
        setSize(this.assignedCapabilityInd,index,Boolean.FALSE);
        return (Boolean)assignedCapabilityInd.get(index);
    }

    public void setAssignedCapabilityInd(int index, Boolean value) {
        setSize(this.assignedCapabilityInd,index,Boolean.FALSE);
        setElement(this.assignedCapabilityInd, index, value);
    }

    public String getAssignedCapabilityName(int index) {
        return (String)assignedCapabilityName.get(index);
    }

    public void setAssignedCapabilityName(int index, String value) {
        setElement(this.assignedCapabilityName,index,value);
    }
    
    public String getAssignedCapabilityActiveDate(int index) {
        return (String)assignedCapabilityActiveDate.get(index);
    }

    public void setAssignedCapabilityActiveDate(int index, String value) {
        setElement(this.assignedCapabilityActiveDate,index,value);
    }

    public String getAssignedCapabilityOldActiveDate(int index) {
        return (String)assignedCapabilityOldActiveDate.get(index);
    }

    public void setAssignedCapabilityOldActiveDate(int index, String value) {
        setElement(this.assignedCapabilityOldActiveDate,index,value);
    }
    
    public String getAssignedCapabilityInactiveDate(int index) {
        return (String) assignedCapabilityInactiveDate.get(index);
    }

    public void setAssignedCapabilityInactiveDate(int index, String value) {
        setElement(this.assignedCapabilityInactiveDate, index, value);
    }

    public String getAssignedCapabilityOldInactiveDate(int index) {
        return (String) assignedCapabilityOldInactiveDate.get(index);
    }

    public void setAssignedCapabilityOldInactiveDate(int index, String value) {
        setElement(this.assignedCapabilityOldInactiveDate, index, value);
    }
    
    public String getAssignedUserCapabilityId(int index) {
        return (String) assignedUserCapabilityId.get(index);
    }

    public void setAssignedUserCapabilityId(int index, String value) {
        setElement(this.assignedUserCapabilityId, index, value);
    }    
    
    /**
     * Set Available Capabilities
     * @param availableCapabilities
     */
    public void setAvailableCapabilities(List availableCapabilities) {
        //Loop through the list and set the properties
        Date today = new Date ();
        if (availableCapabilities != null) {
            Collections.sort(availableCapabilities);            
            for (int i=0; i<availableCapabilities.size(); i++) {
                Capability capability = (Capability) availableCapabilities.get(i);
                setCapabilityCode(i,capability.getCode());
                setCapabilityName(i,capability.getName());
                setCapabilityInd(i,Boolean.FALSE);
                setCapabilityActiveDate(i,
                        DateUtils.format(today,null));
                setCapabilityInactiveDate(i,null);                                 
            }
        }
    }    
    
    public List getCapabilityChangeList() {
        return capabilityChangeList;
    }

    public void setCapabilityChangeList(List capabilityChangeList) {
        this.capabilityChangeList = capabilityChangeList;
    }

    private void initialize() {                       
        // Assigned Individual Capabilities
        assignedCapabilityCode = new ArrayList();
        assignedCapabilityName = new ArrayList();
        assignedCapabilityInd = new ArrayList();
        assignedCapabilityActiveDate = new ArrayList();
        assignedCapabilityInactiveDate = new ArrayList();
        assignedCapabilityOldActiveDate = new ArrayList();
        assignedCapabilityOldInactiveDate = new ArrayList();        
        assignedUserCapabilityId = new ArrayList ();
        
        //Available Individual Capabilities
        capabilityCode = new ArrayList();
        capabilityName = new ArrayList();
        capabilityInd = new ArrayList();
        capabilityActiveDate = new ArrayList();
        capabilityInactiveDate = new ArrayList();
        
        capabilityChangeList = new ArrayList ();
    }
}
