<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/valuelist" prefix="vlh" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ page import="gov.va.med.fw.security.SecurityContext,
                 gov.va.med.fw.security.UserPrincipal, gov.va.med.esr.common.model.lookup.Capability"%>
                 
<c:set var="userPrincipal" value="${AppData.SecurityContext.userPrincipal}" scope="request"/> 

<%
// This is a temporary fix, authorize tag in 4.0 fixed this problem.
//authorize tag doesn't work, if it has space in it.
UserPrincipal user=(UserPrincipal)request.getAttribute("userPrincipal");
boolean isSysAdmin= user.isPermissionGranted(Capability.SYSTEM_ADMINISTRATOR.getCode());
request.setAttribute("isSysAdmin",new Boolean(isSysAdmin));
%>              
<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>

<c:choose>
<c:when test="${completedReportsForm.displayFilter}">
  <c:set var="showFilterAttribute" scope="page" value="none"/>
  <c:set var="hideFilterAttribute" scope="page" value="block"/>
</c:when>
<c:otherwise>
  <c:set var="showFilterAttribute" scope="page" value="block"/>
  <c:set var="hideFilterAttribute" scope="page" value="none"/>
</c:otherwise>
</c:choose>

<script type="text/javascript">
function showReportFilter()
{
	document.getElementById("reportFilter").style.display="block";
	document.getElementById("showReportFilterLink").style.display="none";
	document.getElementById("hideReportFilterLink").style.display="block";
	return false;
}
function hideReportFilter()
{
	document.getElementById("reportFilter").style.display="none";
	document.getElementById("showReportFilterLink").style.display="block";
	document.getElementById("hideReportFilterLink").style.display="none";
	return false;
}

function deleteReportConfirmMessage()
{
    return confirmMessage('<bean-el:message key="message.report.confirmCompletedReportDelete"/>');
}
function archiveReportConfirmMessage()
{
    return confirmMessage('<bean-el:message key="message.report.confirmCompletedReportInactive"/>');
}
function setReportStatus(box)
{
	value = box.options[box.selectedIndex].value;
	document.getElementById("reportStatus").value=value;
}
</script>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
  <html-el:form action="/completedReports" method="post">
    <%@ include file="/admin/csrfgentoken.jsp" %>
  <c:set var="reportStatusText"><bean-el:message key="label.report.reportStatus"/></c:set>
  <tr>
    <td width="100%">
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
              <tr>
               <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td> 
                <td class="moduleHeadline" nowrap><bean-el:message key="title.report.completedReports" /></td>
                <c:if test="${completedReportsForm.filterApplied}">
                  <td nowrap class="moduleHeadline" style="padding-left: 7px">(<bean-el:message key="label.report.filterApplied"/>)</td>
                </c:if>
                <td width="87%"><img alt=""  src="../images/spacer.gif"/></td>
                <td class="moduleHeadline" nowrap><fw:label property="reportStatus" forId="reportStatusSelId"><bean-el:message key="label.report.reportStatus" />:</fw:label></td>
                <td width="10%" class="moduleHeadline">                        
				 <html-el:select title="${reportStatusText}" styleClass="moduleEdit" styleId="reportStatusSelId" property="reportStatus" onchange="setReportStatus(this)">   
				   <html-el:option value=""><bean-el:message key="label.all" /></html-el:option>               
				   <esrcore:options collection="reportStatusList" property="code" labelProperty="description"/>
				 </html-el:select>
	       	  </td>
	       		<td style="text-align: center">
					<table width="50%" border="0" cellpadding="0" cellspacing="0" role="presentation">
					  <tr>
					    <td width="10%"><img alt="" src="../images/spacer.gif"/></td>
					    <td style="padding-left:10px"><img alt=""  src="../images/buttonEndLeft.gif"/></td>
					    <td>
					      <html-el:submit property="methodName" style="width:20; vertical-align: top;" styleClass="buttonText">
						<bean-el:message key="button.goFilter"/>
					      </html-el:submit>
					    </td>
					    <td style="padding-right:5px"><img alt=""  src="../images/buttonEndRight.gif"/></td>                            
					    <td width="10%"><img alt=""  src="../images/spacer.gif"/></td>
					  </tr>
					</table>
                 </td>
                <td width="13%"><img alt=""  src="../images/spacer.gif"/></td>
                <td nowrap class="moduleBlueLink" style="padding: 1px 8px 1px 8px">
                  <div id="showReportFilterLink" style="display:<c:out value="${showFilterAttribute}"/>">
                    <fw:link onclick="return(showReportFilter());return false" action="none"><bean-el:message key="button.report.showReportFilter" /></fw:link>
                  </div>
                  <div id="hideReportFilterLink" style="display:<c:out value="${hideFilterAttribute}"/>">
                    <fw:link onclick="return(hideReportFilter());return false" action="none"><bean-el:message key="button.report.hideReportFilter" /></fw:link>
                  </div>
                </td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td class="moduleValue">
            <table id="tableResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
              <%-- Report Filter Selections --%>
              <tr id="reportFilter" style="display:<c:out value="${hideFilterAttribute}"/>">
                <td style="padding:10px">
                  <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
                    <tr>
                      <td width="20%" class="moduleLabel"><fw:label property="reportType" forId="reportTypeId">
                        <bean-el:message key="label.report.reportType"/>:</fw:label>
                      </td>
                      <td width="30%" class="moduleValue">
                        <c:set var="reportTypeText"><bean-el:message key="label.report.reportType"/></c:set>
                        <html-el:select title="${reportTypeText}" styleClass="moduleEdit" styleId="reportTypeId" property="reportType" >
                          <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                          <esrcore:options collection="reportTypeList" property="code" labelProperty="description"/>
                        </html-el:select>
                      </td>
                      <td width="20%" class="moduleLabel"><fw:label property="fileType" forId="fileTypeId">
                        <bean-el:message key="label.report.fileType"/>:</fw:label>
                      </td>
                      <td width="30%" class="moduleValue">
                        <c:set var="fileTypeText"><bean-el:message key="label.report.fileType"/></c:set>
                        <html-el:select title="${fileTypeText}" styleClass="moduleEdit" styleId="fileTypeId" property="fileType" >
                          <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                          <esrcore:options collection="fileTypeList" property="code" labelProperty="description"/>
                        </html-el:select>
                      </td>
                    </tr>

                    <tr>
                      <td width="20%" class="moduleLabel"><fw:label property="reportId" forId="reportId">
                        <bean-el:message key="label.report.reportId"/>:</fw:label>
                      </td>
                      <td width="30%" class="moduleValue">
                        <c:set var="reportIdText"><bean-el:message key="label.report.reportId"/></c:set>
                        <html-el:select title="${reportIdText}" styleClass="moduleEdit" styleId="reportId" property="reportId" >
                          <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                          <esrcore:options collection="reportIdList" property="code" labelProperty="code"/>
                        </html-el:select>
                      </td>
                      <td width="20%" class="moduleLabel"><fw:label property="reportParameters" forId="reportParametersId">
                        <bean-el:message key="label.report.reportParameters"/>:</fw:label>
                      </td>
                      <td width="30%" class="moduleValue">
                        <c:set var="reportParametersText"><bean-el:message key="label.report.reportParameters"/></c:set>
                        <html-el:text title="${reportParametersText}" property="reportParameters" styleId="reportParametersId" size="60"/>
                      </td>
                    </tr>

                    <tr>
                      <td width="20%" class="moduleLabel"><fw:label property="reportTitle" forId="reportTitleId">
                        <bean-el:message key="label.report.reportTitle"/>:</fw:label>
                      </td>
                      <td width="30%" class="moduleValue">
                        <c:set var="reportTitleText"><bean-el:message key="label.report.reportTitle"/></c:set>
                        <html-el:select title="${reportTitleText}" styleClass="moduleEdit" property="reportTitle" styleId="reportTitleId">
                          <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                          <esrcore:options collection="reportTitleList" property="code" labelProperty="description"/>
                        </html-el:select>
                      </td>
                      <td width="20%" class="moduleLabel"><fw:label property="dateFilter" forId="dateFilterId">
                        <bean-el:message key="label.report.dateRun"/> <bean-el:message key="label.from"/>:</fw:label>
                      </td>
                      <td nowrap="true" width="30%" class="moduleValue">
                        <c:set var="dateRunFromText"><bean-el:message key="label.report.dateRun"/>,&nbsp;<bean-el:message key="label.from"/>&nbsp;<c:out value="${mmddyyyyText}"/></c:set>
                        <c:set var="dateRunToText"><bean-el:message key="label.report.dateRun"/>,&nbsp;<bean-el:message key="label.to"/>&nbsp;<c:out value="${mmddyyyyText}"/></c:set>
                        <table border="0" cellpadding="0" cellspacing="0" role="presentation">
                            <tr>
                                <td class="moduleValue">
                                    <html-el:text title="${dateRunFromText}" property="dateFrom" styleId="dateFilterId" size="10" maxlength="10"/>
                                </td>
                                <td class="moduleLabel">
                                    &nbsp;<fw:label property="dateTo" forId="dateToId"><bean-el:message key="label.to"/>:</fw:label>
                                </td>
                                <td class="moduleValue">
                                    <html-el:text title="${dateRunToText}" property="dateTo" styleId="dateToId" size="10" maxlength="10"/>&nbsp;<bean-el:message key="label.dateFormatmmddyyyy"/>
                                </td>
                            </tr>
                        </table>
                        
                      </td>
                    </tr>
                    
					<tr>					
                      <td width="20%" class="moduleLabel"><fw:label property="reportStatus" forId="reportStatusId">
                        <bean-el:message key="label.report.reportStatus"/>:</fw:label>
                      </td>
                      <td width="30%" class="moduleValue">                        
                        <html-el:select title="${reportStatusText}" styleClass="moduleEdit" styleId="reportStatusId" property="reportStatus" onchange="setReportStatus(this)">
                          <html-el:option value=""><bean-el:message key="label.all" /></html-el:option>
                          <esrcore:options collection="reportStatusList" property="code" labelProperty="description"/>
                        </html-el:select>
                      </td>
                      <td width="20%" class="moduleLabel"><fw:label property="reportArchivedDate" forId="reportArchivedDateId">
                        <bean-el:message key="label.report.archivedDate"/>:</fw:label>
                      </td>
                      <td nowrap="true" width="30%" class="moduleValue">                        
                        <c:set var="archivedDateToText"><bean-el:message key="label.report.archivedDate"/>&nbsp;<c:out value="${mmddyyyyText}"/></c:set>
                        <html-el:text title="${archivedDateToText}" property="inactivatedDate" styleId="reportArchivedDateId" size="10" maxlength="10"/>&nbsp;<bean-el:message key="label.dateFormatmmddyyyy"/>
                      </td>
                    </tr>

                    <tr>
                      <td colspan="4" style="text-align: center">
                        <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
                          <tr>
                            <td width="50%"><img alt="" src="../images/spacer.gif"/></td>
                            <td style="padding-left:10px"><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                            <td>
                              <html-el:submit property="methodName" style="width:80; vertical-align: top;" styleClass="buttonText">
                                <bean-el:message key="button.applyFilter"/>
                              </html-el:submit>
                            </td>
                            <td style="padding-right:5px"><img alt=""  src="../images/buttonEndRight.gif"/></td>
                            <td style="padding-left:5px"><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                            <td>
                              <html-el:submit property="methodName" style="width:80; vertical-align: top;" styleClass="buttonText">
                                <bean-el:message key="button.resetFilter"/>
                              </html-el:submit></td>
                            <td style="padding-right:10px"><img alt=""  src="../images/buttonEndRight.gif"/></td>
                            <td width="50%"><img alt=""  src="../images/spacer.gif"/></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                  </table>
                </td>
              </tr>

              <c:choose>
              <c:when test="${vlhlist.valueListInfo.totalNumberOfEntries > 0}">
              <vlh:root id="cmpReportTableId" value="vlhlist" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
              <vlh:addParam name="checkboxName" value="Select" temp="false"/>
              <tr>
                <td>
                  <table class="pagelinks" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                      <td width="5%" height="21" nowrap="true"><span class="pagebanner"><c:out value="${vlhlist.valueListInfo.totalNumberOfEntries}"/> Total - Page (<c:out value="${vlhlist.valueListInfo.pagingPage}"/> of <c:out value="${vlhlist.valueListInfo.totalNumberOfPages}"/>).&nbsp;</span></td>
                      <td width="5%">
                        <c:if test="${vlhlist.valueListInfo.totalNumberOfPages > 1}">
                          <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pagecmpReportTableId}"/>&nbsp;</vlh:paging>
                        </c:if>
                      </td>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                    </tr>
                  </table>
                </td>
              </tr>

              <tr vAlign="top">
                <td vAlign="top" align="center">
                  <table summary="List of Completed Reports" rules="all" class="TableDisplay" cellspacing="0" cellpadding="3">
                    <tr>
                      <vlh:row bean="cmpltReport">
                        <c:set var="counter" value="${(vlhlist.valueListInfo.pagingNumberPer * (vlhlist.valueListInfo.pagingPage-1)) + cmpltReportRowNumber + 1}"/>
                        <c:set var="reportIdParam" value="${cmpltReport.entityKey.keyValueAsString}" scope="request"/>
                        <c:set var="isInactiveReport" value="false" scope="request"/>
                         <c:if test="${cmpltReport.inactivatedDate!=null}">                       
                        	<c:set var="isInactiveReport" value="true" scope="request"/>
                        </c:if>
                        <c:set var="reportPrincipalEntityKey" scope="page" value="${cmpltReport.user.entityKey.keyValueAsString}" />
                        <vlh:column title="#" property="id" attributes="class='valuelistRow1' align='left' scope='col'" default="">
                          <vlh:attribute name="style">white-space: nowrap</vlh:attribute>
                          <vlh:attribute name="scope">row</vlh:attribute>
                          <c:out value="${counter}"/>.
                        </vlh:column>                         
                        <vlh:column titleKey="label.report.brReportType" property="standardReport.type.description" sortable="asc" attributes="class='valuelistRow1' width='3%' align='left'  nowrap scope='col'" default="">
                          <vlh:attribute name="style">white-space: </vlh:attribute>
                        </vlh:column>
                        <vlh:column titleKey="label.report.reportId" property="standardReport.code" sortable="asc" attributes="class='valuelistRow1' align='left' scope='col'" default="">
                          <vlh:attribute name="style">white-space: nowrap</vlh:attribute>
                        </vlh:column>
                        <vlh:column titleKey="label.report.reportTitle" property="standardReport.description" sortable="asc" attributes="class='valuelistRow1' width='30%' align='left' nowrap scope='col'" default="" />
                        <vlh:column titleKey="label.report.brFileType" property="fileType.description" sortable="asc" attributes="class='valuelistRow1' align='left' scope='col'" default="">
                          <vlh:attribute name="style">white-space: nowrap</vlh:attribute>
                        </vlh:column>
                        <vlh:column titleKey="label.report.reportParameters" property="HTMLFormattedReportParameterText" sortable="asc" attributes="class='valuelistRow1' width='60%' align='left' scope='col'" default="" />
                        <vlh:column titleKey="label.report.reportStatus" property="status" sortable="asc" attributes="class='valuelistRow1' align='left' scope='col'" default="">
                          <vlh:attribute name="style">white-space: nowrap</vlh:attribute>
                        </vlh:column>
                        <vlh:column titleKey="label.report.dateRun" property="completedDate" sortable="asc" attributes="class='valuelistRow1' width='5%' align='left' scope='col'" default="">
                          <esrcore:displayDate name="cmpltReport" dateProperty="completedDate" format="MM/dd/yyyy h:mm:ssa"/>
                        </vlh:column>                        
                        <vlh:column titleKey="label.report.brArchivedDate" property="inactivatedDate" sortable="asc" attributes="class='valuelistRow1' width='5%' align='left' scope='col'" default="">
                          <esrcore:displayDate name="cmpltReport" dateProperty="inactivatedDate" format="MM/dd/yyyy"/>
                        </vlh:column>
                        <vlh:column titleKey="label.report.action" property="id" attributes="class='valuelistRow1' width='5%' align='left' nowrap scope='col'" default="">
                          <fw:link target="_blank" action="/viewReports.do?methodName=displayReport" paramId="reportId" paramName="reportIdParam"><bean-el:message key="label.report.view" /></fw:link>                        
                  	 	  <auth:authorize ifAnyGranted="${cmpltReport.standardReport.type.scheduleRunPermissionCode}">
	                  	 	 <c:choose>                  	 	 
	                  	 		<c:when test="${reportPrincipalEntityKey == userPrincipal.entityKey.keyValueAsString || isSysAdmin==true}">                   			
	                       			<fw:link action="/completedReports.do?methodName=deleteCompletedReport&amp;isInactiveReport=${isInactiveReport}" paramId="deleteReportId" paramName="reportIdParam" onclick="return(deleteReportConfirmMessage())"><bean-el:message key="label.report.delete" /></fw:link>
	                       			<c:if test="${cmpltReport.inactivatedDate==null}">
	                       				<fw:link action="/completedReports.do?methodName=inactivateCompletedReport" paramId="inactivateReportId" paramName="reportIdParam" onclick="return(archiveReportConfirmMessage())"><bean-el:message key="label.report.archive" /></fw:link>
	                     			</c:if>                     		
	                      		</c:when> 
	                      		<c:when test="${cmpltReport.inactivatedDate!=null }">
	                      			<fw:link action="/completedReports.do?methodName=deleteCompletedReport&amp;isInactiveReport=${isInactiveReport}" paramId="deleteReportId" paramName="reportIdParam" onclick="return(deleteReportConfirmMessage())"><bean-el:message key="label.report.delete" /></fw:link>
	                      		</c:when>
	                      		<c:otherwise>                        
	                      		</c:otherwise> 
	                      	</c:choose>
                      	</auth:authorize>                        
                        </vlh:column>                        
                      </vlh:row>                       
                    </tr>
                  </table>
                </td>
              </tr>

              <tr>
                <td>
                  <table class="pagelinks" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                      <td width="5%" height="21" nowrap="true"><span class="pagebanner"><c:out value="${vlhlist.valueListInfo.totalNumberOfEntries}"/> Total - Page (<c:out value="${vlhlist.valueListInfo.pagingPage}"/> of <c:out value="${vlhlist.valueListInfo.totalNumberOfPages}"/>).&nbsp;</span></td>
                      <td width="5%">
                        <c:if test="${vlhlist.valueListInfo.totalNumberOfPages > 1}">
                          <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pagecmpReportTableId}"/>&nbsp;</vlh:paging>
                        </c:if>
                      </td>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                    </tr>
                  </table>
                </td>
              </tr>
              </vlh:root>
              </c:when>
              <c:otherwise>
              <tr>
                <td class="moduleValue">
                  <bean-el:message key="label.noDataAvailable" />
                </td>
              </tr>
              </c:otherwise>
              </c:choose>
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
  </html-el:form>
</table>
