<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>

<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>
<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>

<script src="../scripts/ESR-Script.js" type="text/javascript"></script>

<c:if test="${financialDetailsForm.allowedToAddFinancials == 'false'}">
  <c:set var="financialsUpdateAllowed" value="false"></c:set>
</c:if>
<c:if test="${financialDetailsForm.allowedToEditFinancials == 'false'}">
  <c:set var="financialsUpdateAllowed" value="false"></c:set>
</c:if>
<html-el:hidden property="sourceOfTest"/>

<c:set var="finacialsReadOnlyData" value="false"></c:set>
<c:if test="${financialsUpdateAllowed == 'false'}">
  <c:set var="finacialsReadOnlyData" value="true"></c:set>
</c:if>


<table border="0" width="100%" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation" >
<tr><td>
<table border="0" width="100%" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
  <tr><td colspan="5">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role = "presentation">
      <tr>
        <td class="moduleBrownBox"><img alt="" src="../images/spacer.gif" width="29" height="1"/></td>
        <td style="padding: 7 7" nowrap><bean:message key="label.income.title"/></td>
      </tr>
    </table>
  </td></tr>
</table>

<table summary="List of Incomes" role = "presentation">
  <thead>
    <tr>
      <th scope="col" width="28%" class="moduleLabel">&nbsp;</th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
          property="totalEmploymentIncome,spouseInfo.totalEmploymentIncome,spouseTotalIncome[${counter}],depTotalIncome[${counter}]">
        <bean:message key="label.income.employment"/></fw:label></div></th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
          property="USCivilServiceIncome,spouseInfo.USCivilServiceIncome,spouseUSCivilServiceIncome[${counter}],depUSCivilServiceIncome[${counter}]">
        <bean:message key="label.income.usCivilService"/></fw:label></div></th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
          property="interestDividentAnuityIncome,spouseInfo.interestDividentAnuityIncome,spouseInterestDividentAnuityIncome[${counter}],depInterestDividentAnuityIncome[${counter}]">
        <bean:message key="label.income.interst"/></fw:label></div></th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
          property="unemploymentIncome,spouseInfo.unemploymentIncome,spouseUnemploymentIncome[${counter}],depUnemploymentIncome[${counter}]">
        <bean:message key="label.income.unemployment"/></fw:label></div></th>
    </tr>
  </thead>

  <c:set var="incomeEmploymentLabel"><bean-el:message key="label.income.employment"/></c:set>
  <c:set var="incomeUsCivilServiceLabel"><bean-el:message key="label.income.usCivilService"/></c:set>
  <c:set var="incomeInterstLabel"><bean-el:message key="label.income.interst"/></c:set>
  <c:set var="incomeUnemploymentLabel"><bean-el:message key="label.income.unemployment"/></c:set>
  <c:set var="incomeLabel">income</c:set>

  <tbody>
    <tr>
      <td scope="row" class="moduleLabel"><div align="left"><esrcore:displayValue name="financialDetailsForm"
                                                                      property="displayName"/></div></td>
      <td class="moduleLabel"><div align="center">$
        <fw:label property="totalEmploymentIncome" forId="totalEmploymentIncomePreId"><span style="display:none">totalEmploymentIncome</span></fw:label>
        <html-el:text title="${financialDetailsForm.name}'s ${incomeEmploymentLabel} ${incomeLabel} ($)"
                      styleClass="moduleEdit" property="totalEmploymentIncome" styleId="totalEmploymentIncomePreId" size="15" maxlength="15"
                      readonly="${finacialsReadOnlyData}"/>
      </div></td>
      <td class="moduleValue"><div align="center">$
        <fw:label property="USCivilServiceIncome" forId="USCivilServiceIncomeId"><span style="display:none">USCivilServiceIncome</span></fw:label>
        <html-el:text title="${financialDetailsForm.name}'s ${incomeUsCivilServiceLabel} ${incomeLabel} ($)"
                      styleClass="moduleEdit" property="USCivilServiceIncome" styleId="USCivilServiceIncomeId" size="15" maxlength="15"
                      readonly="${finacialsReadOnlyData}"/>
      </div></td>
      <td class="moduleValue"><div align="center">$
        <fw:label property="interestDividentAnuityIncome" forId="interestDividentAnuityIncomeId"><span style="display:none">interestDividentAnuityIncome</span></fw:label>
        <html-el:text title="${financialDetailsForm.name}'s ${incomeInterstLabel} ${incomeLabel} ($)"
                      styleClass="moduleEdit" property="interestDividentAnuityIncome" styleId="interestDividentAnuityIncomeId" size="15" maxlength="15"
                      readonly="${finacialsReadOnlyData}"/>
      </div></td>
      <td class="moduleValue"><div align="center">$
        <fw:label property="unemploymentIncome" forId="unemploymentIncomePreId"><span style="display:none">unemploymentIncome</span></fw:label>
        <html-el:text title="${financialDetailsForm.name}'s ${incomeUnemploymentLabel} ${incomeLabel} ($)"
                      styleClass="moduleEdit" property="unemploymentIncome" styleId="unemploymentIncomePreId" size="15" maxlength="15"
                      readonly="${finacialsReadOnlyData}"/>
      </div></td>
    </tr>

    <c:if test="${not empty financialDetailsForm.spouseInfo.financialsId}">
      <tr>
        <td class="moduleLabel"><div align="left"><esrcore:displayValue name="financialDetailsForm"
                                                                        property="spouseInfo.displayName"/></div></td>
        <td class="moduleLabel"><div align="center">$
          <fw:label property="spouseInfoTotalEmploymentIncome" forId="spouseInfoTotalEmploymentIncomePreId"><span style="display:none">spouseInfoTotalEmploymentIncome</span></fw:label>
          <html-el:text title="${financialDetailsForm.spouseInfo.name}'s ${incomeEmploymentLabel} ${incomeLabel} ($)"
                        styleClass="moduleEdit" property="spouseInfo.totalEmploymentIncome" styleId="spouseInfoTotalEmploymentIncomePreId" size="15" maxlength="15"
                        readonly="${finacialsReadOnlyData}"/>
        </div></td>
        <td class="moduleValue"><div align="center">$
          <fw:label property="spouseInfo.USCivilServiceIncome" forId="spouseInfoUSCivilServiceIncomeId"><span style="display:none">spouseInfoUSCivilServiceIncome</span></fw:label>
          <html-el:text
              title="${financialDetailsForm.spouseInfo.name}'s ${incomeUsCivilServiceLabel} ${incomeLabel} ($)"
              styleClass="moduleEdit" property="spouseInfo.USCivilServiceIncome" styleId="spouseInfoUSCivilServiceIncomeId" size="15" maxlength="15"
              readonly="${finacialsReadOnlyData}"/>
        </div></td>
        <td class="moduleValue"><div align="center">$
          <fw:label property="spouseInfo.interestDividentAnuityIncome" forId="spouseInfoInterestDividentAnuityIncomeId"><span style="display:none">spouseInfoInterestDividentAnuityIncome</span></fw:label>
          <html-el:text title="${financialDetailsForm.spouseInfo.name}'s ${incomeInterstLabel} ${incomeLabel} ($)"
                        styleClass="moduleEdit" styleId="spouseInfoInterestDividentAnuityIncomeId" property="spouseInfo.interestDividentAnuityIncome" size="15"
                        maxlength="15" readonly="${finacialsReadOnlyData}"/>
        </div></td>
        <td class="moduleValue"><div align="center">$
          <fw:label property="spouseInfo.unemploymentIncome" forId="spouseInfoUnemploymentIncomePreId"><span style="display:none">spouseInfoUnemploymentIncome</span></fw:label>
          <html-el:text title="${financialDetailsForm.spouseInfo.name}'s ${incomeUnemploymentLabel} ${incomeLabel} ($)"
                        styleClass="moduleEdit" property="spouseInfo.unemploymentIncome" styleId="spouseInfoUnemploymentIncomePreId" size="15" maxlength="15"
                        readonly="${finacialsReadOnlyData}"/>
        </div></td>
      </tr>
    </c:if>
	  
<!-- inactive spouse info -->
    <c:if test="${not empty financialDetailsForm.spouseFinacialsIdList}">
      <c:forEach var="spouseInfo" items="${financialDetailsForm.spouseFinacialsIdList}" varStatus="status">
        <c:set var="counter" value="${status.count - 1}"/>
        <c:set var="activeSpouse" value="${financialDetailsForm.spouseActiveList[counter]}" />
	    <c:if test="${not activeSpouse}">
            <html-el:hidden property="spouseTotalIncome[${counter}]"/>
			<html-el:hidden property="spouseUSCivilServiceIncome[${counter}]"/>
			<html-el:hidden property="spouseInterestDividentAnuityIncome[${counter}]"/>
			<html-el:hidden property="spouseUnemploymentIncome[${counter}]"/>			  
	    </c:if>			  
        <tr>
          <td class="moduleLabel"><div align="left"><c:out value="${financialDetailsForm.spouseNameList[counter]}"/>
            (<c:out value="${financialDetailsForm.spouseRelationshipList[counter]}"/>)</div></td>
          <td class="moduleLabel"><div align="center">$
            <fw:label property="spouseTotalIncome[${counter}]" forId="spouseTotalIncome[${counter}]_PreId"><span style="display:none">spouseTotalIncome</span></fw:label>
            <html-el:text
                title="${financialDetailsForm.spouseNameList[counter]}'s ${incomeEmploymentLabel} ${incomeLabel} ($)"
                styleClass="moduleEdit" property="spouseTotalIncome[${counter}]" styleId="spouseTotalIncome[${counter}]_PreId" size="15" maxlength="15"
                readonly="${finacialsReadOnlyData or not activeSpouse}"/>
          </div></td>
          <td class="moduleValue"><div align="center">$
            <fw:label property="spouseUSCivilServiceIncome[${counter}]" forId="spouseUSCivilServiceIncome[${counter}]_PreId"><span style="display:none">spouseUSCivilServiceIncome</span></fw:label>
            <html-el:text
                title="${financialDetailsForm.spouseNameList[counter]}'s ${incomeUsCivilServiceLabel} ${incomeLabel} ($)"
                styleClass="moduleEdit" property="spouseUSCivilServiceIncome[${counter}]" styleId="spouseUSCivilServiceIncome[${counter}]_PreId" size="15" maxlength="15"
                readonly="${finacialsReadOnlyData or not activeSpouse}"/>
          </div></td>
          <td class="moduleValue"><div align="center">$
            <fw:label property="spouseInterestDividentAnuityIncome[${counter}]" forId="spouseInterestDividentAnuityIncome[${counter}]_PreId"><span style="display:none">spouseInterestDividentAnuityIncome</span></fw:label>
            <html-el:text
                title="${financialDetailsForm.spouseNameList[counter]}'s ${incomeInterstLabel} ${incomeLabel} ($)"
                styleClass="moduleEdit" property="spouseInterestDividentAnuityIncome[${counter}]" styleId="spouseInterestDividentAnuityIncome[${counter}]_PreId" size="15" maxlength="15"
                readonly="${finacialsReadOnlyData or not activeSpouse}"/>
          </div></td>
          <td class="moduleValue"><div align="center">$
            <fw:label property="spouseUnemploymentIncome[${counter}]" forId="spouseUnemploymentIncome[${counter}]_PreId"><span style="display:none">spouseUnemploymentIncome</span></fw:label>
            <html-el:text
                title="${financialDetailsForm.spouseNameList[counter]}'s ${incomeUnemploymentLabel} ${incomeLabel} ($)"
                styleClass="moduleEdit" property="spouseUnemploymentIncome[${counter}]" styleId="spouseUnemploymentIncome[${counter}]_PreId" size="15" maxlength="15"
                readonly="${finacialsReadOnlyData or not activeSpouse}"/>
          </div></td>
        </tr>

      </c:forEach>
    </c:if>	  	  

    <c:if test="${not empty financialDetailsForm.depFinacialsIdList}">
      <c:forEach var="depInfo" items="${financialDetailsForm.depFinacialsIdList}" varStatus="status">
        <c:set var="counter" value="${status.count - 1}"/>

        <tr>
          <td class="moduleLabel"><div align="left"><c:out value="${financialDetailsForm.depNameList[counter]}"/>
            (<c:out value="${financialDetailsForm.depRelationshipList[counter]}"/>)</div></td>
          <td class="moduleLabel"><div align="center">$
            <fw:label property="depTotalIncome[${counter}]" forId="depTotalIncome[${counter}]_PreId"><span style="display:none">depTotalIncome</span></fw:label>
            <html-el:text
                title="${financialDetailsForm.depNameList[counter]}'s ${incomeEmploymentLabel} ${incomeLabel} ($)"
                styleClass="moduleEdit" property="depTotalIncome[${counter}]" styleId="depTotalIncome[${counter}]_PreId" size="15" maxlength="15"
                readonly="${finacialsReadOnlyData}"/>
          </div></td>
          <td class="moduleValue"><div align="center">$
            <fw:label property="depUSCivilServiceIncome[${counter}]" forId="depUSCivilServiceIncome[${counter}]_PreId"><span style="display:none">depUSCivilServiceIncome</span></fw:label>
            <html-el:text
                title="${financialDetailsForm.depNameList[counter]}'s ${incomeUsCivilServiceLabel} ${incomeLabel} ($)"
                styleClass="moduleEdit" property="depUSCivilServiceIncome[${counter}]" styleId="depUSCivilServiceIncome[${counter}]_PreId" size="15" maxlength="15"
                readonly="${finacialsReadOnlyData}"/>
          </div></td>
          <td class="moduleValue"><div align="center">$
            <fw:label property="depInterestDividentAnuityIncome[${counter}]" forId="depInterestDividentAnuityIncome[${counter}]_PreId"><span style="display:none">depInterestDividentAnuityIncome</span></fw:label>
            <html-el:text
                title="${financialDetailsForm.depNameList[counter]}'s ${incomeInterstLabel} ${incomeLabel} ($)"
                styleClass="moduleEdit" property="depInterestDividentAnuityIncome[${counter}]" styleId="depInterestDividentAnuityIncome[${counter}]_PreId" size="15" maxlength="15"
                readonly="${finacialsReadOnlyData}"/>
          </div></td>
          <td class="moduleValue"><div align="center">$
            <fw:label property="depUnemploymentIncome[${counter}]" forId="depUnemploymentIncome[${counter}]_PreId"><span style="display:none">depUnemploymentIncome</span></fw:label>
            <html-el:text
                title="${financialDetailsForm.depNameList[counter]}'s ${incomeUnemploymentLabel} ${incomeLabel} ($)"
                styleClass="moduleEdit" property="depUnemploymentIncome[${counter}]" styleId="depUnemploymentIncome[${counter}]_PreId" size="15" maxlength="15"
                readonly="${finacialsReadOnlyData}"/>
          </div></td>
        </tr>

      </c:forEach>
    </c:if>
  </tbody>

</table>

<table border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
  <tr valign="top">
    <td class="moduleValue">
      <fw:link href="." onclick="expandOrCollapse(retBlock, retImage, retHiddenId); return false">
        <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="retImage"
                     src="../images/redArrowRight.gif"/><bean:message key="label.incomeRetirement.title"/>
      </fw:link>
      <fw:label property="retHiddenId" forId="retHiddenId"><span style="display:none">ret</span></fw:label>
      <input name="retHiddenId" id="retHiddenId" type="hidden" value="false"/>
    </td>
  </tr>
</table>

<%-- Retirement Income Expand/Collapse Section --%>
<div id="retBlock" class="expandCollapseBody">
  <table summary="List of Retirement Incomes" border="0" width="100%" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
    <thead>
      <tr>
        <th scope="col" width="28%" class="moduleLabel">&nbsp;</th>
        <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
            property="socialSecurityIncome,spouseInfo.socialSecurityIncome,spouseSocialSecurityIncome[${counter}],depSocialSecurityIncome[${counter}]">
          <bean:message key="label.income.socialSecurity"/></fw:label></div></th>
        <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
            property="militaryRetirementIncome,spouseInfo.militaryRetirementIncome,spouseMilitaryRetirementIncome[${counter}],depMilitaryRetirementIncome[${counter}]">
          <bean:message key="label.income.milRetirement"/></fw:label></div></th>
        <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
            property="railroadRetirementIncome,spouseInfo.railroadRetirementIncome,spouseRailroadRetirementIncome[${counter}],depRailroadRetirementIncome[${counter}]">
          <bean:message key="label.income.railRetirement"/></fw:label></div></th>
        <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
            property="otherRetirementIncome,spouseInfo.otherRetirementIncome,spouseOtherRetirementIncome[${counter}],depOtherRetirementIncome[${counter}]">
          <bean:message key="label.income.otherRetirement"/></fw:label></div></th>
      </tr>
    </thead>

    <c:set var="incomeSocialSecurityLabel"><bean-el:message key="label.income.socialSecurity"/></c:set>
    <c:set var="incomeMilRetirementLabel"><bean-el:message key="label.income.milRetirement"/></c:set>
    <c:set var="incomeRailRetirementLabel"><bean-el:message key="label.income.railRetirement"/></c:set>
    <c:set var="incomeOtherRetirementLabel"><bean-el:message key="label.income.otherRetirement"/></c:set>

    <tbody>
      <tr>
        <td scope="row" class="moduleLabel"><div align="left"><esrcore:displayValue name="financialDetailsForm"
                                                                        property="displayName"/></div></td>
        <td class="moduleLabel"><div align="center">$
          <fw:label property="socialSecurityIncome" forId="socialSecurityIncome_PreId"><span style="display:none">socialSecurityIncome</span></fw:label>
          <html-el:text title="${financialDetailsForm.name}'s ${incomeSocialSecurityLabel} ${incomeLabel} ($)"
                        styleClass="moduleEdit" property="socialSecurityIncome" styleId="socialSecurityIncome_PreId" size="15" maxlength="15"
                        readonly="${finacialsReadOnlyData}"/>
        </div></td>
        <td class="moduleValue"><div align="center">$
          <fw:label property="militaryRetirementIncome" forId="militaryRetirementIncome_PreId"><span style="display:none">militaryRetirementIncome</span></fw:label>
          <html-el:text title="${financialDetailsForm.name}'s ${incomeMilRetirementLabel} ${incomeLabel} ($)"
                        styleClass="moduleEdit" property="militaryRetirementIncome" styleId="militaryRetirementIncome_PreId" size="15" maxlength="15"
                        readonly="${finacialsReadOnlyData}"/>
        </div></td>
        <td class="moduleValue"><div align="center">$
          <fw:label property="railroadRetirementIncome" forId="railroadRetirementIncome_PreId"><span style="display:none">railroadRetirementIncome</span></fw:label>
          <html-el:text title="${financialDetailsForm.name}'s ${incomeRailRetirementLabel} ${incomeLabel} ($)"
                        styleClass="moduleEdit" property="railroadRetirementIncome" styleId="railroadRetirementIncome_PreId" size="15" maxlength="15"
                        readonly="${finacialsReadOnlyData}"/>
        </div></td>
        <td class="moduleValue"><div align="center">$
          <fw:label property="otherRetirementIncome" forId="otherRetirementIncome_PreId"><span style="display:none">otherRetirementIncome</span></fw:label>
          <html-el:text title="${financialDetailsForm.name}'s ${incomeOtherRetirementLabel} ${incomeLabel} ($)"
                        styleClass="moduleEdit" property="otherRetirementIncome" styleId="otherRetirementIncome_PreId" size="15" maxlength="15"
                        readonly="${finacialsReadOnlyData}"/>
        </div></td>
      </tr>

      <c:if test="${not empty financialDetailsForm.spouseInfo.financialsId}">
        <tr>
          <td class="moduleLabel"><div align="left"><esrcore:displayValue name="financialDetailsForm"
                                                                          property="spouseInfo.displayName"/></div></td>
          <td class="moduleLabel"><div align="center">$
            <fw:label property="spouseInfo.socialSecurityIncome" forId="spouseInfoSocialSecurityIncome_PreId"><span style="display:none">spouseInfoSocialSecurityIncome</span></fw:label>
            <html-el:text
                title="${financialDetailsForm.spouseInfo.name}'s ${incomeSocialSecurityLabel} ${incomeLabel} ($)"
                styleClass="moduleEdit" property="spouseInfo.socialSecurityIncome" styleId="spouseInfoSocialSecurityIncome_PreId" size="15" maxlength="15"
                readonly="${finacialsReadOnlyData}"/>
          </div></td>
          <td class="moduleValue"><div align="center">$
            <fw:label property="spouseInfo.militaryRetirementIncome" forId="spouseInfoMilitaryRetirementIncome_PreId"><span style="display:none">spouseInfoMilitaryRetirementIncome</span></fw:label>
            <html-el:text
                title="${financialDetailsForm.spouseInfo.name}'s ${incomeMilRetirementLabel} ${incomeLabel} ($)"
                styleClass="moduleEdit" property="spouseInfo.militaryRetirementIncome" styleId="spouseInfoMilitaryRetirementIncome_PreId" size="15" maxlength="15"
                readonly="${finacialsReadOnlyData}"/>
          </div></td>
          <td class="moduleValue"><div align="center">$
            <fw:label property="spouseInfo.railroadRetirementIncome" forId="spouseInfoRailroadRetirementIncome_PreId"><span style="display:none">spouseInfoRailroadRetirementIncome</span></fw:label>
            <html-el:text
                title="${financialDetailsForm.spouseInfo.name}'s ${incomeRailRetirementLabel} ${incomeLabel} ($)"
                styleClass="moduleEdit" property="spouseInfo.railroadRetirementIncome" styleId="spouseInfoRailroadRetirementIncome_PreId" size="15" maxlength="15"
                readonly="${finacialsReadOnlyData}"/>
          </div></td>
          <td class="moduleValue"><div align="center">$
            <fw:label property="spouseInfo.otherRetirementIncome" forId="spouseInfoOtherRetirementIncome_PreId"><span style="display:none">spouseInfoOtherRetirementIncome</span></fw:label>
            <html-el:text
                title="${financialDetailsForm.spouseInfo.name}'s ${incomeOtherRetirementLabel} ${incomeLabel} ($)"
                styleClass="moduleEdit" property="spouseInfo.otherRetirementIncome" size="15" maxlength="15"
                readonly="${finacialsReadOnlyData}"/>
          </div></td>
        </tr>
      </c:if>

      <c:if test="${not empty financialDetailsForm.spouseFinacialsIdList}">
        <c:forEach var="spouseInfo" items="${financialDetailsForm.spouseFinacialsIdList}" varStatus="status">
          <c:set var="counter" value="${status.count - 1}"/>
          <c:set var="activeSpouse" value="${financialDetailsForm.spouseActiveList[counter]}" />
	      <c:if test="${not activeSpouse}">
              <html-el:hidden property="spouseSocialSecurityIncome[${counter}]"/>
			  <html-el:hidden property="spouseMilitaryRetirementIncome[${counter}]"/>
			  <html-el:hidden property="spouseRailroadRetirementIncome[${counter}]"/>
			  <html-el:hidden property="spouseOtherRetirementIncome[${counter}]"/>			  
	      </c:if>	

          <tr>
            <td class="moduleLabel"><div align="left"><c:out value="${financialDetailsForm.spouseNameList[counter]}"/>
              (<c:out value="${financialDetailsForm.spouseRelationshipList[counter]}"/>)</div></td>
            <td class="moduleLabel"><div align="center">$
              <fw:label property="spouseSocialSecurityIncome[${counter}]" forId="spouseSocialSecurityIncome[${counter}]_PreId"><span style="display:none">spouseSocialSecurityIncome</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.spouseNameList[counter]}'s ${incomeSocialSecurityLabel} ${incomeLabel} ($)"
                  styleClass="moduleEdit" property="spouseSocialSecurityIncome[${counter}]" styleId="spouseSocialSecurityIncome[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData or not activeSpouse}"/>
            </div></td>
            <td class="moduleValue"><div align="center">$
              <fw:label property="spouseMilitaryRetirementIncome[${counter}]" forId="spouseMilitaryRetirementIncome[${counter}]_PreId"><span style="display:none">spouseMilitaryRetirementIncome</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.spouseNameList[counter]}'s ${incomeMilRetirementLabel} ${incomeLabel} ($)"
                  styleClass="moduleEdit" property="spouseMilitaryRetirementIncome[${counter}]" styleId="spouseMilitaryRetirementIncome[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData or not activeSpouse}"/>
            </div></td>
            <td class="moduleValue"><div align="center">$
              <fw:label property="spouseRailroadRetirementIncome[${counter}]" forId="spouseRailroadRetirementIncome[${counter}]_PreId"><span style="display:none">spouseRailroadRetirementIncome</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.spouseNameList[counter]}'s ${incomeRailRetirementLabel} ${incomeLabel} ($)"
                  styleClass="moduleEdit" property="spouseRailroadRetirementIncome[${counter}]" styleId="spouseRailroadRetirementIncome[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData or not activeSpouse}"/>
            </div></td>
            <td class="moduleValue"><div align="center">$
              <fw:label property="spouseOtherRetirementIncome[${counter}]" forId="spouseOtherRetirementIncome[${counter}]_PreId"><span style="display:none">spouseOtherRetirementIncome</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.spouseNameList[counter]}'s ${incomeOtherRetirementLabel} ${incomeLabel} ($)"
                  styleClass="moduleEdit" property="spouseOtherRetirementIncome[${counter}]" styleId="spouseOtherRetirementIncome[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData or not activeSpouse}"/>
            </div></td>
          </tr>

        </c:forEach>
      </c:if>
				
      <c:if test="${not empty financialDetailsForm.depFinacialsIdList}">
        <c:forEach var="depInfo" items="${financialDetailsForm.depFinacialsIdList}" varStatus="status">
          <c:set var="counter" value="${status.count - 1}"/>

          <tr>
            <td class="moduleLabel"><div align="left"><c:out value="${financialDetailsForm.depNameList[counter]}"/>
              (<c:out value="${financialDetailsForm.depRelationshipList[counter]}"/>)</div></td>
            <td class="moduleLabel"><div align="center">$
              <fw:label property="depSocialSecurityIncome[${counter}]" forId="depSocialSecurityIncome[${counter}]_PreId"><span style="display:none">depSocialSecurityIncome</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.depNameList[counter]}'s ${incomeSocialSecurityLabel} ${incomeLabel} ($)"
                  styleClass="moduleEdit" property="depSocialSecurityIncome[${counter}]" styleId="depSocialSecurityIncome[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData}"/>
            </div></td>
            <td class="moduleValue"><div align="center">$
              <fw:label property="depMilitaryRetirementIncome[${counter}]" forId="depMilitaryRetirementIncome[${counter}]_PreId"><span style="display:none">depMilitaryRetirementIncome</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.depNameList[counter]}'s ${incomeMilRetirementLabel} ${incomeLabel} ($)"
                  styleClass="moduleEdit" property="depMilitaryRetirementIncome[${counter}]" styleId="depMilitaryRetirementIncome[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData}"/>
            </div></td>
            <td class="moduleValue"><div align="center">$
              <fw:label property="depRailroadRetirementIncome[${counter}]" forId="depRailroadRetirementIncome[${counter}]_PreId"><span style="display:none">depRailroadRetirementIncome</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.depNameList[counter]}'s ${incomeRailRetirementLabel} ${incomeLabel} ($)"
                  styleClass="moduleEdit" property="depRailroadRetirementIncome[${counter}]" styleId="depRailroadRetirementIncome[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData}"/>
            </div></td>
            <td class="moduleValue"><div align="center">$
              <fw:label property="depOtherRetirementIncome[${counter}]" forId="depOtherRetirementIncome[${counter}]_PreId"><span style="display:none">depOtherRetirementIncome</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.depNameList[counter]}'s ${incomeOtherRetirementLabel} ${incomeLabel} ($)"
                  styleClass="moduleEdit" property="depOtherRetirementIncome[${counter}]" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData}"/>
            </div></td>
          </tr>

        </c:forEach>
      </c:if>
    </tbody>
  </table>
</div>

<table border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
  <tr valign="top">
    <td class="moduleValue">
      <fw:link href="."
               onclick="expandOrCollapse(otherIncomeBlock, otherIncomeImage, otherIncomeHiddenId); return false">
        <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="otherIncomeImage"
                     src="../images/redArrowRight.gif"/><bean:message key="label.incomeOther.title"/>
      </fw:link>
      <fw:label property="otherIncomeHiddenId" forId="otherIncomeHiddenId"><span style="display:none">otherIncomeHidden</span></fw:label>
      <input name="otherIncomeHiddenId" id="otherIncomeHiddenId" type="hidden" value="false"/>
    </td>
  </tr>
</table>

<%-- Other Income Expand/Collapse Section --%>
<div id="otherIncomeBlock" class="expandCollapseBody">
  <table summary="List of Other Incomes" border="0" width="100%" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
    <thead>
      <tr>
      <th scope="col" width="28%" class="moduleLabel">&nbsp;</th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
          property="workersCompIncome,spouseInfo.workersCompIncome,spouseWorkersCompIncome[${counter}],depWorkersCompIncome[${counter}]">
        <bean:message key="label.income.workersComp"/></fw:label></div></th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
          property="otherIncome,spouseInfo.otherIncome,spouseOtherIncome[${counter}],depOtherIncome[${counter}]">
        <bean:message key="label.income.other"/></fw:label></div></th>
      <th scope="col" width="18%" class="moduleLabel">&nbsp;</th>
      <th scope="col" width="18%" class="moduleLabel">&nbsp;</th>
    </thead>

    <c:set var="incomeWorkersCompLabel"><bean-el:message key="label.income.workersComp"/></c:set>
    <c:set var="incomeOtherLabel"><bean-el:message key="label.income.other"/></c:set>
    <html-el:hidden property="netIncomeFromFarmRanchOrBusiness" />
    <html-el:hidden property="spouseInfo.netIncomeFromFarmRanchOrBusiness" />

    <tbody>
      <tr>
        <td scope="row" class="moduleLabel"><div align="left"><esrcore:displayValue name="financialDetailsForm"
                                                                        property="displayName"/></div></td>
        <td class="moduleLabel"><div align="center">$
          <fw:label property="workersCompIncome" forId="workersCompIncome_PreId"><span style="display:none">workersCompIncome</span></fw:label>
          <html-el:text title="${financialDetailsForm.name}'s ${incomeWorkersCompLabel} ${incomeLabel} ($)"
                        styleClass="moduleEdit" property="workersCompIncome" styleId="workersCompIncome_PreId" size="15" maxlength="15"
                        readonly="${finacialsReadOnlyData}"/>
        </div></td>
        <td class="moduleValue"><div align="center">$
          <fw:label property="otherIncome" forId="otherIncome_PreId"><span style="display:none">otherIncome</span></fw:label>
          <html-el:text title="${financialDetailsForm.name}'s ${incomeOtherLabel} ($)" styleClass="moduleEdit"
                        property="otherIncome" styleId="otherIncome_PreId" size="15" maxlength="15" readonly="${finacialsReadOnlyData}"/>
        </div></td>
        <td class="moduleValue">&nbsp;</td>
        <td class="moduleValue">&nbsp;</td>
      </tr>

      <c:if test="${not empty financialDetailsForm.spouseInfo.financialsId}">
        <tr>
          <td class="moduleLabel"><div align="left"><esrcore:displayValue name="financialDetailsForm"
                                                                          property="spouseInfo.displayName"/></div></td>
          <td class="moduleLabel"><div align="center">$
            <fw:label property="spouseInfoWorkersCompIncome" forId="spouseInfoWorkersCompIncome_PreId"><span style="display:none">spouseInfoWorkersCompIncome</span></fw:label>
            <html-el:text title="${financialDetailsForm.spouseInfo.name}'s ${incomeWorkersCompLabel} ${incomeLabel} ($)"
                          styleClass="moduleEdit" property="spouseInfo.workersCompIncome" styleId="spouseInfoWorkersCompIncome_PreId" size="15" maxlength="15"
                          readonly="${finacialsReadOnlyData}"/>
          </div></td>
          <td class="moduleValue"><div align="center">$
            <fw:label property="spouseInfoOtherIncome" forId="spouseInfoOtherIncome_PreId"><span style="display:none">spouseInfoOtherIncome</span></fw:label>
            <html-el:text title="${financialDetailsForm.spouseInfo.name}'s ${incomeOtherLabel} ($)"
                          styleClass="moduleEdit" property="spouseInfo.otherIncome" styleId="spouseInfoOtherIncome_PreId" size="15" maxlength="15"
                          readonly="${finacialsReadOnlyData}"/>
          </div></td>
          <td class="moduleValue">&nbsp;</td>
          <td class="moduleValue">&nbsp;</td>
        </tr>
      </c:if>
      <!-- inactive spouse -->
      <c:if test="${not empty financialDetailsForm.spouseFinacialsIdList}">
        <c:forEach var="spouseInfo" items="${financialDetailsForm.spouseFinacialsIdList}" varStatus="status">
          <c:set var="counter" value="${status.count - 1}"/>
          <c:set var="activeSpouse" value="${financialDetailsForm.spouseActiveList[counter]}" />
	      <c:if test="${not activeSpouse}">
              <html-el:hidden property="spouseWorkersCompIncome[${counter}]"/>
			  <html-el:hidden property="spouseOtherIncome[${counter}]"/>
	      </c:if>	
          <tr>
            <td class="moduleLabel"><div align="left"><c:out value="${financialDetailsForm.spouseNameList[counter]}"/>
              (<c:out value="${financialDetailsForm.spouseRelationshipList[counter]}"/>)</div></td>
            <td class="moduleLabel"><div align="center">$
              <fw:label property="spouseWorkersCompIncome[${counter}]" forId="spouseWorkersCompIncome[${counter}]_PreId"><span style="display:none">spouseWorkersCompIncome</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.spouseNameList[counter]}'s ${incomeWorkersCompLabel} ${incomeLabel} ($)"
                  styleClass="moduleEdit" property="spouseWorkersCompIncome[${counter}]" styleId="spouseWorkersCompIncome[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData or not activeSpouse}"/>
            </div></td>
            <td class="moduleValue"><div align="center">$
              <fw:label property="spouseOtherIncome[${counter}]" forId="spouseOtherIncome[${counter}]_PreId"><span style="display:none">spouseOtherIncome</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.spouseNameList[counter]}'s ${incomeOtherLabel} ${incomeLabel} ($)"
                  styleClass="moduleEdit" property="spouseOtherIncome[${counter}]" styleId="spouseOtherIncome[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData or not activeSpouse}"/>
            </div></td>
            <td class="moduleValue">&nbsp;</td>
            <td class="moduleValue">&nbsp;</td>
          </tr>

        </c:forEach>
      </c:if>
				
      <c:if test="${not empty financialDetailsForm.depFinacialsIdList}">
        <c:forEach var="depInfo" items="${financialDetailsForm.depFinacialsIdList}" varStatus="status">
          <c:set var="counter" value="${status.count - 1}"/>

          <tr>
            <td class="moduleLabel"><div align="left"><c:out value="${financialDetailsForm.depNameList[counter]}"/>
              (<c:out value="${financialDetailsForm.depRelationshipList[counter]}"/>)</div></td>
            <td class="moduleLabel"><div align="center">$
              <fw:label property="depWorkersCompIncome[${counter}]" forId="depWorkersCompIncome[${counter}]_PreId"><span style="display:none">depWorkersCompIncome</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.depNameList[counter]}'s ${incomeWorkersCompLabel} ${incomeLabel} ($)"
                  styleClass="moduleEdit" property="depWorkersCompIncome[${counter}]" styleId="depWorkersCompIncome[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData}"/>
            </div></td>
            <td class="moduleValue"><div align="center">$
              <fw:label property="depOtherIncome[${counter}]" forId="depOtherIncome[${counter}]_PreId"><span style="display:none">depOtherIncome</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.depNameList[counter]}'s ${incomeOtherLabel} ${incomeLabel} ($)"
                  styleClass="moduleEdit" property="depOtherIncome[${counter}]" styleId="depOtherIncome[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData}"/>
            </div></td>
            <td class="moduleValue">&nbsp;</td>
            <td class="moduleValue">&nbsp;</td>
            <html-el:hidden property="depIncomeFromRanch[${counter}]" />
          </tr>

        </c:forEach>
      </c:if>
    </tbody>
  </table>
</div>

<table border="0" width="100%" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
  <tr><td colspan="5">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead">
      <tr>
        <td class="moduleBrownBox"><img alt="" src="../images/spacer.gif" width="29" height="1"/></td>
        <td style="padding: 7 7" nowrap><bean:message key="label.expense.title"/></td>
      </tr>
    </table>
  </td>
  </tr>
</table>
<table summary="List of Expenses" role = "presentation">
  <thead>
    <tr>
      <th scope="col" width="28%" class="moduleLabel">&nbsp;</th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
          property="educationExpense,depEduExpenses[${counter}]">
        <bean:message key="label.expense.edu"/></fw:label></div></th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label property="nonReimbMedicalExpense">
        <bean:message key="label.expense.nonReimbMedical"/></fw:label></div></th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label property="adjustedMedicalExpense">
        <bean:message key="label.expense.adjustedMedical"/></fw:label></div></th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label property="funeralBurialExpense">
        <bean:message key="label.expense.funeral"/></fw:label></div></th>
    </tr>
  </thead>

  <c:set var="expenseEduLabel"><bean-el:message key="label.expense.edu"/></c:set>
  <c:set var="expenseNonReimbMedicalLabel"><bean-el:message key="label.expense.nonReimbMedical"/></c:set>
  <c:set var="expenseAdjustedMedicalLabel"><bean-el:message key="label.expense.adjustedMedical"/></c:set>
  <c:set var="expenseFuneralLabel"><bean-el:message key="label.expense.funeral"/></c:set>

  <tbody>
    <tr>
      <td scope="row" class="moduleLabel"><div align="left"><esrcore:displayValue name="financialDetailsForm"
                                                                      property="displayName"/>
      </div></td>
      <td class="moduleValue"><div align="center">$
        <fw:label property="educationExpense" forId="educationExpense_PreId"><span style="display:none">educationExpense</span></fw:label>
        <html-el:text title="${financialDetailsForm.name}'s ${expenseEduLabel} ($)" styleClass="moduleEdit"
                      name="financialDetailsForm" property="educationExpense" styleId="educationExpense_PreId" size="15" maxlength="15"
                      readonly="${finacialsReadOnlyData}"/>
      </div></td>
      <td class="moduleLabel"><div align="center">$
        <fw:label property="nonReimbMedicalExpense" forId="nonReimbMedicalExpense_PreId"><span style="display:none">nonReimbMedicalExpense</span></fw:label>
        <html-el:text title="${financialDetailsForm.name}'s ${expenseNonReimbMedicalLabel} ($)" styleClass="moduleEdit"
                      name="financialDetailsForm" property="nonReimbMedicalExpense" styleId="nonReimbMedicalExpense_PreId" size="15" maxlength="15"
                      readonly="${finacialsReadOnlyData}"/>
      </div></td>
      <td class="moduleValue"><div align="center">$
        <fw:label property="adjustedMedicalExpense" forId="adjustedMedicalExpense_PreId"><span style="display:none">adjustedMedicalExpense</span></fw:label>
        <html-el:text title="${financialDetailsForm.name}'s ${expenseAdjustedMedicalLabel} ($)" styleClass="moduleEdit"
                      name="financialDetailsForm" property="adjustedMedicalExpense" styleId="adjustedMedicalExpense_PreId" size="15" maxlength="15"
                      readonly="${finacialsReadOnlyData}"/>
      </div></td>
      <td class="moduleValue"><div align="center">$
        <fw:label property="funeralBurialExpense" forId="funeralBurialExpense_PreId"><span style="display:none">funeralBurialExpense</span></fw:label>
        <html-el:text title="${financialDetailsForm.name}'s ${expenseFuneralLabel} ($)" styleClass="moduleEdit"
                      name="financialDetailsForm" property="funeralBurialExpense" styleId="funeralBurialExpense_PreId" size="15" maxlength="15"
                      readonly="${finacialsReadOnlyData}"/>
      </div></td>
    </tr>

    <c:if test="${not empty financialDetailsForm.depFinacialsIdList}">
      <c:forEach var="depInfo" items="${financialDetailsForm.depFinacialsIdList}" varStatus="status">
        <c:set var="counter" value="${status.count - 1}"/>

        <html-el:hidden property="depCashAsset[${counter}]"/>
        <html-el:hidden property="depStocksAsset[${counter}]"/>
        <html-el:hidden property="depRealAsset[${counter}]"/>
        <html-el:hidden property="depOtherAsset[${counter}]"/>

        <tr>
          <td class="moduleLabel"><div align="left"><c:out value="${financialDetailsForm.depNameList[counter]}"/>
            (<c:out value="${financialDetailsForm.depRelationshipList[counter]}"/>)</div></td>
          <td class="moduleValue"><div align="center">$
            <fw:label property="depEduExpenses[${counter}]" forId="depEduExpenses[${counter}]_PreId"><span style="display:none">depEduExpenses</span></fw:label>
            <html-el:text title="${financialDetailsForm.depNameList[counter]}'s ${expenseEduLabel} ($)"
                          styleClass="moduleEdit" property="depEduExpenses[${counter}]" size="15" maxlength="15"
                          readonly="${finacialsReadOnlyData}"/>
          </div></td>
          <td class="moduleLabel"><div align="center"></div></td>
          <td class="moduleValue"><div align="center"></div></td>
          <td class="moduleValue"><div align="center"></div></td>
        </tr>
      </c:forEach>
    </c:if>
  </tbody>
</table>

<table border="0" cellpadding="0" cellspacing="0" width="100%" class="moduleShellTableBody" role = "presentation">

  <tr><td colspan="5">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role = "presentation">
      <tr>
        <td class="moduleBrownBox"><img alt="" src="../images/spacer.gif" width="29" height="1"/></td>
        <td style="padding: 7 7" nowrap><bean:message key="label.asset.title"/></td>
      </tr>
    </table>
  </td></tr>
</table>

<table summary="List of Assets" width="100%" border="0" cellpadding="0" cellspacing="0" role = "presentation">
  <thead>
    <tr>
      <th scope="col" width="28%" class="moduleLabel"><div align="left"></div></th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
          property="cashAndBankAccountAsset,spouseInfo.cashAndBankAccountAsset,spouseCashAsset[${counter}],depCashAsset[${counter}]">
        <bean:message key="label.asset.cash"/></fw:label></div></th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
          property="stocksAsset,spouseInfo.stocksAsset,spouseStocksAsset[${counter}],depStocksAsset[${counter}]">
        <bean:message key="label.asset.stocks"/></fw:label></div></th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
          property="realPropertyAsset,spouseInfo.realPropertyAsset,spouseRealAsset[${counter}],depRealAsset[${counter}]">
        <bean:message key="label.asset.real"/></fw:label></div></th>
      <th scope="col" width="18%" class="moduleLabel"><div align="center"><fw:label
          property="otherPropertyAsset,spouseInfo.otherPropertyAsset,spouseOtherAsset[${counter}],depOtherAsset[${counter}]">
        <bean:message key="label.asset.other"/></fw:label></div></th>
    </tr>
  </thead>

  <c:set var="assetCashLabel"><bean-el:message key="label.asset.cash"/></c:set>
  <c:set var="assetStocksLabel"><bean-el:message key="label.asset.stocks"/></c:set>
  <c:set var="assetRealLabel"><bean-el:message key="label.asset.real"/></c:set>
  <c:set var="assetOtherLabel"><bean-el:message key="label.asset.other"/></c:set>

  <tbody>
    <tr>
      <td scope="row" class="moduleLabel"><div align="left"><esrcore:displayValue name="financialDetailsForm"
                                                                      property="displayName"/></div></td>
      <td class="moduleLabel"><div align="center">$
        <fw:label property="cashAndBankAccountAsset" forId="cashAndBankAccountAsset_PreId"><span style="display:none">cashAndBankAccountAsset</span></fw:label>
        <html-el:text title="${financialDetailsForm.name}'s ${assetCashLabel} ($)" styleClass="moduleEdit"
                      name="financialDetailsForm" property="cashAndBankAccountAsset" styleId="cashAndBankAccountAsset_PreId" size="15" maxlength="15"
                      readonly="${finacialsReadOnlyData}"/>
      </div></td>
      <td class="moduleLabel"><div align="center">$
        <fw:label property="stocksAsset" forId="stocksAsset_PreId"><span style="display:none">stocksAsset</span></fw:label>
        <html-el:text title="${financialDetailsForm.name}'s ${assetStocksLabel} ($)" styleClass="moduleEdit"
                      name="financialDetailsForm" property="stocksAsset" styleId="stocksAsset_PreId" size="15" maxlength="15"
                      readonly="${finacialsReadOnlyData}"/>
      </div></td>
      <td class="moduleValue"><div align="center">$
        <fw:label property="realPropertyAsset" forId="realPropertyAsset_PreId"><span style="display:none">realPropertyAsset</span></fw:label>
        <html-el:text title="${financialDetailsForm.name}'s ${assetRealLabel} ($)" styleClass="moduleEdit"
                      name="financialDetailsForm" property="realPropertyAsset" styleId="realPropertyAsset_PreId" size="15" maxlength="15"
                      readonly="${finacialsReadOnlyData}"/>
      </div></td>
      <td class="moduleValue"><div align="center">$
        <fw:label property="otherPropertyAsset" forId="otherPropertyAsset_PreId"><span style="display:none">otherPropertyAsset</span></fw:label>
        <html-el:text title="${financialDetailsForm.name}'s ${assetOtherLabel} ($)" styleClass="moduleEdit"
                      name="financialDetailsForm" property="otherPropertyAsset" styleId="otherPropertyAsset_PreId" size="15" maxlength="15"
                      readonly="${finacialsReadOnlyData}"/>
      </div></td>
    </tr>

    <c:if test="${not empty financialDetailsForm.spouseInfo.financialsId}">

      <tr>
        <td class="moduleLabel"><div align="left"><esrcore:displayValue name="financialDetailsForm"
                                                                        property="spouseInfo.displayName"/></div></td>
        <td class="moduleLabel"><div align="center">$
          <fw:label property="spouseInfo.cashAndBankAccountAsset" forId="spouseInfoCashAndBankAccountAsset_PreId"><span style="display:none">spouseInfoCashAndBankAccountAsset</span></fw:label>
          <html-el:text title="${financialDetailsForm.spouseInfo.name}'s ${assetCashLabel} ($)" styleClass="moduleEdit"
                        property="spouseInfo.cashAndBankAccountAsset" styleId="spouseInfoCashAndBankAccountAsset_PreId" size="15" maxlength="15"
                        readonly="${finacialsReadOnlyData}"/>
        </div></td>
        <td class="moduleLabel"><div align="center">$
          <fw:label property="spouseInfo.stocksAsset" forId="spouseInfoStocksAsset_PreId"><span style="display:none">spouseInfoStocksAsset</span></fw:label>
          <html-el:text title="${financialDetailsForm.spouseInfo.name}'s ${assetStocksLabel} ($)"
                        styleClass="moduleEdit" property="spouseInfo.stocksAsset" styleId="spouseInfoStocksAsset_PreId" size="15" maxlength="15"
                        readonly="${finacialsReadOnlyData}"/>
        </div></td>
        <td class="moduleValue"><div align="center">$
          <fw:label property="spouseInfo.realPropertyAsset" forId="spouseInfoRealPropertyAsset_PreId"><span style="display:none">spouseInfoRealPropertyAsset</span></fw:label>
          <html-el:text title="${financialDetailsForm.spouseInfo.name}'s ${assetRealLabel} ($)" styleClass="moduleEdit"
                        property="spouseInfo.realPropertyAsset" styleId="spouseInfoRealPropertyAsset_PreId" size="15" maxlength="15"
                        readonly="${finacialsReadOnlyData}"/>
        </div></td>
        <td class="moduleValue"><div align="center">$
          <fw:label property="spouseInfo.otherPropertyAsset" forId="spouseInfoOtherPropertyAsset_PreId"><span style="display:none">spouseInfoOtherPropertyAsset</span></fw:label>
          <html-el:text title="${financialDetailsForm.spouseInfo.name}'s ${assetOtherLabel} ($)" styleId="spouseInfoOtherPropertyAsset_PreId" styleClass="moduleEdit"
                        property="spouseInfo.otherPropertyAsset" size="15" maxlength="15"
                        readonly="${finacialsReadOnlyData}"/>
        </div></td>
        <td class="moduleValue">&nbsp;</td>
      </tr>

    </c:if>
	<!-- inactive spouse -->
      <c:if test="${not empty financialDetailsForm.spouseFinacialsIdList}">
        <c:forEach var="spouseInfo" items="${financialDetailsForm.spouseFinacialsIdList}" varStatus="status">
          <c:set var="counter" value="${status.count - 1}"/>
          <c:set var="activeSpouse" value="${financialDetailsForm.spouseActiveList[counter]}" />
	      <c:if test="${not activeSpouse}">
              <html-el:hidden property="spouseCashAsset[${counter}]"/>
			  <html-el:hidden property="spouseStocksAsset[${counter}]"/>
			  <html-el:hidden property="spouseRealAsset[${counter}]"/>
			  <html-el:hidden property="spouseOtherAsset[${counter}]"/>
	      </c:if>	
          <tr>
            <td class="moduleLabel"><div align="left"><c:out value="${financialDetailsForm.spouseNameList[counter]}"/>
              (<c:out value="${financialDetailsForm.spouseRelationshipList[counter]}"/>)</div></td>
            <td class="moduleLabel"><div align="center">$
              <fw:label property="spouseCashAsset[${counter}]" forId="spouseCashAsset[${counter}]_PreId"><span style="display:none">spouseCashAsset</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.spouseNameList[counter]}'s ${assetCashLabel} ($)"
                  styleClass="moduleEdit" property="spouseCashAsset[${counter}]" styleId="spouseCashAsset[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData or not activeSpouse}"/>
            </div></td>
            <td class="moduleValue"><div align="center">$
              <fw:label property="spouseStocksAsset[${counter}]" forId="spouseStocksAsset[${counter}]_PreId"><span style="display:none">spouseStocksAsset</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.spouseNameList[counter]}'s ${assetStocksLabel} ($)"
                  styleClass="moduleEdit" property="spouseStocksAsset[${counter}]" styleId="spouseStocksAsset[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData or not activeSpouse}"/>
            </div></td>
            <td class="moduleValue"><div align="center">$
              <fw:label property="spouseRealAsset[${counter}]" forId="spouseRealAsset[${counter}]_PreId"><span style="display:none">spouseRealAsset</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.spouseNameList[counter]}'s ${assetRealLabel} ($)"
                  styleClass="moduleEdit" property="spouseRealAsset[${counter}]" styleId="spouseRealAsset[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData or not activeSpouse}"/>
            </div></td>
            <td class="moduleValue"><div align="center">$
              <fw:label property="spouseOtherAsset[${counter}]" forId="spouseOtherAsset[${counter}]_PreId"><span style="display:none">spouseOtherAsset</span></fw:label>
              <html-el:text
                  title="${financialDetailsForm.spouseNameList[counter]}'s ${assetOtherLabel} ($)"
                  styleClass="moduleEdit" property="spouseOtherAsset[${counter}]" styleId="spouseOtherAsset[${counter}]_PreId" size="15" maxlength="15"
                  readonly="${finacialsReadOnlyData or not activeSpouse}"/>
            </div></td>
			<td class="moduleValue">&nbsp;</td>  
          </tr>

        </c:forEach>
      </c:if>
  </tbody>
</table>

<table border="0" cellpadding="0" cellspacing="0" width="100%" class="moduleShellTableBody" role = "presentation">
  <tr><td colspan="2">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role = "presentation">
      <tr>
        <td class="moduleBrownBox"><img alt="" src="../images/spacer.gif" width="29" height="1"/></td>
        <td style="padding: 7 7" nowrap><bean:message key="label.debts.title"/></td>
      </tr>
    </table>
  </td></tr>

  <tr>
    <td width="28%" class="moduleLabel"><div align="left"><fw:label property="debt" forId="debtId" >
      <esrcore:displayValue name="financialDetailsForm" property="displayName"/></fw:label></div></td>
    <td width="72%" class="moduleValue"><div align="left">$      
      <html-el:text title="${financialDetailsForm.name}'s debt ($)" styleClass="moduleEdit" name="financialDetailsForm"
                    property="debt" styleId="debtId" size="15" maxlength="15" readonly="${finacialsReadOnlyData}"/>
    </div></td>
  </tr>

  <c:if test="${not empty financialDetailsForm.spouseInfo.financialsId}">
    <tr>
      <td class="moduleLabel"><div align="left"><fw:label property="spouseInfo.debt" forId="idSpouseDebt">
        <esrcore:displayValue name="financialDetailsForm" property="spouseInfo.displayName"/></fw:label></div></td>
      <td class="moduleValue"><div align="left">$
        <html-el:text title="${financialDetailsForm.spouseInfo.name}'s debt ($)" styleId="idSpouseDebt" styleClass="moduleEdit"
                      property="spouseInfo.debt" size="15" maxlength="15" readonly="${finacialsReadOnlyData}"/>
      </div></td>
    </tr>
  </c:if>

  <!-- inactive spouse -->
  <c:if test="${not empty financialDetailsForm.spouseFinacialsIdList}">
    <c:forEach var="spouseInfo" items="${financialDetailsForm.spouseFinacialsIdList}" varStatus="status">
      <c:set var="counter" value="${status.count - 1}"/>
      <c:set var="activeSpouse" value="${financialDetailsForm.spouseActiveList[counter]}" />
	  <c:if test="${not activeSpouse}">
          <html-el:hidden property="spouseDebt[${counter}]" />
	  </c:if>			
      <tr>
        <td class="moduleLabel"><div align="left"><fw:label property="spouseDebt[${counter}]" forId="spouseDebt[${counter}]_id"><c:out value="${financialDetailsForm.spouseNameList[counter]}"/>
              (<c:out value="${financialDetailsForm.spouseRelationshipList[counter]}"/>)</fw:label></div></td>
        <td class="moduleLabel"><div align="left">$
          <html-el:text title="${financialDetailsForm.spouseNameList[counter]}'s debt ($)" styleId="spouseDebt[${counter}]_id" styleClass="moduleEdit" 
			  property="spouseDebt[${counter}]" size="15" maxlength="15" readonly="${finacialsReadOnlyData or not activeSpouse}"/>
        </div></td>
      </tr>
    </c:forEach>
  </c:if>	
</table>

</td>
</tr>
</table>
