<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-tiles" prefix="tiles" %>
<%@ taglib uri="/tags/struts-nested" prefix="nested" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>
<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>
<c:set var="requiredText"><bean-el:message key="label.required"/></c:set>

<script type="text/javascript">
  function onLoadInit()
  {
    expandCollapseCanceledDeclined();
  }
	
  function expandCollapseCanceledDeclined()
  {
    var indicator_y = document.getElementById('idCanceledDeclinedIndicator_y');
    var indicator_n = document.getElementById('idCanceledDeclinedIndicator_n');
    var block = document.getElementById('ccBlock');
    var imageElement = document.getElementById('ccArrowImage');

    if (indicator_n.value != null && indicator_n.checked)
    {
      expandSection(block, imageElement, null);
    }
    else
    {
      if (indicator_y.value != null && indicator_y.checked)
      {
        expandSection(block, imageElement, null);
      }
      else
      {
        collapseSection(block, imageElement, null);
      }
    }
  }
	
  function processCanceledDeclinedIndicator()
  {
    var indicator_nd = document.getElementById('idCanceledDeclinedIndicator_nd');
    var indicator_y = document.getElementById('idCanceledDeclinedIndicator_y');
    var indicator_n = document.getElementById('idCanceledDeclinedIndicator_n');
    var effectiveDate = document.getElementById('idCanceledDeclinedEffectiveDate');
    var remarks = document.getElementById('idCanceledDeclinedRemarks');
    var reason = document.getElementById('idCanceledDeclinedReason');
    var notProcessedReason = document.getElementById('idCanceledDeclinedNotProcessedReason');
    var todayDate = document.getElementById('idTodayDate');
    var block = document.getElementById('ccBlock');
    var imageElement = document.getElementById('ccArrowImage');

    if (indicator_n.value != null && indicator_n.checked)
    {
      effectiveDate.value = '';
      remarks.value = '';
      reason.value = '';
      expandSection(block, imageElement, null);
    }
    else
    {
      if (indicator_y.value != null && indicator_y.checked)
      {
        notProcessedReason.value = '';
        if (effectiveDate.value == null || effectiveDate.value.length == 0)
        {
          effectiveDate.value = todayDate.value;
        }
        expandSection(block, imageElement, null);
      }
      else
      {
        effectiveDate.value = '';
        remarks.value = '';
        reason.value = '';
        notProcessedReason.value = '';
        collapseSection(block, imageElement, null);
      }
    }
  }

  function processEnrollmentOverrideIndicator()
  {
    var indicator_y = document.getElementById('idEnrollmentOverride_y');
    var reason = document.getElementById('idEnrollmentOverrideReason');
    var comment = document.getElementById('idEnrollmentOverrideComment');
    var block = document.getElementById('eoBlock');
    var imageElement = document.getElementById('eoArrowImage');

    if (indicator_y.value != null && indicator_y.checked)
    {
      expandSection(block, imageElement, null);
    }
    else
    {
      reason.value = '';
      comment.value = '';
      collapseSection(block, imageElement, null);
    }
  }
</script>

<%-- Permissions --%>
<c:set var="editAppDate"><%=Capability.EDIT_ENROLLMENT_APP_DATE.getName()%></c:set>
<c:set var="editOverride"><%=Capability.EDIT_ENROLLMENT_OVERRIDE.getName()%></c:set>
<c:set var="editCancelDecline"><%=Capability.EDIT_CANCEL_DECLINE_ENROLLMENT.getName()%></c:set>

<c:set var="editAppDateFlag" value="false"/>
<c:set var="editOverrideFlag" value="false"/>
<c:set var="editCancelDeclineFlag" value="false"/>
<auth:authorize ifAnyGranted="${editAppDate}">
  <c:set var="editAppDateFlag" value="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="${editOverride}">
  <c:set var="editOverrideFlag" value="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="${editCancelDecline}">
  <c:set var="editCancelDeclineFlag" value="true"/>
</auth:authorize>

<%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:set var="veteran" value="${appData[personKey].veteran}"/>
<c:if test="${personLocked}">
  <c:set var="editAppDateFlag" value="false"/>
  <c:set var="editOverrideFlag" value="false"/>
  <c:set var="editCancelDeclineFlag" value="false"/>
</c:if>

<!-- enrollment fields are read only for non-veterans-->
<c:if test="${not veteran}">
  <c:set var="editAppDateFlag" value="false"/>
  <c:set var="editOverrideFlag" value="false"/>
  <c:set var="editCancelDeclineFlag" value="false"/>
</c:if>

<!-- Current Enrollment Panel -->
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
              <tr>
                <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
                <td nowrap style="padding-left: 7"><bean-el:message key="enrollment.enrolPanel.title"/></td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
                <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
                  <fw:link action="/enrollmentHistory?methodName=DISPLAY&amp;history=viewHistoricalEnrollment">
                    <bean-el:message key="text.viewHistoricalEnrollment"/>
                  </fw:link>
                </td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                <tr>
                    <td colspan="2">
                      <%@ include file="/tiles/common/instructionalText.jsp" %>
                    </td>
                </tr>
              <tr>
                <td class="darkLabel" valign="top" style="text-align: left; padding-left: 10" nowrap><bean-el:message key="label.enrollmentCategory"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="enrollmentForm" property="enrollCategory"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                <td class="darkLabel" valign="top" style="text-align: left; padding-left: 10" nowrap><bean-el:message key="label.enrollmentDate"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="enrollmentForm" property="enrollmentDate"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
              <tr>
                <td class="label" valign="top" style="text-align: left; padding-left: 10" nowrap><bean-el:message key="label.enrollmentStatus"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="enrollmentForm" property="enrollmentStatus"/></td>
                <td class="value" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                <td class="label" valign="top" style="text-align: left; padding-left: 10" nowrap><bean-el:message key="label.enrollmentEffDate"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="enrollmentForm" property="enrollmentEffDate"/></td>
                <td class="value" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
              <tr>
                <td class="darkLabel" valign="top" style="text-align: left; padding-left: 10" nowrap><bean-el:message key="label.enrollmentPriority"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="enrollmentForm" property="enrollmentPriority"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                <td class="darkLabel" valign="top" style="text-align: left; padding-left: 10" nowrap><bean-el:message key="label.enrollmentEndDate"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="enrollmentForm" property="enrollmentEndDate"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
              <tr>
                <td class="label" valign="top" style="text-align: left; padding-left: 10" nowrap><bean-el:message key="label.preferredFacility"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="enrollmentForm" property="preferredFacility"/></td>
                <td class="value" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                <td class="label" valign="top" style="text-align: left; padding-left: 10" nowrap><bean-el:message key="label.enrollmentSource"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="enrollmentForm" property="enrollmentSource"/></td>
                <td class="value" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
              <tr>
                <td class="darkLabel" valign="top" style="text-align: left; padding-left: 10" nowrap><bean-el:message key="label.facilityReceived"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="enrollmentForm" property="facilityReceived"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
                <td class="darkLabel" valign="top" style="text-align: left; padding-left: 10" nowrap><bean-el:message key="label.egtType"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="enrollmentForm" property="EGTType"/></td>
                <td class="darkValue" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
              <tr>
                <td class="label" valign="top" style="text-align: left; padding-left: 10" nowrap><bean-el:message key="label.egtSetting"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="enrollmentForm" property="EGTPrioritySub"/></td>
                <td class="value" width="50%"><img alt=""  src="../images/spacer.gif"></td>
				<td class="label" valign="top" style="text-align: left; padding-left: 10" nowrap><bean-el:message key="label.initialPriority"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="enrollmentForm" property="initialEnrollmentPriority"/></td>
                <td class="value" width="50%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<br>

<!-- Edit Panel -->
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
<tr>
<html-el:form action="/enrollment" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
<td>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
<tr>
  <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
      <tr>
        <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
        <td nowrap style="padding-left: 7"><bean-el:message key="label.cancelDeclineOverrideEnrollment"/></td>
      </tr>
    </table>
  </td>
</tr>
<tr>
<td>

<c:set var="isAddPerson" value="false"></c:set>
<c:if test="${enrollmentForm.addAPerson == 'true'}">
	<c:set var="isAddPerson" value="true"></c:set>
</c:if>

<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
  <tr>
    <c:set var="enrollmentApplicationDateLabel"><bean-el:message key="label.enrollmentApplicationDate"/></c:set>
    <td class="moduleLabel" width="45%"><fw:label required="${isAddPerson}" property="applicationDate" forId="idApplicationDate"><bean-el:message key="label.enrollmentApplicationDate"/>:</fw:label></td>
    <td class="moduleValue" width="55%"><html-el:text title="${isAddPerson}${enrollmentApplicationDateLabel} ${mmddyyyyText}" styleClass="moduleEdit" styleId="idApplicationDate" name="enrollmentForm" 
    	property="applicationDate" 
    	readonly="${not (editAppDateFlag || isAddPerson)}"/>&nbsp;<bean-el:message key="label.mmddyyyy" /></td>
  </tr>


<c:if test="${isAddPerson}">
  <tr>
    <c:set var="enrollmentApplicationSignatureLabel"><bean-el:message key="label.enrollmentApplicationSignatureDate"/></c:set>
    <td class="moduleLabel"><fw:label property="signatureDate" forId="idSignatureDate"><bean-el:message key="label.enrollmentApplicationSignatureDate"/>:</fw:label></td>
   
    <td class="moduleValue" width="55%"><html-el:text title="${enrollmentApplicationSignatureLabel} ${mmddyyyyText}" styleClass="moduleEdit" styleId="idSignatureDate" name="enrollmentForm" property="signatureDate" />&nbsp;<bean-el:message key="label.mmddyyyy" /></td>
  </tr>

  <tr>
     <c:set var="enrollmentApplicationMethod"><bean-el:message key="label.enrollmentApplicationMethod"/></c:set>
    <td width="45%" class="moduleLabel" nowrap><fw:label property="applicationMethod" forId="idApplicationMethod"><bean-el:message key="label.enrollmentApplicationMethod"/>:</fw:label></td>
    <td width="55%" class="moduleValue">
					
    	<html-el:select title="${enrollmentApplicationMethod}" styleClass="moduleEdit" styleId="idApplicationMethod"
			property="applicationMethod" >
			<html-el:option value="Online">
				<bean-el:message key="applicationMethod.1" />
			</html-el:option>
			<html-el:option value="In Person">
				<bean-el:message key="applicationMethod.2" />
			</html-el:option>
			<html-el:option value="Phone">
				<bean-el:message key="applicationMethod.3" />
			</html-el:option>
			<html-el:option value="Mail">
				<bean-el:message key="applicationMethod.4" />
			</html-el:option>
		</html-el:select>
    </td>
  </tr>
 </c:if>  
  
  <tr>
    <html-el:hidden name="enrollmentForm" styleId="idTodayDate" property="todayDate"></html-el:hidden>
    <html-el:hidden name="enrollmentForm" property="canceledDeclinedIndicatorCurrent"></html-el:hidden>
    <c:if test="${editCancelDeclineFlag == false}">
      <html-el:hidden name="enrollmentForm" property="canceledDeclinedIndicator"></html-el:hidden>
      <html-el:hidden name="enrollmentForm" property="canceledDeclinedReason"></html-el:hidden>
      <html-el:hidden name="enrollmentForm" property="canceledDeclinedNotProcessedReason"></html-el:hidden>
    </c:if>
    <c:set var="canceledDeclinedIndicatorLabel"><bean-el:message key="label.canceledDeclinedIndicator"/></c:set>
    <td width="45%" class="moduleLabel" nowrap><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="ccArrowImage" src="../images/redArrowRight.gif" /><fw:label property="canceledDeclinedIndicator" forId="idCanceledDeclinedIndicator_y"><bean-el:message key="label.canceledDeclinedIndicator"/>:</fw:label></td>
    <td width="55%" class="moduleValue">
      <c:forEach var="item" items="${yesNoNoDataList}">
        <c:set var="canceledDeclinedIndicatorLabelArg"><bean-el:message key="${item.label}"/></c:set>
        <html-el:radio title="${canceledDeclinedIndicatorLabel} (${canceledDeclinedIndicatorLabelArg})" styleId="idCanceledDeclinedIndicator_${item.value}" name="enrollmentForm" property="canceledDeclinedIndicator" disabled="${not editCancelDeclineFlag}" onclick="processCanceledDeclinedIndicator()" value="${item.value}" />
        <fw:label property="canceledDeclinedIndicator" forId="idCanceledDeclinedIndicator_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
      </c:forEach>
    </td>
  </tr>
</table>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
  <tr>
    <td width="100%" colspan="2">
      <div id="ccBlock" class="expandCollapseBody">
        <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
          <tr>
            <c:set var="canceledDeclinedEffectiveDateLabel"><bean-el:message key="label.canceledDeclinedEffectiveDate"/></c:set>
            <td class="moduleLabel" width="45%"><fw:label property="canceledDeclinedEffectiveDate" forId="idCanceledDeclinedEffectiveDate"><bean-el:message key="label.canceledDeclinedEffectiveDate"/>:</fw:label></td>
            <td class="moduleValue" width="55%">
              <html-el:text  styleClass="moduleEdit" title="${canceledDeclinedEffectiveDateLabel} ${mmddyyyyText}" name="enrollmentForm" property="canceledDeclinedEffectiveDate" styleId="idCanceledDeclinedEffectiveDate" readonly="${not editCancelDeclineFlag}"/>&nbsp;<bean-el:message key="label.mmddyyyy" /></td></tr>
          <tr>
            <c:set var="canceledDeclinedReasonLabel"><bean-el:message key="label.canceledDeclinedReason"/></c:set>
            <td class="moduleLabel"><fw:label property="canceledDeclinedReason" forId="idCanceledDeclinedReason"><bean-el:message key="label.canceledDeclinedReason"/>:</fw:label></td>
            <td class="moduleValue">
              <html-el:select title="${canceledDeclinedReasonLabel}" styleClass="moduleEdit" name="enrollmentForm" property="canceledDeclinedReason" styleId="idCanceledDeclinedReason" disabled="${not editCancelDeclineFlag}">
                <html-el:option value="">
                  <bean-el:message key="label.select"/></html-el:option>
                <esrcore:options collection="gov.va.med.esr.common.model.lookup.CancelDeclineReason" property="code" labelProperty="description"/>
              </html-el:select>
            </td>
          </tr>
          <tr>
            <c:set var="canceledDeclinedNotProcessedReasonLabel"><bean-el:message key="label.canceledDeclinedNotProcessedReason"/></c:set>
            <td class="moduleLabel"><fw:label property="canceledDeclinedNotProcessedReason" forId="idCanceledDeclinedNotProcessedReason"><bean-el:message key="label.canceledDeclinedNotProcessedReason"/>:</fw:label></td>
            <td class="moduleValue">
              <html-el:select title="${canceledDeclinedNotProcessedReasonLabel}" styleClass="moduleEdit" name="enrollmentForm" property="canceledDeclinedNotProcessedReason" styleId="idCanceledDeclinedNotProcessedReason" disabled="${not editCancelDeclineFlag}">
                <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
                <esrcore:options collection="gov.va.med.esr.common.model.lookup.CancelDeclineNotProcessedReason" property="code" labelProperty="description"/>
              </html-el:select>
            </td>
          </tr>
          <tr>
            <c:set var="canceledDeclinedRemarksLabel"><bean-el:message key="label.canceledDeclinedRemarks"/></c:set>
            <td class="moduleLabel" valign="top"><fw:label property="canceledDeclinedRemarks" forId="idCanceledDeclinedRemarks"><bean-el:message key="label.canceledDeclinedRemarks"/>:</fw:label></td>
            <td class="moduleValue">
              <html-el:textarea title="${canceledDeclinedRemarksLabel}" styleClass="moduleEdit" name="enrollmentForm" property="canceledDeclinedRemarks" styleId="idCanceledDeclinedRemarks" rows="4" cols="60" readonly="${not editCancelDeclineFlag}"/></td>
          </tr>
        </table>
      </div>
    </td>
  </tr>
</table>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">

  <tr>
    <html-el:hidden name="enrollmentForm" property="enrollmentOverrideCurrent"></html-el:hidden>
    <c:if test="${editOverrideFlag == false}">
      <html-el:hidden name="enrollmentForm" property="enrollmentOverride"></html-el:hidden>
      <html-el:hidden name="enrollmentForm" property="enrollmentOverrideReason"></html-el:hidden>
    </c:if>
    <c:set var="enrollmentOverrideLabel"><bean-el:message key="label.enrollmentOverride"/></c:set>
    <td width="45%" class="moduleLabel" nowrap><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="eoArrowImage" src="../images/redArrowRight.gif" /><fw:label property="enrollmentOverride" forId="idEnrollmentOverride_y"><bean-el:message key="label.enrollmentOverride"/>:</fw:label></td>
    <td width="55%" class="moduleValue">
      <c:forEach var="item" items="${yesNoList}">
         <c:set var="enrollmentOverrideLabelArg"><bean-el:message key="${item.label}"/></c:set>
        <html-el:radio title="${enrollmentOverrideLabel} (${enrollmentOverrideLabelArg})" styleId="idEnrollmentOverride_${item.value}" name="enrollmentForm" property="enrollmentOverride" disabled="${not editOverrideFlag}" onclick="processEnrollmentOverrideIndicator()" value="${item.value}" />
        <fw:label property="enrollmentOverride" forId="idEnrollmentOverride_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
      </c:forEach>
    </td>
  </tr>
</table>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
  <tr>
    <td width="100%" colspan="2">
      <div id="eoBlock" class="expandCollapseBody">
        <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
          <tr>
            <c:set var="enrollmentOverrideReasonLabel"><bean-el:message key="label.enrollmentOverrideReason"/></c:set>
            <td class="moduleLabel" width="45%"><fw:label required="true" property="enrollmentOverrideReason" forId="idEnrollmentOverrideReason"><bean-el:message key="label.enrollmentOverrideReason"/>:</fw:label></td>
            <td class="moduleValue" width="55%">
              <html-el:select title="${requiredText}, ${enrollmentOverrideReasonLabel}" styleClass="moduleEdit" name="enrollmentForm" property="enrollmentOverrideReason" styleId="idEnrollmentOverrideReason" disabled="${not editOverrideFlag}">
                <html-el:option value="">
                  <bean-el:message key="label.select"/>
                </html-el:option>
                <esrcore:options collection="gov.va.med.esr.common.model.lookup.EnrollmentOverrideReason" property="code" labelProperty="description"/>
              </html-el:select>
            </td>
          </tr>
          <tr>
            <c:set var="enrollmentOverrideCommentsLabel"><bean-el:message key="label.enrollmentOverrideComments"/></c:set>
            <td class="moduleLabel" valign="top"><fw:label property="enrollmentOverrideComment" forId="idEnrollmentOverrideComment"><bean-el:message key="label.enrollmentOverrideComments"/>:</fw:label></td>
            <td class="moduleValue"><html-el:textarea title="${enrollmentOverrideCommentsLabel}" styleClass="moduleEdit" name="enrollmentForm" property="enrollmentOverrideComment" styleId="idEnrollmentOverrideComment" rows="4" cols="60" readonly="${not editOverrideFlag}"/></td>
          <tr>
        </table>
      </div>
    </td>
  </tr>
</table>
</td>
</tr>

<tr width="100%">
  <td>
    <table width="100%" align="center" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
      <tr>
        <td height="50">
          <table border="0" align="center" cellspacing="0" cellpadding="0" role="presentation">
            <tr>
              <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
              <c:if test="${editAppDateFlag || editCancelDeclineFlag || editOverrideFlag || isAddPerson}">
                <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.update"/></html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
              </c:if>
              <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
              <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.cancel"/></html-el:submit></td>
              <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
              <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
  </td>
</tr>
</table>
</td>
</html-el:form>
</tr>
</table>
