<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<%-- Set the default permissions so the user has no permissions --%>
<c:set var="tabDemographicOverview" value="false"/>
<c:set var="tabPersonal" value="false"/>
<c:set var="tabAssociates" value="false"/>
<c:set var="tabAddresses" value="false"/>
<c:set var="tabIdentityTraits" value="false"/>
<c:set var="tabInsurance" value="false"/>

<%-- Update permissions for what the user can do based on assigned Capabilities --%>
<auth:authorize ifAnyGranted="<%=Capability.DEMOGRAPHICS%>">
  <c:set var="tabDemographicOverview" value ="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.PERSONAL%>">
  <c:set var="tabPersonal" value ="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.CONTACTS%>">
  <c:set var="tabAssociates" value ="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.ADDRESS%>">
  <c:set var="tabAddresses" value ="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.IDENTITY_TRAITS%>">
  <c:set var="tabIdentityTraits" value ="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.INSURANCE%>">
  <c:set var="tabInsurance" value ="true"/>
</auth:authorize>

<%-- Set the default background color and border styles for the tabs --%>
<c:set var="overviewStyle">background-color: #9FACCA;</c:set>
<c:set var="personalStyle">background-color: #9FACCA;</c:set>
<c:set var="associatesStyle">background-color: #9FACCA;</c:set>
<c:set var="addressesStyle">background-color: #9FACCA;</c:set>
<c:set var="identityTraitsStyle">background-color: #9FACCA;</c:set>
<c:set var="insuranceStyle">background-color: #9FACCA;</c:set>
<c:set var="overviewBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="personalBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="associatesBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="addressesBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="identityTraitsBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="insuranceBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="leftBorderStyle">border-left: 1px solid #000000;</c:set>

<%-- Set the link parameters --%>
<c:set var="identityTraitsLink"><bean-el:message key="text.subMenu.identityTraits" /></c:set>
<c:set var="personalLink"><bean-el:message key="text.subMenu.personal" /></c:set>
<c:set var="addressLink"><bean-el:message key="text.subMenu.addresses" /></c:set>
<c:set var="overviewLink"><bean-el:message key="text.subMenu.overview" /></c:set>

<%-- Set the default "title" Text --%>
<c:set var="overviewText" scope="page"><bean-el:message key="text.subMenu.overview"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="personalText" scope="page"><bean-el:message key="text.subMenu.personal"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="associatesText" scope="page"><bean-el:message key="text.subMenu.associates"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="addressesText" scope="page"><bean-el:message key="text.subMenu.addresses"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="identityTraitsText" scope="page"><bean-el:message key="text.subMenu.identityTraits"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="insuranceText" scope="page"><bean-el:message key="text.subMenu.insurance"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="selectedSubTabText" scope="page"><bean-el:message key="label.selectedSubTab"/>,&nbsp;</c:set>

<%-- Adjust the title text and the background color based on the selected tab --%>
<c:if test="${subTabName == 'overview'}">
  <c:set var="overviewText" value="${selectedSubTabText}${overviewText}"/>
  <c:set var="overviewStyle">background-color: #EDF2FB;</c:set>
  <c:set var="overviewBottomBorderStyle"></c:set>
</c:if>
<c:if test="${subTabName == 'personal'}">
  <c:set var="personalText" value="${selectedSubTabText}${personalText}"/>
  <c:set var="personalStyle">background-color: #EDF2FB;</c:set>
  <c:set var="personalBottomBorderStyle"></c:set>
</c:if>
<c:if test="${subTabName == 'associates'}">
  <c:set var="associatesText" value="${selectedSubTabText}${associatesText}"/>
  <c:set var="associatesStyle">background-color: #EDF2FB;</c:set>
  <c:set var="associatesBottomBorderStyle"></c:set>
</c:if>
<c:if test="${subTabName == 'addresses'}">
  <c:set var="addressesText" value="${selectedSubTabText}${addressesText}"/>
  <c:set var="addressesStyle">background-color: #EDF2FB;</c:set>
  <c:set var="addressesBottomBorderStyle"></c:set>
</c:if>
<c:if test="${subTabName == 'identityTraits'}">
  <c:set var="identityTraitsText" value="${selectedSubTabText}${identityTraitsText}"/>
  <c:set var="identityTraitsStyle">background-color: #EDF2FB;</c:set>
  <c:set var="identityTraitsBottomBorderStyle"></c:set>
</c:if>
<c:if test="${subTabName == 'insurance'}">
  <c:set var="insuranceText" value="${selectedSubTabText}${insuranceText}"/>
  <c:set var="insuranceStyle">background-color: #EDF2FB;</c:set>
  <c:set var="insuranceBottomBorderStyle"></c:set>
</c:if>

<table width="100%" cellSpacing="0" cellPadding="0" border="0">
  <tr class="moduleShellTable" style="background-color: #EDF2FB;" height="30px">

    <c:if test="${tabDemographicOverview == true}">
    <td align="center" style="<c:out value="${overviewStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000; border-top: 1px solid #000000; <c:out value="${overviewBottomBorderStyle}"/>" nowrap><fw:link title="${overviewText}" action="demographicOverview" paramId="methodName" paramName="overviewLink"><bean-el:message key="text.subMenu.overview"/></fw:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

    <c:if test="${tabIdentityTraits == true}">
    <td align="center" style="<c:out value="${identityTraitsStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000;  border-top: 1px solid #000000; <c:out value="${identityTraitsBottomBorderStyle}"/>" nowrap><fw:link title="${identityTraitsText}" action="demographicIdentityTraits" paramId="methodName" paramName="identityTraitsLink"><bean-el:message key="text.subMenu.identityTraits"/></fw:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

    <c:if test="${tabPersonal == true}">
    <td align="center" style="<c:out value="${personalStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000;  border-top: 1px solid #000000; <c:out value="${personalBottomBorderStyle}"/>" nowrap><fw:link title="${personalText}" action="demographicPersonal" paramId="methodName" paramName="personalLink"><bean-el:message key="text.subMenu.personal"/></fw:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

    <c:if test="${tabAssociates == true}">
    <td align="center" style="<c:out value="${associatesStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000;  border-top: 1px solid #000000; <c:out value="${associatesBottomBorderStyle}"/>" nowrap><fw:link title="${associatesText}" action="displayAssociation"><bean-el:message key="text.subMenu.associates"/></fw:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

    <c:if test="${tabAddresses == true}">
    <td align="center" style="<c:out value="${addressesStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000;  border-top: 1px solid #000000; <c:out value="${addressesBottomBorderStyle}"/>" nowrap><fw:link title="${addressesText}" action="demographicAddresses" paramId="methodName" paramName="addressLink"><bean-el:message key="text.subMenu.addresses"/></fw:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

    <c:if test="${tabInsurance == true}">
    <td align="center" style="<c:out value="${insuranceStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000;  border-top: 1px solid #000000; <c:out value="${insuranceBottomBorderStyle}"/>" nowrap><fw:link title="${insuranceText}" action="insuranceInfoDisplay"><bean-el:message key="text.subMenu.insurance"/></fw:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

    <td width="100%" style="border-bottom: 1px solid #000000;"><img alt=""  src="../images/spacer.gif" height="1" width="100%"/></td>
  </tr>
</table>

