<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/struts-tiles" prefix="tiles" %>
<%@ taglib uri="/tags/struts-nested" prefix="nested" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>
<script src="../scripts/ESR-Script.js" type="text/javascript"></script>

<%-- Site Insurance Records --%>
<%@ include file="siteInsurance.jsp" %>
<br>
<c:set var="isAddAPerson" value="false"></c:set>
<c:if test="${insuranceInfoForm.addAPerson == 'true'}">
    <c:set var="isAddAPerson" value="true"></c:set>
</c:if>

<%-- HEC Insurance Records --%>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
<html-el:form action="/addInsurance" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
  <c:set var="addCode"><%=Capability.ADD_INSURANCE_INFO.getName()%></c:set>
  <c:set var="editCode"><%=Capability.EDIT_INSURANCE_INFO.getName()%></c:set>
  <c:set var="viewCode"><%=Capability.VIEW_INSURANCE_INFO.getName()%></c:set>
  <c:set var="viewHistoricalInsurances" scope="page"><bean-el:message key="text.viewHistoricalInsurances"/></c:set>
  <c:set var="addPermission" value="false"/>
  <c:set var="editPermission" value="false"/>
  <auth:authorize ifAnyGranted="${addCode},${editCode}">
    <c:set var="addPermission" value="true"/>
  </auth:authorize>
  <auth:authorize ifAnyGranted="${editCode}">
    <c:set var="editPermission" value="true"/>
  </auth:authorize>

  <%-- Person Locked Check --%>
  <c:set var="appData" value="${AppData}" scope="session"/>
  <c:set var="personKey" value="SelectedPerson"/>
  <c:set var="personLocked" value="${appData[personKey].personLocked}"/>
  <c:if test="${personLocked}">
    <c:set var="addPermission" value="false"/>
    <c:set var="editPermission" value="false"/>
  </c:if>

  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" style="border-top: #FFFFFF;" role="presentation">
              <tr>
                <td class="moduleBlueBox"><img alt="" src="../images/spacer.gif" width="25" height="17"/></td>
                <td nowrap style="padding-left: 7"><bean-el:message key="label.ins.hecInsuraces"/></td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
                <c:if test="${addPermission == true}">
                <td><img alt="" src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:140; vertical-align: top;" styleClass="buttonText"><bean:message key="button.addPrivateIns"/></html-el:submit></td>
                <td style="padding-right: 5"><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td><img alt="" src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:80; vertical-align: top;" styleClass="buttonText"><bean:message key="button.addMedicare"/></html-el:submit></td>
                <td style="padding-right: 5"><img alt=""  src="../images/buttonEndRight.gif"/></td>
                </c:if>
                <%-- Enable the link when history is implemented
                <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
                <fw:link action="/insuranceHistory?methodName=DISPLAY&amp;history=viewHistoricalInsurances">
                  <bean-el:message key="text.viewHistoricalInsurances"/>
                  </fw:link>
                </td>
                --%>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <c:set var="medicareLinkAdded" value="false"/>

              <c:choose>
              <c:when test="${insuranceInfoForm.hecInsurancePresent}">

              <c:forEach var="insurance" items="${insuranceInfoForm.hecInsurances}">

              <c:choose>
              <c:when test="${insurance.class.name == 'gov.va.med.esr.common.model.insurance.Medicare'}">
              <%-- Medicare Insurance --%>

              <c:if test="${medicareLinkAdded == false}">
              <c:set var="medicareLinkAdded" value="true"/>
              <%-- Medicare Edit Link is common to both Parts A and B so only display it once --%>
              <tr>
                <td colspan="4">
                  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" style="border-top: 2px solid #FFFFFF;" role="presentation">
                    <tr>
                      <td class="moduleBrownBox"><img alt="" src="../images/spacer.gif" width="25" height="17"/></td>
                      <td nowrap style="padding-left: 7">
                        <c:choose>
                        <c:when test="${editPermission}">
                        <fw:link action="/editMedicare?methodName=editMedicare">
                          <bean-el:message key="text.medicare"/>
                        </fw:link>
                        </c:when>
                        <c:otherwise>
                          <bean-el:message key="text.medicare"/>
                        </c:otherwise>
                        </c:choose>
                      </td>
                      <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
                    </tr>
                  </table>
                </td>
              </tr>
              </c:if>
              <tr>
                <td width="170" class="darkLabel" nowrap><bean-el:message key="label.ins.medicare.claimnbr" />:</td>
                <td width="220" class="darkValue"><esrcore:displayValue name="insurance" property="medicareClaimNumber"/></td>
                <td width="250" class="darkLabel" nowrap><bean-el:message key="label.ins.medicare.nameoncard" />:</td>
                <td class="darkValue"><esrcore:displayValue name="insurance" property="nameOnMedicareCard"/></td>
              </tr>
              <tr>
                <td width="170" class="label" nowrap><bean-el:message key="label.ins.groupname"/>:</td>
                <td width="220" class="value"><esrcore:displayValue name="insurance" property="groupName"/></td>
                <td width="250" class="label" nowrap><bean-el:message key="label.ins.groupnumber"/>:</td>
                <td class="value"><esrcore:displayValue name="insurance" property="groupNumber"/></td>
              </tr>
              <tr>
                <c:choose>
                <c:when test="${insurance.partAEffectiveDate != null}">
                <td width="170" class="darkLabel" nowrap><bean-el:message key="label.ins.medicare.partaeffectivedate"/>:</td>
                <td width="220" class="darkValue"><esrcore:displayValue name="insurance" property="partAEffectiveDate"/></td>
                </c:when>
                <c:when test="${insurance.partBEffectiveDate != null}">
                <td width="170" class="darkLabel" nowrap><bean-el:message key="label.ins.medicare.partbeffectivedate"/>:</td>
                <td width="220" class="darkValue"><esrcore:displayValue name="insurance" property="partBEffectiveDate"/></td>
                </c:when>
                <c:otherwise>
                <td width="170" class="darkLabel" nowrap><bean-el:message key="label.ins.medicare.effectivedate"/>:</td>
                <td width="220" class="darkValue">&nbsp;</td>
                </c:otherwise>
                </c:choose>
                <td width="250" class="darkLabel" nowrap>&nbsp;</td>
                <td class="darkValue">&nbsp;</td>
              </tr>
              <tr>
                <td width="170" class="label" valign="top" nowrap><bean-el:message key="label.ins.address"/>:</td>
                <td width="220" class="value" valign="top"><esrcore:displayValue name="insurance" property="address"/></td>
                <td width="250" class="label" valign="top" nowrap>&nbsp;</td>
                <td class="value" valign="top">&nbsp;</td>
              </tr>
              <tr>
                <td width="170" class="darkLabel" nowrap><bean-el:message key="label.ins.carrierphone"/>:</td>
                <td width="220" class="darkValue"><esrcore:displayValue name="insurance" property="businessPhone"/></td>
                <td width="250" class="darkLabel" nowrap>Fax:</td>
                <td class="darkValue"><esrcore:displayValue name="insurance" property="fax"/></td>
              </tr>
              <tr>
                <td width="170" class="label" nowrap><bean-el:message key="label.ins.lastupdate"/>:</td>
                <td width="220" class="value"><esrcore:displayValue name="insurance" property="modifiedOn"/></td>
                <td width="250" class="label" nowrap><bean-el:message key="label.ins.lastupdateby"/>:</td>
                <td class="value">
                  <esrcore:displayLookupValue lookupType="gov.va.med.esr.common.model.security.ESRUserPrincipalImpl" name="insurance" property="modifiedBy.name" />
                </td>
              </tr>
              <tr>
                <td width="170" class="darkLabel" nowrap>&nbsp;</td>
                <td width="220" class="darkValue">&nbsp;</td>
                <td width="250" class="darkLabel" nowrap>&nbsp;</td>
                <td class="darkValue">&nbsp;</td>
              </tr>

              </c:when>
              <c:otherwise>
              <%-- Private Insurance --%>
              <tr>
                <td colspan="4">
                  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" style="border-top: 2px solid #FFFFFF;" role="presentation">
                      <c:choose>
                      <c:when test="${isAddAPerson}">
                      	<c:set var="identifier" value="InsuranceIDUNKNOWN" />
                      </c:when>
                      <c:otherwise>
                       <c:set var="identifier" value="${insurance.entityKey.keyValueAsString}" />
                      </c:otherwise>
                      </c:choose>
                      <c:set var="name" value="${insurance.companyName}" />
                   <tr>
                      <td class="moduleBrownBox"><img alt="" src="../images/spacer.gif" width="25" height="17"/></td>
                      <td nowrap style="padding-left: 7">
                        <c:choose>
                        <c:when test="${editPermission && not isAddAPerson}">
                           <fw:link action="editInsurance?methodName=DISPLAY" paramId="insuranceId" paramName="identifier">
                          <c:out value="${name}" />
                        </fw:link>
                        </c:when>
                        <c:otherwise>
                        <c:out value="${name}" />
                        </c:otherwise>
                        </c:choose>
                      </td>
                      <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
                    </tr>
                  </table>
                </td>
              </tr>
              <tr>
                <td width="170" class="darkLabel" nowrap><bean-el:message key="label.ins.policynumber"/>:</td>
                <td width="220" class="darkValue"><esrcore:displayValue name="insurance" property="policyNumber"/></td>
                <td width="250" class="darkLabel" nowrap><bean-el:message key="label.ins.typeofins"/>:</td>
                <td class="darkValue"><esrcore:displayValue name="insurance" property="insurancePlan.planType.description"/></td>
              </tr>
              <tr>
                <td width="170" class="label" nowrap><bean-el:message key="label.ins.groupname"/>:</td>
                <td width="220" class="value"><esrcore:displayValue name="insurance" property="groupName"/></td>
                <td width="250" class="label" nowrap><bean-el:message key="label.ins.groupnumber"/>:</td>
                <td class="value"><esrcore:displayValue name="insurance" property="groupNumber"/></td>
              </tr>
              <tr>
                <td width="170" class="darkLabel" nowrap><bean-el:message key="label.ins.nameofinsured"/>:</td>
                <td width="220" class="darkValue"><esrcore:displayValue name="insurance" property="subscriber.name"/></td>
                <td width="250" class="darkLabel" nowrap><bean-el:message key="label.ins.insuredrelationshiptovet"/>:</td>
                <td class="darkValue"><esrcore:displayValue name="insurance" property="subscriber.relationship"/></td>
              </tr>
              <tr>
                <td width="170" class="label" nowrap><bean-el:message key="label.ins.effectivedate"/>:</td>
                <td width="220" class="value"><esrcore:displayValue name="insurance" property="policyEffectiveDate"/></td>
                <td width="250" class="label" nowrap><bean-el:message key="label.ins.planexpdate"/>:</td>
                <td class="value"><esrcore:displayDate name="insurance" displayTime="true" dateProperty="policyExpirationDate"/></td>
              </tr>
              <tr>
                <td width="170" class="darkLabel" nowrap><bean-el:message key="label.ins.precertrequired"/>:</td>
                <td width="220" class="darkValue"><esrcore:displayValue name="insurance" property="insurancePlan.precertificationRequired"/></td>
                <td width="250" class="darkLabel" nowrap><bean-el:message key="label.ins.preCertificationPhone" />:</td>
                <td class="darkValue"><esrcore:displayValue name="insurance" property="preCertificationPhone"/></td>
              </tr>
              <tr>
                <td width="170" class="label" valign="top" nowrap><bean-el:message key="label.ins.address"/>:</td>
                <td width="220" class="value"><esrcore:displayValue name="insurance" property="address"/></td>
                <td width="250" class="label" nowrap>&nbsp;</td>
                <td class="value">&nbsp;</td>
              </tr>
              <tr>
                <td width="170" class="darkLabel" nowrap><bean-el:message key="label.ins.carrierphone"/>:</td>
                <td width="220" class="darkValue"><esrcore:displayValue name="insurance" property="businessPhone"/></td>
                <td width="250" class="darkLabel" nowrap><bean-el:message key="label.ins.carrierfax" />:</td>
                <td class="darkValue"><esrcore:displayValue name="insurance" property="fax"/></td>
              </tr>
              <tr>
                <td width="170" class="label" nowrap><bean-el:message key="label.ins.lastupdate"/>:</td>
                <td width="220" class="value"><esrcore:displayValue name="insurance" property="modifiedOn"/></td>
                <td width="250" class="label" nowrap><bean-el:message key="label.ins.lastupdateby"/>:</td>
                <td class="value">
                  <esrcore:displayLookupValue lookupType="gov.va.med.esr.common.model.security.ESRUserPrincipalImpl" name="insurance" property="modifiedBy.name" />
                </td>
              </tr>

              </c:otherwise>
              </c:choose>

              </c:forEach>

              </c:when>
              <c:otherwise>
              <tr>
                <td class="moduleLabel" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
              </tr>
              </c:otherwise>
              </c:choose>

            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
  <html-el:hidden name="insuranceInfoForm" property="addAPerson"/>
</html-el:form>
</table>
