<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/struts-tiles" prefix="tiles" %>
<%@ taglib uri="/tags/struts-nested" prefix="nested" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>
<%@ page import='gov.va.med.esr.common.model.lookup.AddressChangeSource' %>
<%@ page import='gov.va.med.esr.common.model.lookup.PhoneSourceOfChange' %>
<%@ page import='gov.va.med.esr.common.model.lookup.EmailSourceOfChange' %>
<%@ page import="gov.va.med.esr.common.model.lookup.VAFacility" %>
<c:set var="notDefined" scope="page"><bean-el:message key="label.isNotDefined"/></c:set>
<c:set var="current" scope="page"><bean-el:message key="label.isCurrent"/></c:set>
<c:set var="notYetCurrent" scope="page"><bean-el:message key="label.isNotYetCurrent"/></c:set>
<c:set var="expired" scope="page"><bean-el:message key="label.hasExpired"/></c:set>
<c:set var="confAddressText"><bean-el:message key="label.addresses.confidentialAddressHeader"/></c:set>
<c:set var="tempAddressText"><bean-el:message key="label.addresses.temporaryAddressHeader"/></c:set>

<!--<script src="../scripts/ESR-Script.js" type="text/javascript"></script> -->
<c:set var="addressVamcConstant"><%= AddressChangeSource.CODE_VAMC.getName() %></c:set>
<c:set var="phoneVamcConstant"><%= PhoneSourceOfChange.CODE_VAMC.getName() %></c:set>
<c:set var="emailVamcConstant"><%= EmailSourceOfChange.CODE_VAMC.getName() %></c:set>
<c:set var="hecFacilityConstant"><%= VAFacility.CODE_HEC.getName() %></c:set>
<c:set var="phoneCount" value="${demographicAddressesForm.phoneSize}"/>
<c:set var="emailCount" value="${demographicAddressesForm.emailSize}"/>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="person" value="${appData[personKey]}"/>
<c:set var="viewHistoricalAddresses" scope="page"><bean-el:message key="text.viewHistoricalAddresses"/></c:set>
<c:set var="countryEditable" scope="page" value="true"/>
<c:set var="displayRequiredFieldsIndicator" scope="page" value="true"/>
<c:set var="zipCodeLookup" scope="page" value="true"/>
<c:set var="readOnlyAddress" scope="page" value="true"/>
<c:set var="isAddAPerson" value="false"></c:set>

<!-- set read only falgs based on user permissions -->
<auth:authorize ifAnyGranted="<%=Capability.EDIT_ADDRESS.getName()%>">
  <c:set var="readOnlyAddress" scope="page" value="false"/>
</auth:authorize>
<c:if test="${person.permanentAddress == null}">
  <auth:authorize ifAnyGranted="<%=Capability.ADD_ADDRESS.getName()%>">
    <c:set var="readOnlyAddress" scope="page" value="false"/>
  </auth:authorize>
</c:if>

<%-- Person Locked Check --%>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="readOnlyAddress" scope="page" value="true"/>
</c:if>

<c:if test="${readOnlyAddress}">
  <c:set var="countryEditable" scope="page" value="false"/>
  <c:set var="zipCodeLookup" scope="page" value="false"/>
</c:if>

<script type="text/javascript">
  // Perform all page initialization
  function onLoadInit()
  {
    updateCountryFields();
    updateAddressSiteOfChange();
    initPhoneSitesOfChange();
    initEmailSitesOfChange();
    setAddEmailFocus();
    setAddPhoneNumberFocus();
  }
  
//Place focus on "Email Type" field when "Add Email Address" is clicked
  function setAddEmailFocus()
  {
	  if ('${demographicAddressesForm.addEmailType}' != '') {
		  var arr = '${demographicAddressesForm.addEmailType}';
		  var component = document.getElementsByName("emailType[" + arr + "]");
		  component[0].focus();
	  }
  }
  
  //Place focus on "Phone Type" field when "Add Phone Number" is clicked
  function setAddPhoneNumberFocus()
  {
	  if ('${demographicAddressesForm.addPhoneType}' != '') { 
		  var arr = '${demographicAddressesForm.addPhoneType}';
		  var component = document.getElementsByName("phoneType[" + arr + "]");
		  component[0].focus();
	  }
  }

  // Update the address site of change
  function updateAddressSiteOfChange()
  {
    updateSiteOfChange(demographicAddressesForm.addrSourceOfUpdate, '<c:out value="${addressVamcConstant}"/>',
        demographicAddressesForm.siteOfUpdateEdit, demographicAddressesForm.siteOfUpdateEdit2, '<c:out value="${hecFacilityConstant}"/>');
  }

  // Initialize the phone sites of change
  function initPhoneSitesOfChange()
  {
    for (i = 0; i < <c:out value="${phoneCount}"/>; i++)
    {
      updateSiteOfChange(eval("demographicAddressesForm.phoneSourceOfUpdate" + i), '<c:out value="${phoneVamcConstant}"/>',
          eval("demographicAddressesForm.phoneSiteOfUpdateEdit" + i), eval("demographicAddressesForm.phoneSiteOfUpdateEdit2" + i),
          '<c:out value="${hecFacilityConstant}"/>');
    }
  }

  // Initialize the email sites of change
  function initEmailSitesOfChange()
  {
    for (i = 0; i < <c:out value="${emailCount}"/>; i++)
    {
      updateSiteOfChange(eval("demographicAddressesForm.emailSourceOfUpdate" + i), '<c:out value="${emailVamcConstant}"/>',
          eval("demographicAddressesForm.emailSiteOfUpdateEdit" + i), eval("demographicAddressesForm.emailSiteOfUpdateEdit2" + i),
          '<c:out value="${hecFacilityConstant}"/>');
    }
  }
</script>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
<html-el:form action="/demographicAddresses" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
<tr>
<td>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
  <%-- Permanent Address Section --%>
<tr>
  <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
      <tr>
        <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
        <td nowrap style="padding-left: 7px"><bean-el:message key="label.addresses.permAddressHeader"/></td>
        <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
        <td nowrap class="moduleBlueLink" style="padding: 1px 8px 1px 8px">
        <fw:link action="/demographicAddresses?methodName=goto508Notes">
            <bean-el:message key="text.508Notes"/>
        </fw:link>
        </td>
        <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
        <td nowrap class="moduleBlueLink" style="padding: 1px 8px 1px 8px"><fw:link action="/demographicAddressesHistory?methodName=DISPLAY&amp;history=viewHistoricalAddresses"><bean-el:message
            key="text.viewHistoricalAddresses"/></fw:link></td>
      </tr>
    </table>
  </td>
</tr>
<tr>
<td>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
<tr>
  <td colspan="2">
    <%@ include file="/tiles/common/instructionalText.jsp" %>
  </td>
</tr>
<tr>
  <td colspan="2" style="padding-top: 10px">
    <%@ include file="/tiles/common/addressForm.jsp" %>
      </td>
</tr>
<tr>
  <td width="45%" class="moduleLabel"><fw:label property="badAddressReason" forId="txtBadAddressReason"><bean-el:message key="label.addresses.badAddressReason"/>:</fw:label></td>
  <td width="55%" class="moduleValue">
    <c:set var="badAddressReasonText"><bean-el:message key="label.addresses.badAddressReason"/></c:set>
    <html-el:select title="${badAddressReasonText}" styleClass="moduleEdit" styleId="txtBadAddressReason" property="permBadAddressReason" disabled="${readOnlyAddress}">
      <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
      <esrcore:options collection="gov.va.med.esr.ui.common.beans.UIBadAddressReason" property="code" labelProperty="code"/>
    </html-el:select>
  </td>
</tr>
<tr>
  <td class="moduleLabel"><fw:label property="permAddrSourceOfUpdate" forId="addrSourceOfUpdate"><bean-el:message key="label.addresses.sourceOfUpdate"/>:</fw:label></td>
  <td class="moduleValue">
    <c:set var="sourceOfChangeText"><bean-el:message key="label.addresses.sourceOfUpdate"/></c:set>
    <html-el:select title="${sourceOfChangeText}" styleId="addrSourceOfUpdate" onchange="updateAddressSiteOfChange()" styleClass="moduleEdit" property="permAddrSourceOfUpdate" disabled="${readOnlyAddress}">
      <esrcore:options collection="gov.va.med.esr.common.model.lookup.AddressChangeSource" property="code" labelProperty="code"/>
    </html-el:select>
  </td>
</tr>
<tr>
  <td class="moduleLabel"><fw:label property="permAddrSiteOfUpdate" forId="siteOfUpdateEdit"><bean-el:message key="label.addresses.siteOfUpdate"/>:</fw:label></td>
  <td class="moduleValue">
    <c:set var="siteOfChangeText"><bean-el:message key="label.addresses.siteOfUpdate"/></c:set>
    <html-el:select title="${siteOfChangeText}" styleId="siteOfUpdateEdit" styleClass="moduleEdit" property="permAddrSiteOfUpdate" disabled="${readOnlyAddress}">
      <esrcore:options collection="gov.va.med.esr.ui.common.beans.VAFacility" property="code" labelProperty="siteNumberAndName"/>
    </html-el:select>
    <html-el:hidden name="demographicAddressesForm" styleId="siteOfUpdateEdit2" property="permAddrSiteOfUpdate"></html-el:hidden>
  </td>
</tr>
<tr>
  <c:set var="lastUpdateText"><bean-el:message key="label.addresses.lastUpdate"/></c:set>
  <td class="moduleLabel"><bean-el:message key="label.addresses.lastUpdate"/>:</td>
  <td title="<c:out value="${lastUpdateText}"/>" class="moduleValue" valign="top" nowrap><esrcore:displayValue name="demographicAddressesForm" property="permAddrLastUpdate" nullText=""/>
    <html-el:hidden name="demographicAddressesForm" property="permAddrLastUpdate"></html-el:hidden>
    <html-el:hidden name="demographicAddressesForm" property="permAddrCurrent"></html-el:hidden>
    <html-el:hidden name="demographicAddressesForm" property="confAddrCurrent"></html-el:hidden>
    <html-el:hidden name="demographicAddressesForm" property="tempAddrCurrent"></html-el:hidden>
  </td>
</tr>

  <%-- Phone Numbers Section --%>
<tr>
  <td colspan="2" style="padding: 10px 0 7px 0">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
      <tr>
        <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
        <td style="padding-left: 7px" nowrap><bean-el:message key="label.addresses.phoneNumbersHeader"/></td>
        <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
        <c:if test="${not readOnlyAddress}">
          <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
          <td><html-el:submit property="methodName" style="width:110; vertical-align: top;" styleClass="buttonText"><bean:message key="button.addPhoneNumber"/></html-el:submit></td>
          <td style="padding-right: 5px"><img alt=""  src="../images/buttonEndRight.gif"/></td>
        </c:if>
      </tr>
    </table>
  </td>
</tr>
<tr>
  <td colspan="2">
    <table summary="List of Phone Numbers for the Person" width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
      <c:choose>
        <c:when test="${demographicAddressesForm.noPhoneData == true}">
          <tr>
            <td class="moduleLabel" style="padding:10px 0 10px 10px; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
          </tr>
        </c:when>
        <c:otherwise>
          <thead>
          <tr>
            <c:set var="phoneTypeText"><bean-el:message key="label.addresses.phone"/> <bean-el:message key="label.addresses.type"/></c:set>
            <c:set var="phoneNumberText"><bean-el:message key="label.addresses.phone"/> <bean-el:message key="label.addresses.number"/></c:set>
            <c:set var="phoneSourceofChangeText"><bean-el:message key="label.addresses.sourceOfUpdate"/></c:set>
            <c:set var="phoneSiteOfChangeText"><bean-el:message key="label.addresses.siteOfUpdate"/></c:set>
            <c:set var="phoneLastUpdateText"><bean-el:message key="label.addresses.lastUpdate"/></c:set>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b>#</b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><fw:label property="phoneType"><bean-el:message key="label.addresses.phone"/> <bean-el:message key="label.addresses.type"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><fw:label property="phoneNumber"><bean-el:message key="label.addresses.phone"/> <bean-el:message key="label.addresses.number"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" style="padding:5px"><b><fw:label property="phoneSourceOfUpdate"><bean-el:message key="label.addresses.sourceOfUpdate"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><fw:label property="phoneSiteOfUpdate"><bean-el:message key="label.addresses.siteOfUpdate"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><bean-el:message key="label.addresses.lastUpdate"/></b></th>
            <th scope="col" class="darkValue" valign="bottom" width="100%"><img alt="" src="../images/spacer.gif" width="1" height="1"/></th>
          </tr>
          </thead>

          <c:set var="rowColor" value="darkValue"/>
          <c:forEach var="serviceEpisode" items="${demographicAddressesForm.phoneIdList}" varStatus="status">
            <c:set var="counter" value="${status.count - 1}"/>
            <html-el:hidden property="phoneId[${counter}]"/>

            <c:choose>
              <c:when test="${rowColor == 'darkValue'}">
                <c:set var="rowColor" value="value"/>
              </c:when>
              <c:otherwise>
                <c:set var="rowColor" value="darkValue"/>
              </c:otherwise>
            </c:choose>

            <tbody>
            <tr>
              <td scope="row" title="<c:out value="${status.count}"/>." style="padding:5px" class="<c:out value="${rowColor}"/>"><c:out value="${status.count}"/>.</td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>" nowrap>
                <fw:label property="phoneType[${counter}]" forId="phoneType${counter}"><span style="display:none">phoneTypeId</span></fw:label>
                <html-el:select title="${phoneTypeText} ${status.count}" styleClass="darkValue" styleId="phoneType${counter}" property="phoneType[${counter}]" disabled="${readOnlyAddress}">
                  <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
                  <esrcore:options collection="gov.va.med.esr.ui.common.beans.AddressPhoneType" property="code" labelProperty="description"/>
                </html-el:select>
              </td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>">
                <fw:label property="phoneNumber[${counter}]" forId="phoneNumber${counter}"><span style="display:none">phoneNumberId</span></fw:label>
                <html-el:text title="${phoneNumberText} ${status.count}" property="phoneNumber[${counter}]" styleClass="darkValue" styleId="phoneNumber${counter}" size="20" maxlength="20" readonly="${readOnlyAddress}"
                              onkeypress="return validatePhone(event)" onchange="formatPhoneNumber(this)"/>
              </td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>">
                <fw:label property="phoneSourceOfUpdate[${counter}]" forId="phoneSourceOfUpdate${counter}"><span style="display:none">phoneSourceOfUpdateId</span></fw:label>                
                <html-el:select title="${phoneSourceofChangeText} ${status.count}" property="phoneSourceOfUpdate[${counter}]" styleClass="darkValue" disabled="${readOnlyAddress}" styleId="phoneSourceOfUpdate${counter}"
                                onchange="updateSiteOfChange(demographicAddressesForm.phoneSourceOfUpdate${counter}, '${phoneVamcConstant}', phoneSiteOfUpdateEdit${counter}, phoneSiteOfUpdateEdit2${counter}, '${hecFacilityConstant}')">
                  <esrcore:options collection="gov.va.med.esr.common.model.lookup.PhoneSourceOfChange" property="code" labelProperty="description"/>
                </html-el:select>
              </td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>">
                <fw:label property="phoneSiteOfUpdate[${counter}]" forId="phoneSiteOfUpdateEdit${counter}"><span style="display:none">phoneSourceOfUpdateEditId</span></fw:label>                
                <html-el:select title="${phoneSiteOfChangeText} ${status.count}" styleId="phoneSiteOfUpdateEdit${counter}" styleClass="darkValue" property="phoneSiteOfUpdate[${counter}]" disabled="${readOnlyAddress}">
                  <esrcore:options collection="gov.va.med.esr.ui.common.beans.VAFacility" property="code" labelProperty="siteNumberAndName"/>
                </html-el:select>
                <fw:label property="phoneSiteOfUpdate[${counter}]" forId="phoneSiteOfUpdateEdit2${counter}"><span style="display:none">phoneSiteOfUpdateEdit2Id</span></fw:label>                
                <html-el:hidden name="demographicAddressesForm" styleId="phoneSiteOfUpdateEdit2${counter}" property="phoneSiteOfUpdate[${counter}]"></html-el:hidden>
              </td>
              <td title="<c:out value="${phoneLastUpdateText} ${status.count}"/>" style="padding:5px" class="<c:out value="${rowColor}"/>" nowrap>
                <c:out value="${demographicAddressesForm.phoneLastUpdateList[counter]}"/>                
                <html-el:hidden name="demographicAddressesForm" property="phoneLastUpdate[${counter}]"/>
              </td>
              <td class="<c:out value="${rowColor}"/>" width="100%"><img alt=""  src="../images/spacer.gif" width="1" height="1"/></td>
            </tr>
            </tbody>
          </c:forEach>
        </c:otherwise>
      </c:choose>
    </table>
  </td>
</tr>

  <%-- Email Addresses Section --%>
<tr>
  <td colspan="2" style="padding: 10px 0 7px 0">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
      <tr>
        <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
        <td style="padding-left: 7px" nowrap><bean-el:message key="label.addresses.emailAddressHeader"/></td>
        <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
        <c:if test="${not readOnlyAddress}">
          <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
          <td><html-el:submit property="methodName" style="width:110; vertical-align: top;" styleClass="buttonText"><bean:message key="button.addEmailAddress"/></html-el:submit></td>
          <td style="padding-right: 5px"><img alt=""  src="../images/buttonEndRight.gif"/></td>
        </c:if>
      </tr>
    </table>
  </td>
</tr>

<tr>
  <td colspan="2">
    <table summary="List of Email Addresses for the Person" width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
      <c:choose>
        <c:when test="${demographicAddressesForm.noEmailData == true}">
          <tr>
            <td class="moduleLabel" style="padding:10px 0 10px 10px; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
          </tr>
        </c:when>
        <c:otherwise>
          <thead>
          <tr>
            <c:set var="emailTypeText"><bean-el:message key="label.addresses.email"/> <bean-el:message key="label.addresses.type"/></c:set>
            <c:set var="emailAddressText"><bean-el:message key="label.addresses.email"/> <bean-el:message key="label.addresses.address"/></c:set>
            <c:set var="emailSourceOfChangeText"><bean-el:message key="label.addresses.sourceOfUpdate"/></c:set>
            <c:set var="emailSiteOfChangeText"><bean-el:message key="label.addresses.siteOfUpdate"/></c:set>
            <c:set var="emailLastUpdateText"><bean-el:message key="label.addresses.lastUpdate"/></c:set>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b>#</b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><fw:label property="emailType" forId="txtEmailType"><bean-el:message key="label.addresses.email"/>&nbsp<bean-el:message key="label.addresses.type"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><fw:label property="emailAddress" forId="txtEmailAddress"><bean-el:message key="label.addresses.email"/>&nbsp<bean-el:message key="label.addresses.address"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" style="padding:5px"><b><fw:label property="emailSourceOfUpdate" forId="txtEmailSourceOfUpdate"><bean-el:message key="label.addresses.sourceOfUpdate"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><fw:label property="emailSiteOfUpdate" forId="txtEmailSiteOfUpdate"><bean-el:message key="label.addresses.siteOfUpdate"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><bean-el:message key="label.addresses.lastUpdate"/></b></th>
            <th scope="col" class="darkValue" valign="bottom" width="100%"><img alt="" src="../images/spacer.gif" width="1" height="1"/></th>
          </tr>
          </thead>

          <c:set var="rowColor" value="darkValue"/>
          <c:forEach var="serviceEpisode" items="${demographicAddressesForm.emailIdList}" varStatus="status">
            <c:set var="counter" value="${status.count - 1}"/>
            <html-el:hidden property="emailId[${counter}]"/>

            <c:choose>
              <c:when test="${rowColor == 'darkValue'}">
                <c:set var="rowColor" value="value"/>
              </c:when>
              <c:otherwise>
                <c:set var="rowColor" value="darkValue"/>
              </c:otherwise>
            </c:choose>

            <tbody>
            <tr>
              <td scope="row" title="<c:out value="${status.count}"/>." style="padding:5px" class="<c:out value="${rowColor}"/>"><c:out value="${status.count}"/>.</td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>" nowrap>                
                 <fw:label property="emailType[${counter}]" forId="emailType${counter}"><span style="display:none">emailTypeId</span></fw:label>
                <html-el:select title="${emailTypeText} ${status.count}" styleClass="darkValue" styleId="emailType${counter}" property="emailType[${counter}]" disabled="${readOnlyAddress}">
                  <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
                  <esrcore:options collection="gov.va.med.esr.common.model.lookup.EmailType" property="code" labelProperty="description"/>
                </html-el:select>
                <html-el:hidden property="emailId[${counter}]"/>
              </td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>">
                <fw:label property="emailAddress[${counter}]" forId="emailAddress${counter}"><span style="display:none">emailAddressId</span></fw:label>
                <html-el:text title="${emailAddressText} ${status.count}" property="emailAddress[${counter}]" styleClass="darkValue" styleId="emailAddress${counter}" size="36" maxlength="80" readonly="${readOnlyAddress}"/>
              </td>

              <td style="padding:5px" class="<c:out value="${rowColor}"/>">
                <fw:label property="emailSourceOfUpdate[${counter}]" forId="emailSourceOfUpdate${counter}"><span style="display:none">emailSourceOfUpdateId</span></fw:label>                
                <html-el:select title="${emailSourceOfChangeText} ${status.count}" property="emailSourceOfUpdate[${counter}]" disabled="${readOnlyAddress}" styleClass="darkValue" styleId="emailSourceOfUpdate${counter}"
                                onchange="updateSiteOfChange(demographicAddressesForm.emailSourceOfUpdate${counter}, '${emailVamcConstant}', emailSiteOfUpdateEdit${counter}, emailSiteOfUpdateEdit2${counter}, '${hecFacilityConstant}')">
                  <esrcore:options collection="gov.va.med.esr.common.model.lookup.EmailSourceOfChange" property="code" labelProperty="description"/>
                </html-el:select>
              </td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>">
                <fw:label property="emailSiteOfUpdate[${counter}]" forId="emailSiteOfUpdateEdit${counter}"><span style="display:none">emailSiteOfUpdateEditId</span></fw:label>                
                <html-el:select title="${emailSiteOfChangeText} ${status.count}" styleId="emailSiteOfUpdateEdit${counter}" styleClass="darkValue" property="emailSiteOfUpdate[${counter}]" disabled="${readOnlyAddress}">
                  <esrcore:options collection="gov.va.med.esr.ui.common.beans.VAFacility" property="code" labelProperty="siteNumberAndName"/>
                </html-el:select>
                <fw:label property="emailSiteOfUpdate[${counter}]" forId="emailSiteOfUpdateEdit2${counter}"><span style="display:none">emailSiteOfUpdateEdit2Id</span></fw:label>                
                <html-el:hidden name="demographicAddressesForm" styleId="emailSiteOfUpdateEdit2${counter}" property="emailSiteOfUpdate[${counter}]"></html-el:hidden>
              </td>
              <td title="<c:out value="${emailLastUpdateText} ${status.count}"/>" style="padding:5px" class="<c:out value="${rowColor}"/>" nowrap>
                <c:out value="${demographicAddressesForm.emailLastUpdateList[counter]}"/>
                <html-el:hidden name="demographicAddressesForm" property="emailLastUpdate[${counter}]"/>
              </td>
              <td class="<c:out value="${rowColor}"/>" width="100%"><img alt=""  src="../images/spacer.gif" width="1" height="1"/></td>
            </tr>
            </tbody>
          </c:forEach>
        </c:otherwise>
      </c:choose>
    </table>
  </td>
</tr>
<tr>
  <td colspan=2 height="50">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
      <tr>
        <c:choose>
          <c:when test="${readOnlyAddress}">
            <td width="50%"><img alt=""  src="../images/spacer.gif"/></td>
            <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
            <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean:message key="button.cancel"/></html-el:submit></td>
            <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
            <td width="50%"><img alt=""  src="../images/spacer.gif"/></td>
          </c:when>
          <c:otherwise>
            <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
            <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
            <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean:message key="button.update"/></html-el:submit></td>
            <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
            <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
            <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
            <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean:message key="button.reset"/></html-el:submit></td>
            <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
            <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
            <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
            <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean:message key="button.cancel"/></html-el:submit></td>
            <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
            <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
          </c:otherwise>
        </c:choose>
      </tr>
    </table>
  </td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>
</table>

<br>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
          <td colspan="2">
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
              <tr>
                <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
                <td nowrap style="padding-left: 7px"><bean-el:message key="label.addresses.otherAddressesHeader"/></td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr valign="top">
          <td>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr style="height:31px">
                <td colspan="2">
                  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                    <tr>
                      <html-el:hidden name="demographicAddressesForm" property="confAddrCurrent"/>
                      <html-el:hidden name="demographicAddressesForm" property="permAddrCurrent"/>
                      <html-el:hidden name="demographicAddressesForm" property="tempAddrCurrent"/>
                      <html-el:hidden name="demographicAddressesForm" property="confAddrInFuture"/>
                      <html-el:hidden name="demographicAddressesForm" property="permAddrInFuture"/>
                      <html-el:hidden name="demographicAddressesForm" property="tempAddrInFuture"/>
                      <html-el:hidden name="demographicAddressesForm" property="confAddrInPast"/>
                      <html-el:hidden name="demographicAddressesForm" property="permAddrInPast"/>
                      <html-el:hidden name="demographicAddressesForm" property="tempAddrInPast"/>
                      <html-el:hidden name="demographicAddressesForm" property="tempAddrPresent"/>
                      <html-el:hidden name="demographicAddressesForm" property="confAddrPresent"/>
                      <c:choose>
                        <c:when test="${demographicAddressesForm.confAddrPresent == false}">
                          <td style="padding: 5px"><html-el:img alt="${confAddressText} ${notDefined}"  src="../images/redX.gif"/></td>
                        </c:when>
                        <c:otherwise>
                          <c:choose>
                            <c:when test="${demographicAddressesForm.confAddrCurrent == true}">
                              <td style="padding: 5px"><html-el:img alt="${confAddressText} ${current}"  src="../images/check_green.gif"/></td>
                            </c:when>
                            <c:otherwise>
                              <c:choose>
                                <c:when test="${demographicAddressesForm.confAddrInFuture == true}">
                                  <td style="padding: 5px"><html-el:img alt="${confAddressText} ${notYetCurrent}"  src="../images/invalid_future.gif"/></td>
                                </c:when>
                                <c:otherwise>
                                  <td style="padding: 5px"><html-el:img alt="${confAddressText} ${expired}"  src="../images/invalid_past.gif"/></td>
                                </c:otherwise>
                              </c:choose>
                            </c:otherwise>
                          </c:choose>
                        </c:otherwise>
                      </c:choose>
                      <td style="text-align: left" nowrap><bean-el:message key="label.addresses.confidentialAddressHeader"/></td>
                      <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
                    </tr>
                  </table>
                </td>
              </tr>
              <tr style="height:75px">
                <td width="15%" valign="top" class="label" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.address"/>:</td>
                <td width="85%" class="value" valign="top" nowrap><esrcore:displayValue name="person" property="confidentialAddress" nullText=""/></td>
              </tr>
              <tr>
                <td class="darkLabel" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.startDate"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="person" property="confidentialAddress.startDate" nullText=""/></td>
              </tr>
              <tr>
                <td class="label" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.endDate"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="person" property="confidentialAddress.endDate" nullText=""/></td>
              </tr>
              <tr>
                <td class="darkLabel" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.phone"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="person" property="confidentialPhone" nullText=""/></td>
              </tr>
              <tr>
                <td class="label" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.lastUpdate"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayDate name="person" dateProperty="confidentialAddress.changeDate" displayTime="true" nullText=""/></td>
              </tr>
              <tr>
                <td class="darkLabel" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.sourceOfUpdate"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="person" property="confidentialAddress.changeSource.code" nullText=""/></td>
              </tr>
              <tr>
                <td class="label" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.siteOfUpdate"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="person" property="confidentialAddress.changeSite.description" nullText=""/></td>
              </tr>
             <tr valign="top">
                <td class="darkLabel" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.category"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="demographicAddressesForm" property="formattedConfAddrCategories" nullText=""/></td>
              </tr>
            </table>
          </td>

          <td>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr style="height:31px">
                <td colspan="2">
                  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                    <tr>
                      <c:choose>
                        <c:when test="${demographicAddressesForm.tempAddrPresent == false}">
                          <td style="padding: 5px"><html-el:img alt="${tempAddressText} ${notDefined}"  src="../images/redX.gif"/></td>
                        </c:when>
                        <c:otherwise>
                          <c:choose>
                            <c:when test="${demographicAddressesForm.tempAddrCurrent == true}">
                              <td style="padding: 5px"><html-el:img alt="${tempAddressText} ${current}"  src="../images/check_green.gif"/></td>
                            </c:when>
                            <c:otherwise>
                              <c:choose>
                                <c:when test="${demographicAddressesForm.tempAddrInFuture == true}">
                                  <td style="padding: 5px"><html-el:img alt="${tempAddressText} ${notYetCurrent}"  src="../images/invalid_future.gif"/></td>
                                </c:when>
                                <c:otherwise>
                                  <td style="padding: 5px"><html-el:img alt="${tempAddressText} ${expired}"  src="../images/invalid_past.gif"/></td>
                                </c:otherwise>
                              </c:choose>
                            </c:otherwise>
                          </c:choose>
                        </c:otherwise>
                      </c:choose>
                      <td nowrap><bean-el:message key="label.addresses.temporaryAddressHeader"/></td>
                      <td width="100%"><img alt="" src="../images/spacer.gif"></td>
                    </tr>
                  </table>
                </td>
              </tr>
              <tr style="height:75px">
                <td width="15%" class="label" valign="top" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.address"/>:</td>
                <td width="85%" class="value" valign="top" nowrap><esrcore:displayValue name="person" property="temporaryCorrespondenceAddress" nullText=""/></td>
              </tr>
              <tr>
                <td class="darkLabel" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.startDate"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="person" property="temporaryCorrespondenceAddress.startDate" nullText=""/></td>
              </tr>
              <tr>
                <td class="label" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.endDate"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="person" property="temporaryCorrespondenceAddress.endDate" nullText=""/></td>
              </tr>
              <tr>
                <td class="darkLabel" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.phone"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="person" property="temporaryCorrespondenceAddress.phoneNumber" nullText=""/></td>
              </tr>
              <tr>
                <td class="label" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.lastUpdate"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayDate name="person" dateProperty="temporaryCorrespondenceAddress.changeDate" displayTime="true" nullText=""/></td>
              </tr>
              <tr>
                <td class="darkLabel" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.sourceOfUpdate"/>:</td>
                <td class="darkValue" valign="top" nowrap><esrcore:displayValue name="person" property="temporaryCorrespondenceAddress.changeSource.code" nullText=""/></td>
              </tr>
              <tr>
                <td class="label" style="text-align: left; padding-left: 10px" nowrap><bean-el:message key="label.addresses.siteOfUpdate"/>:</td>
                <td class="value" valign="top" nowrap><esrcore:displayValue name="person" property="temporaryCorrespondenceAddress.changeSite.description" nullText=""/></td>
              </tr>
              <tr>
                <td class="darkLabel" style="text-align: left; padding-left: 10px" nowrap>&nbsp;</td>
                <td class="darkValue" valign="top" nowrap>&nbsp;</td>
              </tr>
              
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
  <html-el:hidden name="demographicAddressesForm" property="addAPerson"/>
</html-el:form>
</table>
