<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el"%>
<%@ taglib uri="/tags/struts-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="/tags/esr-core" prefix="esrcore"%>
<%@ taglib uri="/tags/fw" prefix="fw"%>

<c:set var="displayRequiredFieldsIndicator" scope="page" value="false" />
<c:set var="zipCodeLookup" scope="page" value="true" />

<%-- add a person flag --%>
<c:set var="isAddAPerson" value="false"></c:set>
<c:set var="displayAddAPersonRequiredFieldIndicator" scope="page" value="false"/>
<c:if test="${associationInfoForm.addAPerson == 'true'}">
    <c:set var="isAddAPerson" value="true"></c:set>
    <c:set var="displayAddAPersonRequiredFieldIndicator" value="true"></c:set>
    <c:set var="displayRequiredFieldsIndicator" scope="page" value="false"/>
</c:if>

<script>

// change the visible of the first child of elemId.  This just
// hides the required star indicator.
// Pass 0 to hide anything else to show
function changeVis(elemId, vis) {
    elem = document.getElementById(elemId);
    if (elem == null) return;
    elemFirst = elem.firstChild;
	requiredImgNode = elemFirst.childNodes.length - 2;	
	elemNext = elemFirst.childNodes[requiredImgNode];
	chosenElem = elemFirst;
	
	if(elemFirst.className != "errorValidation") {	
			chosenElem = elemFirst;
		}
		else{		
			chosenElem = elemNext
		}		
	
    if (vis == 0) {	
		chosenElem.style.visibility = 'hidden';    
	} else {
		chosenElem.style.visibility = '';
	    
	}
}


function changeRole(roleSelect) {
	selector = document.getElementsByName(roleSelect);
    // get the element holding the value of the option. In IE there are
    // 2 selectors and in Firefox there is only 1, but in both cases it 
    // is the last item in the list.
	if (selector.length > 0) {
	    elem = selector[selector.length - 1];
	} else {
		return;
    }
    value = elem.value;
    if (value == null || value == "") {
    	return;
    }
    
    if (value >= 1 && value  <= 5) {
        changeVis("orgName", 0);
        changeVis("fNameLabel", 1);
        changeVis("lNameLabel", 1);
        changeVis("addressLine1Label", 1);
        changeVis("zipCodeLabel", 1);
        changeVis("stateLabel", 1);
        changeVis("cityLabel", 1);
        changeVis("phoneLabel", 1);
    } else {
        changeVis("orgName", 1);
        changeVis("fNameLabel", 0);
        changeVis("lNameLabel", 1);
        changeVis("addressLine1Label", 0);
        changeVis("zipCodeLabel", 0);
        changeVis("stateLabel", 0);
        changeVis("cityLabel", 0);
        changeVis("phoneLabel", 0);
    }
    
    if (value == 1 || value == 2) {
    	changeVis("relationshipLabel", 1);
    } else {
    	changeVis("relationshipLabel", 0);
    }
}

// see if there is a valid for the field. This returns the lenght so
// 0 is no value and > 1 is a valid.  Pass in a TD field because this
// gets the firstChild.nextSibling and checks that value.
function valueExists(fieldName) {

	field = document.getElementById(fieldName);
	len = 0;
	
	if (field == null) return 0;
		
	// get the value.
	value = field.firstChild.value;
	
	if (value == null) return 0;
	
	return value.length;
}

// check the address files to make sure there is a phone number or address.
// this changeds the visibility of the required star depnending on the 
// vales in the address and phone fields. 
function checkAddress(roleSelect, field) {
	selector = document.getElementsByName(roleSelect);
	if (selector.length > 0) {
	    elem = selector[selector.length - 1];
	} else {
		return;
    }
    value = elem.value;
    if (value == null || value == "") return;
    
    totLen = 0;
   if (value >= 1 && value <= 5) {
   // make sure there is phone number or address
      if (valueExists("phoneValue")) {
        changeVis("addressLine1Label", 0);
        changeVis("zipCodeLabel", 0);
        changeVis("stateLabel", 0);
        changeVis("cityLabel", 0);
        changeVis("phoneLabel", 1);
    } else if (valueExists("addressLine1Edit")
	    || valueExists("cityEdit")
	    || valueExists("stateEdit")
	    || valueExists("zipCodeEdit")) {
	        changeVis("addressLine1Label", 1);
	        changeVis("zipCodeLabel", 1);
	        changeVis("stateLabel", 1);
	        changeVis("cityLabel", 1);
	        changeVis("phoneLabel", 0);	    
	 }
    }
    
}

function checkPhoneNum(t, role, name) {
   formatPhoneNumber(t);
   checkAddress(role, name);
}

// The changeRole() function needs to be called when the page loads. Since there is already
// an onload function defined in the <body> tag we need to have a new function call the
// original onload function and the new function.
function start() {
	onLoadInit();
  	changeVis("relationshipLabel", 0);
    changeVis("orgName", 0);
    changeVis("fNameLabel", 0);
    changeVis("lNameLabel", 0);
   	changeVis("addressLine1Label", 0);
    changeVis("cityLabel", 0);
    changeVis("stateLabel", 0);
    changeVis("zipCodeLabel", 0);
	changeVis("phoneLabel", 0);
	
	changeRole('role');
	checkAddress('role','phoneValue');
}
// redefine the new onload fucnction.
window.onload = start;

</script>

<table width="100%" border="0" cellpadding="0" cellspacing="0"
	class="moduleShellTableBody" role="presentation">
	<tr>
		<td width="45%" class="moduleLabel" id="relationshipLabel">
		    <fw:label required="true" property="relationship" forId="txtRelationship">
			<bean-el:message key="label.association.relationship" />:</fw:label></td>
		<c:set var="relationshipText">
			<bean-el:message key="label.association.relationship" />
		</c:set>
		<td width="55%" class="moduleValue"><html-el:text
			title="${relationshipText}" property="relationship" onblur="toUpperCase(this)"
			styleId="txtRelationship" styleClass="moduleEdit" size="40" maxlength="30" /></td>
	</tr>
	<tr>
		<td class="moduleLabel" valign="top">
		    <fw:label required="true" property="role" forId="txtRole">
			<bean-el:message key="label.association.role" />:</fw:label></td>
		<td class="moduleValue" id="role"><c:set var="roleText">
			<bean-el:message key="label.required" />,&nbsp;<bean-el:message
				key="label.association.role" />
		</c:set> <c:choose>
			<c:when test="${pageName == 'addAssociation'}">
				<html-el:select title="${roleText}" styleId="txtRole" styleClass="moduleEdit"
					property="role" onChange="changeRole('role')">
					<html-el:option value="">
						<bean-el:message key="label.select" />
					</html-el:option>
					
					<c:choose>
					<c:when test="${isAddAPerson}">	
					<!--  display the list for add a person -->
						<esrcore:options
							collection="gov.va.med.esr.ui.common.beans.UIAssociationTypeAddPerson"
							property="code" labelProperty="description" />
					
					</c:when>
					<c:otherwise>
					<!--  display the list for a veteran search -->
						<esrcore:options
							collection="gov.va.med.esr.ui.common.beans.UIAssociationType"
							property="code" labelProperty="description" />
					</c:otherwise>	
					</c:choose>
						
						
				</html-el:select>
				</c:when>
               <c:otherwise>
				<html-el:hidden property="role" />
				<html-el:select title="${roleText}" styleId="txtRole" styleClass="moduleEdit"
					disabled="true" property="role"
					onchange="changeRole('role')">
					<esrcore:options
						collection="gov.va.med.esr.ui.common.beans.UIAssociationType"
						property="code" labelProperty="description" />
				</html-el:select>
				
				

	           </c:otherwise>
	
		</c:choose></td>
	</tr>

	<tr>
		<td class="moduleLabel" id="orgName"><fw:label required="true"
			property="organizationName" forId="txtOrganizationName">
			<bean-el:message key="label.association.organizationName" />:</fw:label>
	</td>
		<td class="moduleValue"><c:set var="organizationNameText">
			<bean-el:message key="label.required" />,&nbsp;<bean-el:message
				key="label.association.organizationName" />
		</c:set> <html-el:text title="${organizationNameText}"
			property="organizationName" styleId="txtOrganizationName" styleClass="moduleEdit" onblur="toUpperCase(this)" size="40"
			maxlength="35" /></td>
	</tr>

	<!-- display the names -->
	<tr>
		<td class="moduleLabel" id="fNameLabel"><fw:label required="true"
			property="firstName" forId="txtFirstName">
			<bean-el:message key="label.association.firstName" />:</fw:label></td>
		<td class="moduleValue"><c:set var="firstNameText">
			<bean-el:message key="label.required" />,&nbsp;<bean-el:message
				key="label.association.firstName" />
		</c:set> <html-el:text title="${firstNameText}" property="firstName"
			styleClass="moduleEdit" styleId="txtFirstName" onblur="toUpperCase(this)" size="40" maxlength="35" /></td>
	</tr>

	<tr>
		<td class="moduleLabel"><fw:label property="middleName" forId="txtMiddleName"> 
			<bean-el:message key="label.association.middleName" />:</fw:label></td>
		<td class="moduleValue"><c:set var="middleNameText">
			<bean-el:message key="label.required" />,&nbsp;<bean-el:message
				key="label.association.middleName" />
		</c:set> <html-el:text title="${middleNameText}" property="middleName"
			styleClass="moduleEdit" styleId="txtMiddleName" onblur="toUpperCase(this)" size="40" maxlength="35" /></td>
	</tr>

	<tr>
		<td class="moduleLabel" id="lNameLabel"><fw:label
			required="true" property="lastName" forId="txtLastName">
			<bean-el:message key="label.association.lastName" />:</fw:label></td>
		<td class="moduleValue"><c:set var="lastNameText">
			<bean-el:message key="label.required" />,&nbsp;<bean-el:message
				key="label.association.lastName" />
		</c:set> <html-el:text title="${lastNameText}" property="lastName" styleId="txtLastName" onblur="toUpperCase(this)"
			styleClass="moduleEdit" size="40" maxlength="35" /></td>
	</tr>
	
	<c:set var="displayRequiredFieldsIndicator" value="true"></c:set>
	<%@ include file="/tiles/common/addressForm.jsp"%>

	<table width="100%" border="0" cellpadding="0" cellspacing="0"
		class="moduleShellTableBody" role="presentation">
		<tr>
			<td width="45%" class="moduleLabel" id="phoneLabel"><fw:label
				required="true" property="phone" forId="txtPhoneLabel">
				<bean-el:message key="label.addresses.phone" />:</fw:label></td>
			<c:set var="phoneText">
				<bean-el:message key="label.addresses.phone" />
			</c:set>
			<td width="55%" id="phoneValue" class="moduleValue">
			<html-el:text 
				title="${phoneText}" property="phone" styleId="txtPhoneLabel" styleClass="moduleEdit"
				size="40" maxlength="20" onkeypress="return validatePhone(event)" onchange="checkPhoneNum(this, 'role', 'phoneValue')" />
			</td>
		</tr>
		<c:if test="${pageName == 'updateAssociation'}">
			<tr>
				<td class="moduleLabel"><bean-el:message
					key="label.association.phoneNumber" /> <bean-el:message
					key="label.addresses.lastUpdate" />:</td>
				<c:set var="phoneNumberText">
					<bean-el:message key="label.association.phoneNumber" />
					<bean-el:message key="label.addresses.lastUpdate" />
				</c:set>
				<td title="<c:out value="${phoneNumberText}"/>" class="moduleValue"><esrcore:displayValue
					name="associationInfoForm" property="phoneChangeDate" /></td>
			</tr>

			<tr>
				<td class="moduleLabel"><fw:label property="deactivationDate" forId="txtDeactivationDate">
					<bean-el:message key="label.personal.deactivationDate" />:</fw:label></td>
				<c:set var="deactivationDateText">
					<bean-el:message key="label.personal.deactivationDate" />&nbsp;<c:out
						value="${mmddyyyyText}" />
				</c:set>
				<td class="moduleValue"><html-el:text
					title="${deactivationDateText}" styleClass="moduleEdit"
					property="deactivationDate" styleId="txtDeactivationDate" size="20" maxlength="10" />&nbsp;<bean-el:message
					key="label.mmddyyyy" /></td>
			</tr>

		</c:if>
	</table>	
	
	<html-el:hidden name="associationInfoForm" property="addAPerson"/>
