<script language="JavaScript" src="../scripts/ESR-Script.js"></script>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="capabilityText" scope="page"><bean-el:message key="label.capability"/></c:set>
<c:set var="capabilitySetText" scope="page"><bean-el:message key="label.capabilitySet"/></c:set>
<c:set var="roleText" scope="page"><bean-el:message key="label.role"/></c:set>

<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>
<c:set var="selectLabel" value="Select" />
<c:set var="activeDateLabel"><bean-el:message key="label.activeDate"/></c:set>
<c:set var="inactiveDateLabel"><bean-el:message key="label.inactivedate"/></c:set>

<script language="javascript">

function expandAllAssigned()
{
	//expand roles and capability sets
	expandCollapseLists("assignedRoleList", "assignedRoleListImage", "assignedRoleListHiddenId", "Set");
	//expand capability sets
	expandCollapseLists("assignedCapSetList", "assignedCapSetListImage", "assignedCapSetListHiddenId", null);
	//revert the expand collapse links
	document.getElementById("collapseAllAssignedLink").style.display="block";
	document.getElementById("expandAllAssignedLink").style.display="none";
	return false;
}

function collapseAllAssigned()
{
	//collapse roles and capability sets
	expandCollapseLists("assignedRoleList", "assignedRoleListImage", "assignedRoleListHiddenId", "Set");
	//collapse capability sets
	expandCollapseLists("assignedCapSetList", "assignedCapSetListImage", "assignedCapSetListHiddenId", null);
	//revert the expand collapse links
	document.getElementById("collapseAllAssignedLink").style.display="none";
	document.getElementById("expandAllAssignedLink").style.display="block";
	return false;
}

function expandAllAvailable()
{
	//expand roles and capability sets
	expandCollapseLists("roleList", "roleListImage", "roleListHiddenId", "Set");
	//expand capability sets
	expandCollapseLists("capSetList", "capSetListImage", "capSetListHiddenId", null);
	//revert the expand collapse links
	document.getElementById("collapseAllAvailableLink").style.display="block";
	document.getElementById("expandAllAvailableLink").style.display="none";
	return false;
}

function collapseAllAvailable()
{
	//expand roles and capability sets
	expandCollapseLists("roleList", "roleListImage", "roleListHiddenId", "Set");
	//expand capability sets
	expandCollapseLists("capSetList", "capSetListImage", "capSetListHiddenId", null);
	//revert the expand collapse links
	document.getElementById("collapseAllAvailableLink").style.display="none";
	document.getElementById("expandAllAvailableLink").style.display="block";
	return false;
}
</script>

<table width="100%" border="1" cellpadding="0" cellspacing="0" class="moduleShell">
<html-el:form action="/editUserProfile" method="post">
<%@ include file="/admin/csrfgentoken.jsp" %>

<html-el:hidden name="userProfileForm" property="readOnly" />

<c:set var="readOnlyUser" value="false"/>
<c:if test="${userProfileForm.readOnly == true}">
	<c:set var="readOnlyUser" value="true"/>
</c:if>

 <tr>
  <td>
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
    <tr>
     <td>
 	  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
		  <tr>
			<td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
			<td nowrap style="padding-left: 7">
				<c:choose>
					<c:when test="${readOnlyUser}">
						View User Profile
					</c:when>
					<c:otherwise>
					    <bean-el:message key="label.editUserProfile"/>
					</c:otherwise>
				</c:choose>
			</td>
			<td width="90%"><img alt=""  src="../images/spacer.gif"></td>
			<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
				<fw:link action="/searchUserProfile?methodName=DISPLAY ALL">
				<bean-el:message key="label.link.returnToUserProfiles"/>
				</fw:link>
			</td>
			<td width="2%"><img alt=""  src="../images/spacer.gif"></td>
			<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
				<fw:link action="/viewUserProfileHistory?methodName=DISPLAY&amp;history=viewHistoricalUserProfile"
					paramId="entityId" paramName="userProfileForm" paramProperty="userId">
				<bean-el:message key="label.link.viewHistoricalUserProfile"/>
				</fw:link>
			</td>
		  </tr>
	  </table>
     </td>
    </tr>

		<tr>
		 <td>
		  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
			<!-- read only fields -->
			<tr>
            <th width="45%" class="moduleLabel"><bean-el:message key="label.userName"/>:</th>
            <td width="55%" class="moduleValue">
				<esrcore:displayValue name="userProfileForm" property="fullName" />
				<html-el:hidden name="userProfileForm" property="name" />
				<html-el:hidden name="userProfileForm" property="userId" />
				<html-el:hidden name="userProfileForm" property="fullName" />
			</td>
			</tr>

			<!-- editable fields -->
			<tr>
            <td width="45%" class="moduleLabel"><fw:label property="functionalGroup" forId="txtFunctionalGroup"><bean-el:message key="label.functionalGroup"/>:</fw:label></td>
            <td class="moduleValue">
				<esrcore:displayLookupValue name="userProfileForm" property="functionalGroup"
					lookupType="gov.va.med.esr.common.model.lookup.FunctionalGroup" lookupProperty="description"/>
				<html-el:hidden name="userProfileForm" property="functionalGroup" />
			    <!--
				<html-el:select styleClass="moduleEdit" property="functionalGroup" >
					<html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
					<esrcore:options collection="gov.va.med.esr.common.model.lookup.FunctionalGroup" property="code" labelProperty="description"/>
                </html-el:select>
				-->
			</td>
			</tr>
			</table>
	       </td>
	    </tr>
		<!-- Allocated roles/capabilitysets and capabilities -->
	    <tr>
		    <td>
 	          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead">
		      <tr>
				<td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
				<td nowrap style="padding-left: 7"><bean-el:message key="label.rolesAssigned"/></td>
				<td width="100%"><img alt=""  src="../images/spacer.gif"></td>
				<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
					<div id="expandAllAssignedLink" style="display:block">
						<fw:link onclick="return(expandAllAssigned());return false"
						action="none">EXPAND ALL</fw:link>
					</div>
					<div id="collapseAllAssignedLink" style="display:none">
						<fw:link onclick="return(collapseAllAssigned());return false"
						action="none">COLLAPSE ALL</fw:link>
					</div>
				</td>
		       </tr>
		       </table>
             </td>
        </tr>

		<tr><td>
		  <table summary="List of Assigned Roles for the Selected User" width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
		        <thead>
			<tr>
				<th scope="col" nowrap width="5%" class="moduleLabel" style="text-align: left; padding-left: 5"><c:out value="${selectLabel}"/></th>
				<th scope="col" nowrap width="5%" class="moduleLabel" style="text-align: left; padding-left: 5">&nbsp;</th>
				<th scope="col" nowrap width="50%" class="moduleLabel" style="text-align: left; padding-left: 5"><bean-el:message key="label.name"/></th>
				<th scope="col" nowrap width="5%" class="moduleLabel" style="text-align: left; padding-left: 5"><bean-el:message key="label.activeDate"/></th>
				<th scope="col" nowrap width="5%" class="moduleLabel" style="text-align: left; padding-left: 5"><bean-el:message key="label.inactivedate"/></th>
				<th scope="col" nowrap width="30%" class="moduleLabel" style="text-align: left; padding-left: 5">&nbsp;</th>
			</tr>
			</thead>
			
			<%-- Assigned Roles  --%>
			<c:if test="${not empty userProfileForm.assignedRoleNameList}">
			<c:forEach var="role" items="${userProfileForm.assignedRoleNameList}" varStatus="status">
				<c:set var="counter" value="${status.count - 1}" />
				<c:set var="roleid" value="${userProfileForm.assignedRoleIdList[counter]}"/>
				<c:set var="refRole" value="${REF_ROLES[roleid]}"/>
				<tr>
					<td class="moduleValue" style="padding:5 5 5 5">					    
						<html-el:checkbox title="${selectLabel} ${refRole.name}" property="assignedRoleInd[${counter}]" disabled="${readOnlyUser}" styleId="assignedRoleInd${counter}"/>
						<html-el:hidden property="assignedRoleId[${counter}]" />
						<html-el:hidden property="assignedRoleName[${counter}]" />
					</td>
					<td class="moduleValue" style="padding:5 5 5 5"><html-el:img alt="${roleText}"  src="../images/role.gif"/></td>
          <td scope="row" nowrap style="text-align: left;padding:5 5 5 5" class="moduleLabel">
            <fw:link href="." onclick="expandOrCollapse(assignedRoleList${counter}, assignedRoleListImage${counter}, assignedRoleListHiddenId${counter}); return false">
              <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="assignedRoleListImage${counter}" src="../images/redArrowRight.gif"/>
              <fw:label property="assignedRoleName[${counter}]" forId="assignedRoleInd${counter}"><c:out value="${refRole.name}"/></fw:label>
            </fw:link>
            <input name="assignedRoleListHiddenId<c:out value="${counter}"/>" id="assignedRoleListHiddenId<c:out value="${counter}"/>" type="hidden" value="false"/>
          </td>
					<td class="moduleValue" style="padding:5 5 5 5">
						<html-el:hidden property="assignedRoleActiveDate[${counter}]" />
						<c:out value="${userProfileForm.assignedRoleActiveDateList[counter]}"/>
					</td>
					<td class="moduleValue" style="padding:5 5 5 5">
						<html-el:hidden property="assignedRoleInactiveDate[${counter}]" />
						<c:out value="${userProfileForm.assignedRoleInactiveDateList[counter]}"/>
					</td>
				</tr>
				<%-- Assigned role capability sets and capabilities --%>
			    <tr>
					<td colspan="2"><img alt=""  src="../images/spacer.gif" width="1" height="1" /></td>
					<td colspan="3">
				    <div id="<c:out value="assignedRoleList${counter}"/>" class="expandCollapseBody">
					   <table>
					   <c:set var="rowColor" value="moduleValue"/>
					   <c:forEach var="capabilitySet" items="${refRole.capabilitySets}" varStatus="setStatus">
						   <c:set var="setCounter" value="${setStatus.count - 1}" />
							<tr>
								<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
									&nbsp;
								</td>
                <td nowrap style="text-align: left;padding:5 5 5 5" class="moduleLabel">
                  <fw:link href="." onclick="expandOrCollapse(assignedRoleList${counter}Set${setCounter}, assignedRoleListImage${counter}Set${setCounter}, assignedRoleListHiddenId${counter}Set${setCounter}); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="assignedRoleListImage${counter}Set${setCounter}" src="../images/redArrowRight.gif"/><c:out value="${capabilitySet.name}"/>
                  </fw:link>
                  <input name="assignedRoleListHiddenId<c:out value="${counter}"/>Set<c:out value="${setCounter}"/>" id="assignedRoleListHiddenId<c:out value="${counter}"/>Set<c:out value="${setCounter}"/>" type="hidden" value="false"/>
                </td>
								<td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
							</tr>
						    <%-- role - set - capabilities --%>
							<tr>
								<td colspan="1"><img alt=""  src="../images/spacer.gif" width="1" height="1" /></td>
								<td colspan="2">
								<div id="<c:out value="assignedRoleList${counter}Set${setCounter}"/>" class="expandCollapseBody">
								   <table>
								   <c:set var="rowColor" value="moduleValue"/>
								   <c:forEach var="capability" items="${capabilitySet.capabilities}" varStatus="status">
										<tr>
											<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
												&nbsp;
											</td>
											<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
												<c:out value="${capability.name}"/>
											</td>
											<td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
										</tr>
								   </c:forEach>
								   </table>
								</div>
								</td>
							</tr>
					   </c:forEach>
				       <c:forEach var="capability" items="${refRole.capabilities}" varStatus="status">
							<tr>
								<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
									&nbsp;
								</td>
								<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
									<c:out value="${capability.name}"/>
								</td>
								<td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
							</tr>
					   </c:forEach>
					   </table>
				    </div>
					</td>
				</tr>
			</c:forEach>
			</c:if>
			<%-- Assigned CapabilitySets --%>
			<c:if test="${not empty userProfileForm.assignedCapabilitySetNameList}">
			<c:forEach var="capabilitySet" items="${userProfileForm.assignedCapabilitySetNameList}" varStatus="status">
				<c:set var="counter" value="${status.count - 1}" />
				<c:set var="setid" value="${userProfileForm.assignedCapabilitySetIdList[counter]}"/>
				<c:set var="refCapabilitySet" value="${REF_CAPABILITY_SETS[setid]}"/>
				<tr>
					<td class="moduleValue" style="padding:5 5 5 5">						
						<html-el:checkbox title="${selectLabel} ${userProfileForm.assignedCapabilitySetNameList[counter]}" property="assignedCapabilitySetInd[${counter}]" disabled="${readOnlyUser}" styleId="assignedCapabilitySetInd${counter}"/>
						<html-el:hidden property="assignedCapabilitySetId[${counter}]"/>
						<html-el:hidden property="assignedCapabilitySetName[${counter}]"/>
					</td>
					<td class="moduleValue" style="padding:5 5 5 5"><html-el:img alt="${capabilitySetText}"  src="../images/capabilitySet.gif"/></td>
          <td nowrap style="text-align: left;padding:5 5 5 5" class="moduleLabel">
            <fw:link href="." onclick="expandOrCollapse(assignedCapSetList${counter}, assignedCapSetListImage${counter}, assignedCapSetListHiddenId${counter}); return false">
              <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="assignedCapSetListImage${counter}" src="../images/redArrowRight.gif"/>
              <fw:label property="assignedCapabilitySetName[${counter}]" forId="assignedCapabilitySetInd${counter}"><c:out value="${userProfileForm.assignedCapabilitySetNameList[counter]}"/></fw:label>
            </fw:link>
            <input name="assignedCapSetListHiddenId<c:out value="${counter}"/>" id="assignedCapSetListHiddenId<c:out value="${counter}"/>" type="hidden" value="false"/>
          </td>
					<td class="moduleValue" style="padding:5 5 5 5">
						<html-el:hidden property="assignedCapabilitySetActiveDate[${counter}]" />
						<c:out value="${userProfileForm.assignedCapabilitySetActiveDateList[counter]}"/>
					</td>
					<td class="moduleValue" style="padding:5 5 5 5">
						<html-el:hidden property="assignedCapabilitySetInactiveDate[${counter}]" />
						<c:out value="${userProfileForm.assignedCapabilitySetInactiveDateList[counter]}"/>
					</td>
				</tr>
			    <tr>
					<td colspan="2"><img alt=""  src="../images/spacer.gif" width="1" height="1" /></td>
					<td colspan="3">
				    <div id="<c:out value="assignedCapSetList${counter}"/>" class="expandCollapseBody">
					   <table>
					   <c:set var="rowColor" value="moduleValue"/>
					   <c:forEach var="capability" items="${refCapabilitySet.capabilities}" varStatus="status">
							<tr>
								<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
									&nbsp;
								</td>
								<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
									<c:out value="${capability.name}"/>
								</td>
								<td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
							</tr>
					   </c:forEach>
					   </table>
				    </div>
					</td>
				</tr>
			</c:forEach>
			</c:if>

		    <%-- Assigned Capabilities --%>
			<c:if test="${not empty userProfileForm.assignedCapabilityNameList}">
			<c:forEach var="capability" items="${userProfileForm.assignedCapabilityNameList}" varStatus="status">
				<c:set var="counter" value="${status.count - 1}" />
				<tr>
					<td class="moduleValue" style="padding:5 5 5 5">					    
						<html-el:checkbox title="${selectLabel} ${userProfileForm.assignedCapabilityNameList[counter]}" name="userProfileForm" property="assignedCapabilityInd[${counter}]" disabled="${readOnlyUser}" styleId="assignedCapabilityInd${counter}"/>
						<html-el:hidden name="userProfileForm" property="assignedCapabilityCode[${counter}]" />
						<html-el:hidden name="userProfileForm" property="assignedUserCapabilityId[${counter}]" />
						<html-el:hidden name="userProfileForm" property="assignedCapabilityOldActiveDate[${counter}]" />
						<html-el:hidden name="userProfileForm" property="assignedCapabilityOldInactiveDate[${counter}]" />
					</td>
					<td class="moduleValue" style="padding:5 5 5 5"><html-el:img alt="${capabilityText}"  src="../images/capability.gif"/></td>
					<td nowrap class="moduleValue" style="padding:5 5 5 5">
						<html-el:hidden name="userProfileForm" property="assignedCapabilityName[${counter}]" />
						<fw:label property="assignedCapabilityName[${counter}]" forId="assignedCapabilityInd${counter}">
						<c:out value="${userProfileForm.assignedCapabilityNameList[counter]}"/>
						</fw:label>
					</td>
					<td class="moduleValue" style="padding:5 5 5 5">	
						<fw:label property="assignedCapabilityActiveDate[${counter}]" forId="assignedCapabilityActiveDate${counter}"><span style="display:none">assignedCapabilityActiveDate</span></fw:label>										    
						<html-el:text  title="${activeDateLabel} for ${userProfileForm.assignedCapabilityNameList[counter]}" property="assignedCapabilityActiveDate[${counter}]" size="12" maxlength="10" readOnly="${readOnlyUser}" styleId="assignedCapabilityActiveDate${counter}"/>
					</td>
					<td class="moduleValue" style="padding:5 5 5 5">	
					    <fw:label property="assignedCapabilityInactiveDate[${counter}]" forId="assignedCapabilityInactiveDate${counter}"><span style="display:none">assignedCapabilityInactiveDate</span></fw:label>					    				    
						<html-el:text  title="${inactiveDateLabel} for ${userProfileForm.assignedCapabilityNameList[counter]}" property="assignedCapabilityInactiveDate[${counter}]" size="12" maxlength="10" readOnly="${readOnlyUser}" styleId="assignedCapabilityInactiveDate${counter}"/>
					</td>
				</tr>
			</c:forEach>
			</c:if>
		  </table>
		</td></tr>

	   <!-- Available roles/capabilitysets and capabilities -->
	   <%-- available table heading --%>
	<c:if test="${not readOnlyUser}">
	   <tr>
		   <td>
 	   		<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead">
				  <tr>
					<td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
					<td nowrap style="padding-left: 7"><bean-el:message key="label.rolesAvailable"/></td>
					<td width="100%"><img alt=""  src="../images/spacer.gif"></td>

  				<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
  					<div id="expandAllAvailableLink" style="display:block">
  						<fw:link onclick="return(expandAllAvailable());return false"
  						action="none">EXPAND ALL</fw:link>
  					</div>
  					<div id="collapseAllAvailableLink" style="display:none">
  						<fw:link onclick="return(collapseAllAvailable());return false"
  						action="none">COLLAPSE ALL</fw:link>
  					</div>
  				</td>
				  </tr>
			 </table>
		    </td>
		</tr>

        <%-- Availbale table --%>
		<tr><td>
		  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
			<c:set var="rowColor" value="darkValue" />
			<tr>
			<tr>
				<th nowrap width="5%" class="moduleLabel" style="text-align: left; padding-left: 5">Select</th>
				<th nowrap width="5%" class="moduleLabel" style="text-align: left; padding-left: 5">&nbsp;</th>
				<th nowrap width="50%" class="moduleLabel" style="text-align: left; padding-left: 5"><bean-el:message key="label.name"/></th>
				<th nowrap width="5%" class="moduleLabel" style="text-align: left; padding-left: 5"><bean-el:message key="label.activeDate"/></th>
				<th nowrap width="5%" class="moduleLabel" style="text-align: left; padding-left: 5"><bean-el:message key="label.inactivedate"/></th>
				<th nowrap width="30%" class="moduleLabel" style="text-align: left; padding-left: 5">&nbsp;</td>
			</tr>
			<%-- Available Roles --%>
			<c:forEach var="role" items="${userProfileForm.roleNameList}" varStatus="status">
				<c:set var="counter" value="${status.count - 1}" />
				<c:set var="roleid" value="${userProfileForm.roleIdList[counter]}"/>
				<c:set var="refRole" value="${REF_ROLES[roleid]}"/>
				<c:set var="active" value="${refRole.assignable}"/>
				<tr>
					<td class="moduleValue" style="padding:5 5 5 5">						
						<html-el:checkbox title="${selectLabel} ${refRole.name}" property="roleInd[${counter}]" disabled="${not active}" styleId="roleInd${counter}"/>
						<html-el:hidden property="roleId[${counter}]" />
						<html-el:hidden property="roleName[${counter}]" />
					</td>
					<td class="moduleValue" style="padding:5 5 5 5"><html-el:img alt="${roleText}"  src="../images/role.gif"/></td>
          <td nowrap style="text-align: left;padding:5 5 5 5" class="moduleLabel">
            <fw:link href="." onclick="expandOrCollapse(roleList${counter}, roleListImage${counter}, roleListHiddenId${counter}); return false">
              <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="roleListImage${counter}" src="../images/redArrowRight.gif"/>
              <fw:label property="roleName[${counter}]" forId="roleInd${counter}"><c:out value="${refRole.name}"/></fw:label>
            </fw:link>
            <input name="roleListHiddenId<c:out value="${counter}"/>" id="roleListHiddenId<c:out value="${counter}"/>" type="hidden" value="false"/>
          </td>
					<td class="moduleValue" style="padding:5 5 5 5">
						<html-el:hidden property="roleActiveDate[${counter}]" />
						<c:out value="${userProfileForm.roleActiveDateList[counter]}"/>
					</td>
					<td class="moduleValue" style="padding:5 5 5 5">
						<html-el:hidden property="roleInactiveDate[${counter}]" />
						<c:out value="${userProfileForm.roleInactiveDateList[counter]}"/>
					</td>
				</tr>
				<%-- Available role capability sets and capabilities --%>
			    <tr>
					<td colspan="2"><img alt=""  src="../images/spacer.gif" width="1" height="1" /></td>
					<td colspan="3">
				    <div id="<c:out value="roleList${counter}"/>" class="expandCollapseBody">
					   <table>
					   <c:set var="rowColor" value="moduleValue"/>
					   <c:forEach var="capabilitySet" items="${refRole.capabilitySets}" varStatus="setStatus">
						   <c:set var="setCounter" value="${setStatus.count - 1}" />
							<tr>
								<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
									&nbsp;
								</td>
                <td nowrap style="text-align: left;padding:5 5 5 5" class="moduleLabel">
                  <fw:link href="." onclick="expandOrCollapse(roleList${counter}Set${setCounter}, roleListImage${counter}Set${setCounter}, roleListHiddenId${counter}Set${setCounter}); return false">
                    <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="roleListImage${counter}Set${setCounter}" src="../images/redArrowRight.gif"/><c:out value="${capabilitySet.name}"/>
                  </fw:link>
                  <input name="roleListHiddenId<c:out value="${counter}"/>Set<c:out value="${setCounter}"/>" id="roleListHiddenId<c:out value="${counter}"/>Set<c:out value="${setCounter}"/>" type="hidden" value="false"/>
                </td>
								<td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
							</tr>
						    <%-- role - set - capabilities --%>
							<tr>
								<td colspan="1"><img alt=""  src="../images/spacer.gif" width="1" height="1" /></td>
								<td colspan="2">
								<div id="<c:out value="roleList${counter}Set${setCounter}"/>" class="expandCollapseBody">
								   <table>
								   <c:set var="rowColor" value="moduleValue"/>
								   <c:forEach var="capability" items="${capabilitySet.capabilities}" varStatus="status">
										<tr>
											<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
												&nbsp;
											</td>
											<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
												<c:out value="${capability.name}"/>
											</td>
											<td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
										</tr>
								   </c:forEach>
								   </table>
								</div>
								</td>
							</tr>
					   </c:forEach>
				       <c:forEach var="capability" items="${refRole.capabilities}" varStatus="status">
							<tr>
								<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
									&nbsp;
								</td>
								<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
									<c:out value="${capability.name}"/>
								</td>
								<td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
							</tr>
					   </c:forEach>
					   </table>
				    </div>
					</td>
				</tr>
			</c:forEach>
			<%-- Available CapabilitySets --%>
			<c:forEach var="capabilitySet" items="${userProfileForm.capabilitySetNameList}" varStatus="status">
				<c:set var="counter" value="${status.count - 1}" />
				<c:set var="setid" value="${userProfileForm.capabilitySetIdList[counter]}"/>
				<c:set var="refCapabilitySet" value="${REF_CAPABILITY_SETS[setid]}"/>
				<c:set var="active" value="${refCapabilitySet.assignable}"/>
				<tr>
					<td class="moduleValue" style="padding:5 5 5 5">						
						<html-el:checkbox title="${selectLabel} ${refCapabilitySet.name}" property="capabilitySetInd[${counter}]" disabled="${not active}" styleId="capabilitySetInd${counter}"/>
						<html-el:hidden property="capabilitySetId[${counter}]" />
					</td>
					<td class="moduleValue" style="padding:5 5 5 5"><html-el:img alt="${capabilitySetText}"  src="../images/capabilitySet.gif"/></td>
          <td nowrap style="text-align: left;padding:5 5 5 5" class="moduleLabel">
            <fw:link href="." onclick="expandOrCollapse(capSetList${counter}, capSetListImage${counter}, capSetListHiddenId${counter}); return false">
              <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="capSetListImage${counter}" src="../images/redArrowRight.gif"/>
              <fw:label property="capabilitySetInd[${counter}]" forId="capabilitySetInd${counter}"><c:out value="${refCapabilitySet.name}"/></fw:label>
            </fw:link>
            <input name="capSetListHiddenId<c:out value="${counter}"/>" id="capSetListHiddenId<c:out value="${counter}"/>" type="hidden" value="false"/>
          </td>
					<td class="moduleValue" style="padding:5 5 5 5">
						<html-el:hidden property="capabilitySetActiveDate[${counter}]" />
						<c:out value="${userProfileForm.capabilitySetActiveDateList[counter]}"/>
					</td>
					<td class="moduleValue" style="padding:5 5 5 5">
						<html-el:hidden property="capabilitySetInactiveDate[${counter}]" />
						<c:out value="${userProfileForm.capabilitySetInactiveDateList[counter]}"/>
					</td>
				</tr>
			    <tr>
					<td colspan="2"><img alt=""  src="../images/spacer.gif" width="1" height="1" /></td>
					<td colspan="3">
				    <div id="<c:out value="capSetList${counter}"/>" class="expandCollapseBody">
					   <table>
					   <c:set var="rowColor" value="moduleValue"/>
					   <c:forEach var="capability" items="${refCapabilitySet.capabilities}" varStatus="status">
							<tr>
								<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
									&nbsp;
								</td>
								<td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
									<c:out value="${capability.name}"/>
								</td>
								<td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
							</tr>
					   </c:forEach>
					   </table>
				    </div>
					</td>
				</tr>
			</c:forEach>
			<%-- Available Capabilities --%>
			<c:forEach var="capability" items="${userProfileForm.capabilityNameList}" varStatus="status">
				<c:set var="counter" value="${status.count - 1}" />
				<tr>
					<td class="moduleValue" style="padding:5 5 5 5">						
						<html-el:checkbox title="${selectLabel} ${userProfileForm.capabilityNameList[counter]}" property="capabilityInd[${counter}]" styleId="capabilityInd${counter}"/>
						<html-el:hidden property="capabilityCode[${counter}]" />
					</td>
					<td class="moduleValue" style="padding:5 5 5 5; horizontal-align:center"><html-el:img alt="${capabilityText}"  src="../images/capability.gif"/></td>
					<td class="moduleValue" style="padding:5 5 5 5">
						<html-el:hidden property="capabilityName[${counter}]" />
						<fw:label property="capabilityName[${counter}]" forId="capabilityInd${counter}">
						<c:out value="${userProfileForm.capabilityNameList[counter]}"/>
						</fw:label>
					</td>
					<td class="moduleValue" style="padding:5 5 5 5">	
					    <fw:label property="capabilityActiveDate[${counter}]" forId="capabilityActiveDate${counter}"><span style="display:none">capabilityActiveDate</span></fw:label>					    				    
						<html-el:text title="${activeDateLabel} for ${userProfileForm.capabilityNameList[counter]}"  property="capabilityActiveDate[${counter}]" size="12" maxlength="10" styleId="capabilityActiveDate${counter}"/>
					</td>
					<td class="moduleValue" style="padding:5 5 5 5">	
					    <fw:label property="capabilityInactiveDate[${counter}]" forId="capabilityInactiveDate${counter}"><span style="display:none">capabilityInactiveDate</span></fw:label>					    				    
						<html-el:text  title="${inactiveDateLabel} for ${userProfileForm.capabilityNameList[counter]}" property="capabilityInactiveDate[${counter}]" size="12" maxlength="10" styleId="capabilityInactiveDate${counter}" />
					</td>
				</tr>
			</c:forEach>
			<tr>
			  <td colspan="2" height="25"></td>
			</tr>
		  </table>
		</td></tr>
	</c:if>
		<%-- Button Row table --%>
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody">
              <tr>
				<c:choose>
					<c:when test="${readOnlyUser == true}">
						<td width="48%"><img alt=""  src="../images/spacer.gif"/></td>
						<td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
						<td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.cancel"/></html-el:submit></td>
						<td><img alt=""  src="../images/buttonEndRight.gif"/></td>
						<td width="48%"><img alt=""  src="../images/spacer.gif"/></td>
					</c:when>
					<c:otherwise>
                		<td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
						<td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
						<td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.update"/></html-el:submit></td>
						<td><img alt=""  src="../images/buttonEndRight.gif"/></td>
						<td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
						<td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
						<td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.clear"/></html-el:submit></td>
						<td><img alt=""  src="../images/buttonEndRight.gif"/></td>
						<td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
						<td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
						<td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.cancel"/></html-el:submit></td>
						<td><img alt=""  src="../images/buttonEndRight.gif"/></td>
						<td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
					</c:otherwise>
				</c:choose>
              </tr>
			  <tr><td height="25"></td></tr>
            </table>
          </td>
        </tr>
   </table>
  </td>
 </tr>
</html-el:form>
</table>
