/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.vitria;

import java.io.Serializable;

/**
 * Constants created on Sep 27, 2006
 * @author DNS   LEV
 */
public interface MockVitriaConstants extends Serializable {

   // Message properties
   public static final String MESSAGE_ID = "Message_Id";
   public static final String MESSAGE_TYPE = "Message_Type";
   public static final String SENDING_APPLICATION = "Sending_Application";
   public static final String SENDING_SITE = "Sending_Site";
   
   // Pre-defined keys in config.properties file
   public static final String RECEIVER_MODE = "receiverMode";
   public static final String JNDI_CTX_KEY = "jndiContext";
   public static final String INBOUND_FACTORY_KEY = "inbound.factory";
   public static final String OUTBOUND_FACTORY_KEY = "outbound.factory";
   public static final String SERVER_URL_KEY = "ServerURL";
   public static final String INBOUND_URL_KEY = "InboundServerURL";
   public static final String OUTBOUND_URL_KEY = "OutboundServerURL";
   public static final String OUTBOUNDDIRETCORYKEY = "outBoundMessageDirectory";
   public static String INBOUNDMESSAGEDIRECTORY = "inBoundMessageDirectory";
   public static String REPEAT_COUNT_KEY = "repeatCount";
   public static String DELETE_FILE_KEY = "deleteFile";
   public static String WRITE_FILE_KEY = "writeFile";
   public static String WRITE_LOG_KEY = "writeLog";
   public static String VALIDATE_MSGS_KEY = "validateMessages";
   public static String JNDI_QUEUE_SUFFIX_KEY = "queue.jndiSuffix";
   
   /************ Inbound Queues ***************/
   public static final String INBOUND_DATA_QUEUE_JNDI = "Edb.jms.queue.DistributedInboundDataQueue";
   public static final String INBOUND_QUERY_QUEUE_JNDI = "Edb.jms.queue.DistributedInboundQueryQueue";
   public static final String INBOUND_SOLICITED_QUEUE_JNDI = "Edb.jms.queue.DistributedInboundSolicitedQueue";
   public static final String INBOUND_ACK_QUEUE_JNDI = "Edb.jms.queue.DistributedInboundAckQueue";
   public static final String[] INBOUND_QUEUES_JNDI = new String[] {
	   INBOUND_DATA_QUEUE_JNDI,
	   INBOUND_QUERY_QUEUE_JNDI,
	   INBOUND_SOLICITED_QUEUE_JNDI,
	   INBOUND_ACK_QUEUE_JNDI
   };
      
   /************ Outbound Queues ***************/
   public static final String OUTBOUND_DATA_QUEUE_JNDI = "Edb.jms.queue.OutboundDataQueue";
   public static final String OUTBOUND_QUERY_QUEUE_JNDI = "Edb.jms.queue.OutboundQueryQueue";
   public static final String OUTBOUND_SOLICITED_QUEUE_JNDI = "Edb.jms.queue.OutboundSolicitedQueue";
   public static final String OUTBOUND_ACK_QUEUE_JNDI = "Edb.jms.queue.OutboundAckQueue";
   public static final String[] OUTBOUND_QUEUES_JNDI = new String[] {
	   OUTBOUND_DATA_QUEUE_JNDI,
	   OUTBOUND_QUERY_QUEUE_JNDI,
	   OUTBOUND_SOLICITED_QUEUE_JNDI,
	   OUTBOUND_ACK_QUEUE_JNDI
   };
}
