/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.messaging.util;

// Java classes
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;

// Library classes
import junit.framework.TestCase;

// Framework classes
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.hl7.segment.MSA;

// ESR classes

/**
 * 
 *
 * Project: Messaging</br>
 * Created on: 4:54:27 PM </br>
 *
 * @author DNS   LEV
 */
public class MessageGeneratorTest extends TestCase {

	private static final String MSG_OUTPUT_DIR_PARAM = "output.dir"; 
	private static final String MSG_INPUT_DIR_PARAM = "input.dir"; 
	private static final String MSG_CONTROL_ID_PARAM = "msg.id"; 

	public MessageGeneratorTest(String testName) {
		super(testName);
	}
	
	public void testGenerateORUZ11() throws Exception {
		
	}
	public void testGenerateORUZ07() throws Exception {
		
	}
	public void testGenerateORFZ11() throws Exception {
      
		String input_dir = System.getProperty( MSG_INPUT_DIR_PARAM );
		String output_dir = System.getProperty( MSG_OUTPUT_DIR_PARAM );
		String msg_id = System.getProperty( MSG_CONTROL_ID_PARAM );

		File out = new File( output_dir );
      if( !out.exists() ) {
      	out.mkdirs();
      }
      else {
      	out.delete();
      	out.mkdirs();
      }

      File in = new File( input_dir );
		
      File[] listOfFiles = in.listFiles();

      for (int i = 0; i < listOfFiles.length; i++) {
      	
      	File file = listOfFiles[i];
         System.out.println( "Processing: "  + file.getPath() );
         
         // Create a message
         Message msg = new Message( buildMessage(file) );
         MSA msaSegment = (MSA) msg.getSegment(SegmentConstants.MSA);
         msaSegment.setMessageControlID( msg_id );
         
         writeToFile( out.getPath(), msg.getMessageData(), file.getName() );
      }
      System.out.println("Completed");
	}

   private String buildMessage(File file) throws Exception {

      StringBuffer message = new StringBuffer();
      FileInputStream stream = new FileInputStream(file);

      BufferedReader reader = new BufferedReader(new InputStreamReader(stream));

      String input = null;
      do {
         input = reader.readLine();
         if (input != null) {
            message.append(input).append("\n");
         }
      }
      while (input != null);
      reader.close();
      stream.close();
      return message.toString();
   }
   
   public void writeToFile( String outDirName, String messageText, String filename ) throws Exception {

   	String output_file = outDirName + "\\" + filename;
      System.out.println( "Generating: " + output_file );
   	FileWriter fw = new FileWriter( output_file );
   	fw.write( messageText );
   	fw.flush();
   	fw.close();
   }
}