/********************************************************************
 * Copyright  2007 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.messaging.util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.test.AbstractSpringContextTests;
import gov.va.med.fw.util.CheckSerialVersionUtil;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.SystemUtils;

/**
 
 * Created Apr 18, 2007 3:58:18 PM
 * 
 * @author Venky Kullampalle
 */
public class CheckSerialVersionTest extends AbstractSpringContextTests {
   
    public static final String EDB_PROJECT_HOME="EDB_PROJECT_HOME";
    public static final String DEFAULT_EDB_PROJECT_HOME="D:\\bea\\projects\\ESR.3.0.0\\VK_HECMS_Code_rc\\vobs";
    
    
    public static final String MESSAGING_PROJECT_NAME="HECMS_messaging";
    
  
    public static final String CLASSES_DIR="cls";
    
    public String getProjectRootDirectory()
    {
        String projectRoot=System.getProperty(EDB_PROJECT_HOME);
        projectRoot=StringUtils.isEmpty(projectRoot)? DEFAULT_EDB_PROJECT_HOME:projectRoot;
        return projectRoot;
    }
    /**
     * Standard test entry point
     * @throws Exception
     */
    public final void testSerialVersion() throws Exception {        
       
        List missingSerList=new ArrayList();
        List errorList=new ArrayList();
      
       
       Map messagingMap= CheckSerialVersionUtil.checkSerialVersionUID(getProjectRootDirectory()+SystemUtils.FILE_SEPARATOR+
               MESSAGING_PROJECT_NAME+SystemUtils.FILE_SEPARATOR+CLASSES_DIR);
       addItems(messagingMap,missingSerList,errorList);       
          
       
       if(!errorList.isEmpty())
       {
           System.out.println("CheckSerialVersionUtil is unable to load following classes:"+errorList);
       }
       if(!missingSerList.isEmpty())
       {
           System.out.println("Serial Version UID is missing in these files:"+missingSerList);
           throw new Exception ("Serial Version UID is Missing in these files:" + missingSerList);
       }
       
      
    } 
    
    private void addItems(Map map, List missingSerList, List errorList)
    {
        if(map==null)
            return;
        if(map.containsKey(CheckSerialVersionUtil.MISSING_SER_LIST))
            missingSerList.addAll((List)map.get(CheckSerialVersionUtil.MISSING_SER_LIST));
        if(map.containsKey(CheckSerialVersionUtil.ERROR_LIST))
            errorList.addAll((List)map.get(CheckSerialVersionUtil.ERROR_LIST));             
    }
}
