/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.util;

// Java classes
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Set;
import java.util.Iterator;

import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.persistent.person.PersonDAO;
import gov.va.med.esr.common.util.AbstractCommonTestCase;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.messaging.constants.HL7Constants;
import gov.va.med.fw.hl7.BatchMessage;
import gov.va.med.fw.hl7.Message;

/**
 * 
 * @author Vu Le
 * @version 1.0
 */
public abstract class AbstractMessagingTest extends AbstractCommonTestCase {
    //path in  messaging.jar
	protected static final String MESSAGING_CONTEXT = "messaging/applicationContext.xml"; 

	//path in  test_resource.jar
	protected static final String DEFAULT_TEST_CONTEXT = "messaging/test_components.xml"; 
	
	/*
	 * ******************  Query messages ********************
	 */
	protected static final String QRYZ10_VISTA_TO_HEC_FILE = "QRYZ10 Vista to HEC.txt";

	protected static final String QRYZ10_TYPE = "QRYZ10"; 

	protected static final String QRYZ11_FILE = "QRYZ11.txt";

	protected static final String QRYZ11_VISTA_TO_HEC_FILE = "QRYZ11 Vista to HEC.txt";

	protected static final String QRYZ11_TYPE = "QRYZ11"; 

	/*
	 * ******************  Unsolicitated messages ********************
	 */
 	protected static final String ORUZ05_FILE = "ORUZ05.txt";
	
	protected static final String ORUZ05_TYPE = "ORUZ05";
	
	protected static final String ORUZ07_FILE = "ORUZ07.txt";

	protected static final String ORUZ07_TYPE = "ORUZ07"; 
 
	protected static final String ORUZ11_FILE = "ORUZ11.txt";

	protected static final String ORUZ11_TYPE = "ORUZ11";

	protected static final String ORUZ12_FILE = "ORUZ12.txt";

	protected static final String ORUZ12_TYPE = "ORUZ12";

	protected static final String ORUZ13_FILE = "ORUZ13.txt";

	protected static final String ORUZ13_TYPE = "ORUZ13";
	
	/*
	 * ******************  Solicitated messages ********************
	 */
	protected static final String ORFZ07_FILE = "ORFZ07.txt"; 

	protected static final String ORFZ07_TYPE = "ORFZ07";
	
	protected static final String ORFZ10_FILE = "ORFZ10.txt"; 
	
	protected static final String ORFZ10_TYPE = "ORFZ10";
	 
	protected static final String ORFZ11_FILE = "ORFZ11.txt"; 

	protected static final String ORFZ11_PATIENT_SENSITIVITY_FILE = "ORFZ11_Patient_Sensitivity.txt";

	protected static final String ORFZ11_TYPE = "ORFZ11";

	/*
	 * ******************  Ack messages ********************
	 */
	protected static final String ACK_AA_FILE = "ACK-AA.txt";

	protected static final String ACK_AE_FILE = "ACK-AE.txt"; 
	
	protected static final String MFK_ZEG_FILE = "MFK.txt"; 

	protected PersonDAO personDao = null;


	// #####################################
	// ### below are used for test drivers in Messaging
	// #####################################
	// allows subclasses to not have to name testcases
	public AbstractMessagingTest() {
		super(new String[] { MESSAGING_CONTEXT, DEFAULT_TEST_CONTEXT });
	}

	// preserved for old code
	public AbstractMessagingTest(String testName) {
		super(testName,
				new String[] { MESSAGING_CONTEXT, DEFAULT_TEST_CONTEXT });
	}

	protected Message createORUZ07Message() throws Exception {
		return new BatchMessage(createTestMessageFromFile(ORUZ07_FILE),
				HL7Constants.ORUZ07);
	}
	
	protected Message createORUZ05Message() throws Exception {
		return new BatchMessage(createTestMessageFromFile(ORUZ05_FILE),
				HL7Constants.ORUZ05);
	}	

	protected Message createORUZ11Message() throws Exception {
		return new BatchMessage(createTestMessageFromFile(ORUZ11_FILE),
				HL7Constants.ORUZ11);
	}
 
	protected Message createQRYZ10Message() throws Exception {
		return new Message(createTestMessageFromFile(QRYZ10_VISTA_TO_HEC_FILE),
				HL7Constants.QRYZ10);
	}
	
	protected Message createQRYZ11Message() throws Exception {
		return new Message(createTestMessageFromFile(QRYZ11_FILE),
				HL7Constants.QRYZ11);
	}

	protected Message createORFZ11Message() throws Exception {
		return new Message(createTestMessageFromFile(ORFZ11_FILE),
				HL7Constants.ORFZ11);
	}

	protected Message createACKAAMessage() throws Exception {
		return new BatchMessage(createTestMessageFromFile(ACK_AA_FILE),
				HL7Constants.ACK);
	}

	protected Message createACKAEMessage() throws Exception {
		return new BatchMessage(createTestMessageFromFile(ACK_AE_FILE),
				HL7Constants.ACK);
	}

	protected String createTestMessageFromFile(String fileName) {
		StringBuffer content = new StringBuffer();
		try {
			InputStreamReader input = new InputStreamReader(
					new BufferedInputStream(ClassLoader
							.getSystemResourceAsStream(fileName)));
			BufferedReader in = new BufferedReader(input);
			String data = null;
			while ((data = in.readLine()) != null) {
				content.append(data).append("\n");
			}
		} catch (Exception e) {

		}
		return content.toString();
	}

	protected Person persistMessagingPerson(String familyName) throws Exception {
		Person p = createMessagingPerson(familyName);
		personDao.saveObject(p);
		return p;
	}

	/**
	 * Create a new Person in memory
	 * 
	 * @return
	 */
	protected Person createMessagingPerson(String familyName) throws Exception {
		Person p = buildSimplePerson();

		Set s = p.getSsns();
		if (s != null) {
			Iterator itr = s.iterator();
			while (itr.hasNext()) {
				SSN ssn = (SSN) itr.next();
				if (ssn.getType().getCode().equals("Official")) {
					ssn.setSsnText("123456789");
					break;
				}
			}
		}

		Name name = new Name();
		name
				.setFamilyName((familyName + new Date().getTime()).substring(0,
						30)); // truncate just in case
		name.setGivenName("GivenNameMessaging");
		NameType nameType = getLookupService().getNameTypeByCode("L");
		
		name.setType(nameType);
		p.addName(name);
		BirthRecord birth = new BirthRecord();
		birth.setBirthDate(new ImpreciseDate("20050101"));
		p.setBirthRecord(birth);
		return p;
	}

	/**
	 * @return Returns the personDao.
	 */
	public PersonDAO getPersonDao() {
		return personDao;
	}

	/**
	 * @param personDao
	 *            The personDao to set.
	 */
	public void setPersonDao(PersonDAO personDao) {
		this.personDao = personDao;
	} 
	
    public SiteIdentity createSiteIdentity(Person person) throws Exception
    {
        SiteIdentity si = new SiteIdentity();

        si.setPerson(person);
        VAFacility facility = getLookupService().getVaFacilityByStationNumber(
                VAFacility.CODE_HEC.getName());
        si.setVaFacility(facility);
        return si;
    }	
    
}