package gov.va.med.esr.messaging.service.outbound;

import gov.va.med.esr.common.model.lookup.AckType;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;
import gov.va.med.fw.hl7.Message;
/**
 * 
 * @author Rajiv Patnaik
 * Created on Jul 16, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class SolicitatedACKAEProcessServiceTest extends AbstractMessagingTest
{
    /**
     * Test of testProcessMessage method, of class gov.va.med.esr.messaging.service.outbound.ACKAEProcessService.
     */
    public void testProcessSolicitatedAEMessage() throws Exception {
    	logger.info("testProcessMessage");
    	

    	MessageType messageType = null;
	    MessageStatus messageStatus = null;
	    VAFacility facility = null;
	    
    	//Create Message object
	    Message msg = super.createQRYZ10Message();
    	
    	//Create Message Log object
 	    facility = getLookupService().getVaFacilityByCode("655");
    	messageType = getLookupService().getMessageTypeByCode("QRYZ10-E");
    	messageStatus = getLookupService().getMessageStatusByCode(MessageStatus.COMPLETE);
    		
    	MessageLogEntry log = new MessageLogEntry();
    	log.setType(messageType);
    	log.setStatus(messageStatus);
    	log.setVaFacility(facility);
    	log.setBody(msg.getMessageData());
    	
    	log.setAckType(getLookupService().getAckTypeByCode(AckType.CODE_AE));
    	log.setErrorText("Error Description");
    	log.setControlIdentifier("60513942247-1");
    	
    	//Test ORFZ10 AE message
    	OutboundProcessService service = (OutboundProcessService)applicationContext.getBean("outbound.orfz10AckAEProcessService");  	
    	//service.processMessage(new Object[] {msg, log});
    	
    	//Test ORFZ11 AE message
    	msg = super.createQRYZ11Message();
    	messageType = getLookupService().getMessageTypeByCode("QRYZ11-E");
    	service = (OutboundProcessService)applicationContext.getBean("outbound.orfz11AckAEProcessService");  	
    	service.processMessage(new Object[] {msg, log});

    }
}    


