package gov.va.med.esr.messaging.service.outbound;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.persistent.person.PersonDAO;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;

/**
 * 
 * @author Rajiv Patnaik Created on Oct 20, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class QRYZ07ProcessServiceTest extends AbstractMessagingTest
{

    private PersonDAO personDAO = null;

    public QRYZ07ProcessServiceTest(String name)
    {
        super(name);
    }

    public void testProcessMessage() throws Exception
    {
        logger.info("testProcessMessage");

        Person person = getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey("71964"));

        // Create the trigger event
        IncomeYearTriggerEvent incomeEvent = new IncomeYearTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VISTA,
                PersonTrigger.DispatchType.QUERY,
                PersonTrigger.DataType.FULL_DATA);

        incomeEvent.setIncomeYear(new Integer(2005));
        incomeEvent.setPersonId(person.getPersonEntityKey());

        Set sites = new HashSet();
        VAFacility facility = getLookupService().getVaFacilityByStationNumber(
                VAFacility.CODE_HEC.getName());
        sites.add(facility);
        incomeEvent.setTargetSites(sites);

        SiteIdentity siteIdentity = createSiteIdentity(person);

        OutboundMessageService service = (OutboundMessageService) applicationContext.getBean("outbound.qryz07ProcessService");

        service
                .processMessage(person, siteIdentity,
                        incomeEvent);
        this.setComplete();
    }
    
    
    /*
     * PersonTriggerEvent event = new
     * PersonTriggerEvent(PersonTrigger.DestinationType.MESSAGING,
     * PersonTrigger.TargetType.VBA, PersonTrigger.DispatchType.QUERY,
     * PersonTrigger.DataType.ELIGIBILITY);
     * event.setPersonId(onFile.getPersonEntityKey());
     * triggerRouter.processTriggerEvent(event);
     */
    
    
    
    

    public void testORUZ11FailedConsistencyChk() throws Exception
    {
    		
        logger.info("testORUZ11FailedConsistencyChk");

        Person person = getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey("375263596"));
        // Create the trigger event
        PersonTriggerEvent trigger = new PersonTriggerEvent(PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VISTA, PersonTrigger.DispatchType.NOTIFY,
                PersonTrigger.DataType.ELIGIBILITY);

        trigger.setPersonId(person.getPersonEntityKey());

        SiteIdentity siteIdentity = createSiteIdentity(person);

        OutboundMessageService service = (OutboundMessageService) applicationContext.getBean("outbound.oruz11ProcessService");

        service.processMessage(person, siteIdentity, trigger);
        this.setComplete();
    }
}