/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.service.outbound;

//Java Classes
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

//ESR Classes
import gov.va.med.esr.messaging.util.AbstractMessagingTest;
import gov.va.med.esr.service.trigger.FilterSitesPersonTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.esr.service.trigger.TargetedPersonTriggerEvent;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.persistent.person.PersonDAO;

/**
 * @author Alex Yoon
 * @version 1.0
 */
public class OutboundMessageVistaAdaptorTest extends AbstractMessagingTest {
	private PersonDAO personDAO = null;
	private Person person = null;
	private OutboundProcessService adaptor = null;
		 
    public OutboundMessageVistaAdaptorTest(String name) {
		super(name);
	}
    
    protected void customSetUp() throws Exception {
        personDAO = (PersonDAO)applicationContext.getBean("personDAO");
        person = (Person)personDAO.getByKey(new PersonIdEntityKeyImpl(new BigDecimal(22398)));
        adaptor = (OutboundProcessService)applicationContext.getBean("outbound.outboundMessageVistaAdaptor");
    }

    public void testProcessMessageORUZ04() throws Exception {
	    logger.info("testProcessMessageORUZ04");
	    
	    String messageType = "ORUZ04";
    	adaptor.processMessage(new Object[] {person,  messageType});
		
		this.setComplete();
	}
//    
//    
//    public void testProcessMessageORUZ10() throws Exception {
//	    logger.info("testProcessMessageORUZ10");
//	    
//	    String messageType = "ORUZ10";
//    	adaptor.processMessage(new Object[] {person,  messageType});
//		
//		this.setComplete();
//	}
//    
//    public void testProcessMessageORUZ11() throws Exception {
//	    logger.info("testProcessMessageORUZ11");
//	    
//	    String messageType = "ORUZ11";
//    	adaptor.processMessage(new Object[] {person,  messageType});
//		
//		this.setComplete();
//	} 
    
    public void testProcessMessageORUZ05() throws Exception
    {
        String messageType = "ORUZ05";
        
        Person person = getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey("373971922"));

        VAFacility facility = getLookupService().getVaFacilityByStationNumber("724");

        Address address = Address.getAddressOfType(person.getAddresses(),
                AddressType.CODE_PERMANENT_ADDRESS.getCode());

        Map updatedEntityAndSiteKeys = new HashMap();
        updatedEntityAndSiteKeys.put(address.getEntityKey(), facility);
        
        //Test for Address info
        FilterSitesPersonTriggerEvent triggerEvent = new FilterSitesPersonTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VISTA, PersonTrigger.DispatchType.NOTIFY,
                PersonTrigger.DataType.ADDRESS);
        triggerEvent.setPersonId(person.getPersonEntityKey());
        triggerEvent.setEntityKeysAndSites(updatedEntityAndSiteKeys);
        
        
        adaptor.processMessage(new Object[] { person, messageType,
                triggerEvent }); 
//        
//        //Test Date Of Death
//        TargetedPersonTriggerEvent dodTriggerEvent = new TargetedPersonTriggerEvent(
//                PersonTrigger.DestinationType.MESSAGING,
//                PersonTrigger.TargetType.VISTA,
//                PersonTrigger.DispatchType.NOTIFY,
//                PersonTrigger.DataType.DATE_OF_DEATH);
//
//        Set sites = new HashSet();
//        sites.add(facility);
//        dodTriggerEvent.setPersonId(person.getPersonEntityKey());
//        dodTriggerEvent.setFilterSites(sites);        
//        adaptor.processMessage(new Object[] { person, messageType,
//                dodTriggerEvent }); 
//        
//        PersonTriggerEvent dodPersontriggerEvent = new PersonTriggerEvent(PersonTrigger.DestinationType.MESSAGING,
//                PersonTrigger.TargetType.VISTA, PersonTrigger.DispatchType.NOTIFY,
//                PersonTrigger.DataType.DATE_OF_DEATH);
//        adaptor.processMessage(new Object[] { person, messageType,
//        		dodPersontriggerEvent }); 

    }       
}