/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.service.outbound;

//Java Classes
import java.math.BigDecimal;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.persistent.person.PersonDAO;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;

/**
 * @author Alex Yoon
 * @version 1.0
 */
public class OutboundMessageVbaAdaptorTest extends AbstractMessagingTest {
	private PersonDAO personDAO = null;
		 
    public OutboundMessageVbaAdaptorTest(String name) {
		super(name);
	}

    public void testProcessMessage() throws Exception {
	    logger.info("testProcessMessage");
	    
	    personDAO = (PersonDAO)applicationContext.getBean("personDAO");
    	Person person = (Person)personDAO.getByKey(new PersonIdEntityKeyImpl(new BigDecimal(707691)));
    	String messageType = "QRYZ11";
    	
		OutboundProcessService adaptor = (OutboundProcessService)applicationContext.getBean("outbound.outboundMessageVbaAdaptor");
		
		adaptor.processMessage(new Object[] {person,  messageType});
		
		this.setComplete();
	}
}