// Created May 4, 2005 2:44:13 PM

/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

/**
 * This is a comment for new java file.
 */
package gov.va.med.esr.messaging.service.outbound;

import gov.va.med.fw.service.trigger.TriggerableService;
import gov.va.med.fw.util.InvalidConfigurationException;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;
import gov.va.med.esr.service.trigger.CommonTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;

/**
 * Initial javadoc for class MessagingRouterTest.
 * TODO - Add content here
 * 
 * @author DNS   BOHMEG
 */
public class MessagingRouterTest extends AbstractMessagingTest {
	private CommonTriggerEvent configuredEvent;
	private PersonTriggerEvent notConfiguredEvent;
	
	protected void customSetUp() throws Exception {
		super.customSetUp();
		Person person = persistMessagingPerson("QueryMessagingRouterTest");

		configuredEvent =  new PersonTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING,
				PersonTrigger.TargetType.VBA,
				PersonTrigger.DispatchType.QUERY,
				PersonTrigger.DataType.ELIGIBILITY);
		((PersonTriggerEvent) configuredEvent).setPersonId(person.getPersonEntityKey()); 
		((PersonTriggerEvent) configuredEvent).setIdentityTraits(person.getIdentityTraits());
		
		person = persistMessagingPerson("NotifyMessagingRouterTest");
		notConfiguredEvent =  new PersonTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING,
				PersonTrigger.TargetType.VBA,
				PersonTrigger.DispatchType.NOTIFY,
				PersonTrigger.DataType.ELIGIBILITY);
		notConfiguredEvent.setPersonId(person.getPersonEntityKey());
	}

	/** Test routing of messages that have already been published (Messaging side of fence) */
	public void testPersonTriggerEvents() throws Exception {
		TriggerableService router = (TriggerableService) applicationContext.getBean("messaging.mockTriggerRouter");
		router.trigger(configuredEvent);
		try {
			router.trigger(notConfiguredEvent);
		} catch(InvalidConfigurationException e) {
			/* expected */
		}
	}	
}
