/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.service.outbound;

//Java Classes
import java.util.Calendar;

import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.lookup.EGTSettingType;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;

/**
 * @author Alex Yoon
 * @version 1.0
 */
public class MFNZEGProcessServiceTest extends AbstractMessagingTest
{

    public MFNZEGProcessServiceTest(String name)
    {
        super(name);
    }

    public void testProcessMessage() throws Exception
    {
        logger.info("testProcessMessage");

        //Create EGTSetting object
        EGTSetting egt = new EGTSetting();
        egt.setEffectiveDate(Calendar.getInstance().getTime());
        egt.setComments("Test Comments");
        egt.setFederalRegisterDate(Calendar.getInstance().getTime());
        egt.setPriorityGroup(getLookupService()
                .getEnrollmentPriorityGroupByCode(
                        EnrollmentPriorityGroup.GROUP_3.getName()));
        egt.setPrioritySubGroup(getLookupService()
                .getEnrollmentPrioritySubGroupByCode(
                        EnrollmentPrioritySubGroup.SUBGROUP_C.getName()));
        egt.setType(getLookupService().getEgtSettingTypeByCode(
                EGTSettingType.CODE_ENROLLMENT_DECISION.getName()));

        //Create VAFacility object
        VAFacility site = getLookupService().getVaFacilityByCode(
                VAFacility.CODE_HEC.getName());

        OutboundMessageMasterFileService service = (OutboundMessageMasterFileService) applicationContext.getBean("outbound.mfnzegProcessService");

        service.processMessage(egt, site);

        this.setComplete();
    }
}