// Package 
package gov.va.med.esr.messaging.service.outbound;

// Java Classes
import java.util.Calendar;

// ESR Classes
import gov.va.med.esr.messaging.util.AbstractMessagingTest;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EGTSettingType;
import gov.va.med.esr.service.trigger.EGTTriggerEvent;

/**
 * @author Andrew Pach
 * @version 3.0
 */
public class MFNZEGProcessAdaptorTest extends AbstractMessagingTest
{
    public MFNZEGProcessAdaptorTest(String name)
    {
        super(name);
    }

    public void testProcessMessage() throws Exception
    {
        logger.info("MFNZEGProcessAdaptorTest");

        // Create test EGTSetting Object
        EGTSetting egt = new EGTSetting();
        egt.setEffectiveDate(Calendar.getInstance().getTime());
        egt.setComments("Test Comments");
        egt.setFederalRegisterDate(Calendar.getInstance().getTime());
        egt.setPriorityGroup(getLookupService().getEnrollmentPriorityGroupByCode(
            EnrollmentPriorityGroup.GROUP_3.getName()));
        egt.setPrioritySubGroup(getLookupService().getEnrollmentPrioritySubGroupByCode(
            EnrollmentPrioritySubGroup.SUBGROUP_C.getName()));
        egt.setType(getLookupService().getEgtSettingTypeByCode(
            EGTSettingType.CODE_ENROLLMENT_DECISION.getName()));

        // Create a trigger event from the EGTSetting
        EGTTriggerEvent triggerEvent = new EGTTriggerEvent(egt);

        // Get the adaptor
        OutboundMessageMasterFileAdaptor adaptor = (OutboundMessageMasterFileAdaptor)applicationContext.getBean("outbound.outboundMessageMasterFileAdaptor");

        // Process the message
        adaptor.processMessage(triggerEvent, "MFNZEG");

        // The test is complete
        this.setComplete();
    }
}
