/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.service.outbound;

//Java Classes
import java.util.ArrayList;
import java.util.List;

import gov.va.med.fw.hl7.Message;

import gov.va.med.esr.common.model.lookup.AckType;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.persistent.lookup.LookupsDAO;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;
//import gov.va.med.esr.messaging.event.ACKAEEvent;

/**
 * @author Alex Yoon
 * @version 1.0
 */
public class ACKAEProcessServiceTest extends AbstractMessagingTest {
    
    /**
     * Constructor for ACKAEProcessServiceTest.
     * 
     * @param testName
     */    
    public ACKAEProcessServiceTest(String testName) throws Exception {
        super(testName);
    }
    
    /**
     * Test of testProcessMessage method, of class gov.va.med.esr.messaging.service.outbound.ACKAEProcessService.
     */
    public void testProcessMessage() throws Exception {
    	logger.info("testProcessMessage");
    	
    	LookupsDAO  vaFacilityDAO = null;
        LookupsDAO messageStatusDAO = null;
        LookupsDAO messageTypeDAO = null;
    	MessageType mt = null;
	    MessageStatus ms = null;
	    VAFacility va = null;
	    
    	//Create Message object
	    Message msg = super.createORUZ07Message();
    	
    	//Create Message Log object
 	    va = getLookupService().getVaFacilityByCode("655");
    	mt = getLookupService().getMessageTypeByCode("ORUZ07-E");
    	ms = getLookupService().getMessageStatusByCode(MessageStatus.AWAITING_TRANSMISSION);
    		
    	MessageLogEntry log = new MessageLogEntry();
    	log.setType(mt);
    	log.setStatus(ms);
    	log.setVaFacility(va);
    	log.setBody(msg.getMessageData());
    	
    	log.setAckType(getLookupService().getAckTypeByCode(AckType.CODE_AE));
    	log.setErrorText("Error Description");
    	log.setControlIdentifier("60513942247-1");
    	
    	List errors = new ArrayList();
    	errors.add(log);
    	
    	OutboundProcessService service = (OutboundProcessService)applicationContext.getBean("outbound.ackAEProcessService");  	
    	service.processMessage(new Object[] {msg, errors});
    }
}