/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/

/*
 * Created on Sep 9, 2004
 *
 */
package gov.va.med.esr.messaging.service;

//ESR Classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonLockedReason;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;
import gov.va.med.esr.service.GenerateQRYZ11MessagingService;
import gov.va.med.esr.service.MessagingService;

/**
 * @author Carlos Ruiz
 * @version 1.0
 */
public class MessagingServiceTest extends AbstractMessagingTest {
    /**
	 * @param name
	 */
	public MessagingServiceTest(String name) {
		super(name);
	}
	
	public void testGenerateIdViaDAO() throws Exception {
		MessagingService ms = (MessagingService)applicationContext.getBean("messagingService");
    	String id = ms.generateControlIdentifier();
    	super.assertNotNull(id);
    	
	}
	
	public void testGenerateMessageForPendingTraitsClock() throws Exception {
		Person p = createMessagingPerson("testZ11PendingTraitsClockPerson");
		// setup test person, faking identifier
		p.setIdentifier(375289520);
		p.setPersonLockedReason(PersonLockedReason.PENDING_IDENTITY_TRAIT_UPDATES);
		
		GenerateQRYZ11MessagingService ms = (GenerateQRYZ11MessagingService)applicationContext.getBean("messagingService");
		ms.generateMessageForPendingTraitsClock(p);
		
	}
}

