/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.service;

import gov.va.med.esr.messaging.constants.HL7Constants;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;
import gov.va.med.fw.service.jms.MessageDrivenService;

import java.security.Identity;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;

import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;

import org.springframework.beans.factory.BeanFactory;

import weblogic.jms.common.TextMessageImpl;

public abstract class AbstractMDBServiceTest extends AbstractMessagingTest
{
    private TextMessageImpl message = null;
    private MessageDrivenService mdb = null;

    /**
     * Constructor for ORFZ11HL7MDBServiceTest.
     *
     * @param name
     */
    protected AbstractMDBServiceTest(String name)
    {
        super(name);
    }

    protected abstract String getMessageFileName();

    protected abstract String getMessageType();


    protected void customSetUp() throws Exception
    {
        String data = super.createTestMessageFromFile(getMessageFileName());

        this.message = new TextMessageImpl();
        this.message.setText(data);
        this.message.setStringProperty(HL7Constants.MESSAGE_TYPE, getMessageType());

        this.mdb = new MyMDB();
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void customTearDown() throws Exception
    {
        this.message = null;
        this.mdb = null;
    }

    private void executeOnMessage()
    {
        this.mdb.onMessage(this.message);
    }



    public void testOnMessage() throws Exception
    {
        mdb.ejbCreate();
        mdb.setMessageDrivenContext(new Context());

        executeOnMessage();
        setComplete();
    }

    private class Context
        implements MessageDrivenContext
    {
        public Context()
        {
            super();
        }

        public EJBHome getEJBHome()
        {
            return null;
        }

        public Map<String, Object> getContextData() {
        	return null;
        }

        public EJBLocalHome getEJBLocalHome()
        {
            return null;
        }

        public Properties getEnvironment()
        {
            return new Properties();
        }




        public Identity getCallerIdentity()
        {
            return null;
        }

        public Principal getCallerPrincipal()
        {
            return null;
        }




        public boolean isCallerInRole(Identity identity)
        {
            return true;
        }

        public boolean isCallerInRole(String role)
        {
            return true;
        }

        public UserTransaction getUserTransaction()
        {
            return null;
        }

        public boolean getRollbackOnly()
        {
            return false;
        }

        public void setRollbackOnly()
        {

        }




        public  TimerService getTimerService()
        throws IllegalStateException{return null;}

        public  Object lookup(String s){return null;}

    }

    private class MyMDB extends MessageDrivenService
    {
		/**
       * An instance of serialVersionUID
       */
      private static final long serialVersionUID = 971049545882295654L;

      public void ejbCreate() {
			// bypass the Spring loading of ApplicationContext since this JUnit already did it
			onEjbCreate();
		}

		protected BeanFactory getBeanFactory() {
			return applicationContext;  // loaded by this JUnit
		}

		public void setMessageDrivenContext(MessageDrivenContext ctx) {
			// bypass the usage of getEnvEntry
		}
    }
}