package gov.va.med.esr.messaging.parser;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;

/**
 * 
 * @author Rajiv Patnaik Created on Aug 5, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZTATestDataValidator extends BaseSegmentsTestDataValidator
        implements XMLSegmentTagNameConstants
{

    /**
     * @param document
     * @param person
     */
    public void validateZTA(Document document, Person person)
    {
        Address temporaryAddress = person.getTemporaryCorrespondenceAddress();
        NodeList pidNodes = document.getElementsByTagName(ZTA);

        for (int i = 0; i < pidNodes.getLength(); i++)
        {
            Element element = (Element) pidNodes.item(i);

            String startDateFromMsg = getElement(element,
                    XMLSegmentTagNameConstants.ZTA_3);
            String endDateFromMsg = getElement(element,
                    XMLSegmentTagNameConstants.ZTA_4);
            String addressLine1FromMsg = getSubElementData(element, ZTA_5, AD_1);
            String cityFromMsg = getSubElementData(element,ZTA_5, AD_3);
            String stateFromMsg = getSubElementData(element,ZTA_5, AD_4);
            String zipCodeFromMsg = getSubElementData(element,ZTA_5, AD_5);
            String countryFromMsg = getSubElementData(element,ZTA_5, AD_6);

            String countyFromMsg = getElement(element,
                    XMLSegmentTagNameConstants.ZTA_6);
            String phoneFromMsg = getElement(element,
                    XMLSegmentTagNameConstants.ZTA_7);
            
            //If any of the above fields is not empty/null, then a Address object
            //should have been built
            validateNotNull(cityFromMsg, temporaryAddress, "Temporary Address is null");
            
            //If temporaryAddress not built, no assertions
            if (temporaryAddress != null)
            {
                assertEquals("StreetR name is not equal ", addressLine1FromMsg, temporaryAddress
                        .getLine1());

                assertEquals("State is not equal ", stateFromMsg, temporaryAddress
                        .getState());

                assertEquals("Zip Code is not equal ", zipCodeFromMsg, temporaryAddress
                        .getZipCode()
                        + "-" + temporaryAddress.getZipPlus4());

                assertEquals("Country is not equal ", countryFromMsg, temporaryAddress
                        .getCountry());
            }
            
        }
    }

}