package gov.va.med.esr.messaging.parser;

import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.builder.message.DateFormatter;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.builder.BuilderException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * 
 * @author Rajiv Patnaik Created on Aug 9, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZSPTestDataValidator extends BaseSegmentsTestDataValidator
        implements XMLSegmentTagNameConstants
{
    /**
     * @throws Exception
     */
    public ZSPTestDataValidator() throws Exception
    {
        super();
        // TODO Auto-generated constructor stub
    }

    public void validateZSP(Document document, Person person, VAFacility sendingFacility) throws Exception
    {
        NodeList nodeList = document.getElementsByTagName(ZSP);
        //Only one ZSP node
        Element element = (Element) nodeList.item(0);

        validateData(person, element, sendingFacility);
    }

    private void validateData(Person person, Element element,
            VAFacility sendingFacility) throws BuilderException,
            ServiceException
    {
        String serviceConnectedFromMsg = getElement(element, ZSP_2);
        String serviceConnectedPercentFromMsg = getElement(element, ZSP_3);
        String periodOfServiceFromMsg = getElement(element, ZSP_4);
        //String vietnamIndicatedFromMsg = getElement(element, ZSP_5);Not used
        String permanAndTotalFromMsg = getElement(element, ZSP_6);
        String unemployableFromMsg = getElement(element, ZSP_7);
        String scAwardDateFromMsg = getElement(element, ZSP_8);
        String pandtEffectiveDateFromMsg = getElement(element, ZSP_10);

        ServiceConnectionAward scAward = person.getServiceConnectionAward();
        if (scAward != null)
        {
            //Service connected is always true if SC Award is not null.
            assertEquals("serviceConnected does not match",
                    buildBoolean(serviceConnectedFromMsg), Boolean.TRUE);

            String serviceConnectedPercent = scAward
                    .getServiceConnectedPercentage() != null ? scAward
                    .getServiceConnectedPercentage().toString() : null;
            assertEquals("serviceConnected does not match",
                    serviceConnectedPercentFromMsg, serviceConnectedPercent);

            assertEquals("PermanentAndTotal does not match",
                    buildBoolean(permanAndTotalFromMsg), scAward
                            .isPermanentAndTotal());

            assertEquals("isUnemployable does not match",
                    buildBoolean(unemployableFromMsg), scAward.isUnemployable());

            assertEquals("AwardDate does not match", scAwardDateFromMsg,
                    DateFormatter.formatDate(scAward.getAwardDate()));

            assertEquals("PermanentAndTotalEffectiveDate does not match",
                    pandtEffectiveDateFromMsg, DateFormatter.formatDate(scAward
                            .getPermanentAndTotalEffectiveDate()));
        }

        MilitaryService militaryService = person.getMilitaryService();

        if (militaryService != null)
        {
            //Get Service Period lookup code.
            MilitaryServiceSiteRecord militaryServiceSiteRecord = militaryService
                    .getMilitaryServiceSiteRecordsBySite(sendingFacility);

            String periodOfService = militaryServiceSiteRecord
                    .getServicePeriod().getCode();

            assertEquals("ServicePeriod code does not match",
                    periodOfServiceFromMsg, periodOfService);
        }
    }

}