package gov.va.med.esr.messaging.parser;

import java.util.Iterator;
import java.util.Set;

import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.lookup.Disability;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.builder.message.DateFormatter;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * 
 * @author Rajiv Patnaik Created on Aug 8, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZRDTestDataValidator extends BaseSegmentsTestDataValidator
        implements XMLSegmentTagNameConstants
{
 
    public void validateZRD(Document document, Person person)
    {
        NodeList zrdlNodes = document.getElementsByTagName(ZRD);
        ServiceConnectionAward scAward = person.getServiceConnectionAward();

        for (int i = 0; i < zrdlNodes.getLength(); i++)
        {
            Element element = (Element) zrdlNodes.item(i);

            //There could be multiple ZRD segments each having the same
            // disability code.
            //Becomes tricky to test which node matches which one in the BOM
            //Test the first segment. If that works, assume the rest should
            // work fine
            validateData(element, scAward);
            break;
        }
    }

    private void validateData(Element element, ServiceConnectionAward scAward)
    {
        String disabilityCodeFromMsg = getSubElementData(element, ZRD_2, CE_1);
        String disabilityDescFromMsg = getSubElementData(element, ZRD_2, CE_2);
        String disabilityPercentFromMsg = getElement(element, ZRD_3);
        //String serviceConnectedFromMsg = getElement(element, ZRD_4);
        String diagonisticExtremityFromMsg = getElement(element, ZRD_12);
        String ratedDisabilityOrigEffDateFromMsg = getElement(element, ZRD_13);
        String ratedDisabilityCurrEffDateFromMsg = getElement(element, ZRD_14);

        //String serviceConnected = null;

        if (scAward != null)
        {
            Set ratedDisabilities = scAward.getRatedDisabilities();

            if ((ratedDisabilities != null) && (ratedDisabilities.size() > 0))
            {
                Iterator iterRatedDisabilities = ratedDisabilities.iterator();
                while (iterRatedDisabilities.hasNext())
                {
                    RatedDisability ratedDisability = (RatedDisability) iterRatedDisabilities
                            .next();
                    if (ratedDisability != null)
                    {
                        //Get Disability object.
                        Disability disability = ratedDisability.getDisability();
                        if (disability != null)
                        {
                            //Compare the disability code to the one from msg.
                            if (disability.getCode().equals(
                                    disabilityCodeFromMsg))
                            {
                                assertLookupCode(disability,
                                        disabilityCodeFromMsg,
                                        "DisabilityCode does not match");
                                //assertLookupDescription(disability,
                                // disabilityDescFromMsg,"DisabilityDesc does
                                // not match");
                                String disabilityPercent = (ratedDisability
                                        .getPercentage() != null) ? ratedDisability
                                        .getPercentage().toString()
                                        : null;
                                assertEquals(
                                        "Disability Percent does not match",
                                        disabilityPercentFromMsg,
                                        disabilityPercent);
                            }
                            //TODO ServiceConnected
                            String diagnosticExtremityCode = ratedDisability
                                    .getDiagnosticExtremity() == null ? null
                                    : ratedDisability.getDiagnosticExtremity()
                                            .getCode();
                            assertEquals("DiagnosticExtremity does not match",
                                    diagonisticExtremityFromMsg,
                                    diagnosticExtremityCode);

                            assertEquals("OriginalEffectiveRatingDate does not match",
                                    ratedDisabilityOrigEffDateFromMsg,
                                    DateFormatter.formatDate(ratedDisability.getOriginalEffectiveRatingDate()));
                            assertEquals("DisabilityCurrEffDate does not match",
                                    ratedDisabilityCurrEffDateFromMsg,
                                    DateFormatter.formatDate(ratedDisability.getRatingDate()));
                        }
                    }
                }//end of while iterRatedDisabilities.hasNext
            }//end of if ratedDisabilities
        }//end if scAward != null

    }

}