package gov.va.med.esr.messaging.parser;

import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.builder.message.DateFormatter;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * 
 * @author Rajiv Patnaik Created on Aug 9, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZIOTestDataValidator extends BaseSegmentsTestDataValidator
        implements XMLSegmentTagNameConstants
{

    public void validateZIO(Document document, Person person,
            VAFacility vaFacility) throws Exception
    {
        //TODO  - Get it by the incomeyear from message
        NodeList zicNodeList = document.getElementsByTagName(ZIC);
        Element zicElement = (Element) zicNodeList.item(0);
        String incomeYearFromMsg = getElement(zicElement, ZIC_2);
        
        PatientVisitSummary patientVisitSummary = person
                .getPatientVisitSummary(new Integer(incomeYearFromMsg), vaFacility);

        NodeList nodeList = document.getElementsByTagName(ZIO);
        for (int i = 0; i < nodeList.getLength(); i++)
        {
            Element element = (Element) nodeList.item(i);
            String inpatientDaysFromMsg = getElement(element, ZIO_2);
            String outpatientDaysFromMsg = getElement(element, ZIO_3);
            String lastVisitDateFromMsg = getElement(element, ZIO_4);
            String appointmentRequestFromMsg = getElement(element, ZIO_5);
            String appointmentRequestDateFromMsg = getElement(element, ZIO_6);

            validateNotNull(inpatientDaysFromMsg, patientVisitSummary,
                    "PatientVisitSummary is null");

            if (patientVisitSummary != null)
            {
                assertEquals("InpatientDays does not match", Integer
                        .valueOf(inpatientDaysFromMsg), patientVisitSummary
                        .getInpatientDays());
                assertEquals("OutpatientDays does not match", Integer
                        .valueOf(outpatientDaysFromMsg), patientVisitSummary
                        .getOutpatientDays());

                String lastVisitDate = DateFormatter
                        .formatDate(patientVisitSummary.getLastVisitDate());
                assertEquals("LastVisitDate does not match",
                        lastVisitDateFromMsg, lastVisitDate);

                assertEquals("Appointment Request from 1010EZ does not match",
                        buildBoolean(appointmentRequestFromMsg), person.getAppointmentRequestResponse());
                
                assertEquals("Appointment Request date does not match",
                        appointmentRequestDateFromMsg, DateFormatter.formatDate(person
                                .getAppointmentRequestDate()));
            }
        }
    }
}