package gov.va.med.esr.messaging.parser;

import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.builder.message.DateFormatter;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * 
 * @author Rajiv Patnaik
 * Created on Aug 17, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZIETestDataValidator extends BaseSegmentsTestDataValidator
        implements XMLSegmentTagNameConstants
{
    public void validateZIE(Document document, Person person) throws Exception
    {
        NodeList nodeList = document.getElementsByTagName(ZIE);
        //There is only one node for ZIE
        Element element = (Element) nodeList.item(0);

        String ineligibledateFromMsg = getElement(element, ZIE_2);
        String ineligibleReasonFromMsg = getElement(element, ZIE_3);
        String ineligibleVaroDecisionFromMsg = getElement(element, ZIE_4);

        IneligibilityFactor ineligibility = person.getIneligibilityFactor();
        if(ineligibledateFromMsg != null || ineligibleReasonFromMsg != null || ineligibleVaroDecisionFromMsg != null)
        {
            assertNotNull("IneligibilityFactor is null", ineligibility);
            
            if(ineligibledateFromMsg != null)
            {
                assertNotNull("IneligibleDate is null", ineligibility.getIneligibleDate());
                assertEquals("IneligibleDate does not match", ineligibledateFromMsg, DateFormatter.formatDate(ineligibility.getIneligibleDate()));
            }
            assertEquals("IneligibleReason does not match", ineligibleReasonFromMsg, ineligibility.getReason());
            assertEquals("VaroDecision does not match", ineligibleVaroDecisionFromMsg, ineligibility.getVaroDecision());
        }
        
            
    }
}
