package gov.va.med.esr.messaging.parser;

import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.ReceivedEnrollment;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.builder.message.DateFormatter;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * 
 * @author Rajiv Patnaik Created on Aug 8, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZENTestDataValidator extends BaseSegmentsTestDataValidator
        implements XMLSegmentTagNameConstants
{

    public void validateZEN(Document document, Person person) throws Exception
    {
        NodeList zelNodes = document.getElementsByTagName(ZEN);

        for (int i = 0; i < zelNodes.getLength(); i++)
        {
            Element element = (Element) zelNodes.item(i);

            //EnrollmentDate, EnrollmentSource, EnrollmentPriority,
            //EffectiveDate, EnrollmentEndDate, and EnrollmentSubGroup.
            validateEnrollment(person, element);

            validateEnrollmentStatus(person, element);

            validateCancelDecline(person, element);
        }
    }

    private void validateEnrollment(Person person, Element element)
    {

        String enrollmentDateFromMsg = getElement(element, ZEN_2);
        String enrollmentSourceFromMsg = getElement(element, ZEN_3);
        String enrollmentPriorityFromMsg = getElement(element, ZEN_9);
        String enrollmentEffectiveDateFromMsg = getElement(element, ZEN_10);
        String enrollmentEndDateFromMsg = getElement(element, ZEN_12);
        String enrollmentSubgroupFromMsg = getElement(element, ZEN_13);

        String enrollmentDate = null;
        String enrollmentEffectiveDate = null;
        String enrollmentEndDate = null;

        //Get ReceivedEnrollment. NOTE: For outgoing messages, we use
        // EnrollmentDetermination
        ReceivedEnrollment enrollment = person.getReceivedEnrollment();

        validateNotNull(enrollmentDateFromMsg, enrollment,
                "ReceivedEnrollment is null");

        if (enrollment != null)
        {
            enrollmentDate = DateFormatter.formatDate(enrollment
                    .getEnrollmentDate());
            assertEquals("enrollmentDate does not match",
                    enrollmentDateFromMsg, enrollmentDate);
            //RP 08/10 Right now the EnrollmentDataSource is stored as 01, 02 but the message values do not
            //have leading 0s. Pat Wilson will provide a change request to sync them up
           //assertLookup(enrollment.getCalculationSource(),enrollmentSourceFromMsg,"CalculationSource does not match");

            assertLookupCode(enrollment.getPriorityGroup(),
                    enrollmentPriorityFromMsg,
                    "EnrollmentPriority does not match");

            assertLookupCode(enrollment.getPrioritySubGroup(),
                    enrollmentSubgroupFromMsg,
                    "PrioritySubGroup does not match");

            enrollmentEffectiveDate = DateFormatter.formatDate(enrollment
                    .getEffectiveDate());
            assertEquals("enrollmentEffectiveDate does not match",
                    enrollmentEffectiveDateFromMsg, enrollmentEffectiveDate);

            enrollmentEndDate = DateFormatter.formatDate(enrollment
                    .getEndDate());
            assertEquals("enrollmentEndDate does not match",
                    enrollmentEndDateFromMsg, enrollmentEndDate);

        }
    }

    private void validateEnrollmentStatus(Person person, Element element)
    {
        String enrollmentStatusFromMsg = getElement(element, ZEN_4);
        ReceivedEnrollment enrollment = person.getReceivedEnrollment();
        validateNotNull(enrollmentStatusFromMsg, enrollment,
                "ReceivedEnrollment is null");

        if (enrollment != null)
        {
            EnrollmentStatus enrollmentStatus = enrollment.getEnrollmentStatus();
            assertLookupCode(enrollmentStatus, enrollmentStatusFromMsg,
                    "EnrollmentStatus code does not match");
        }

    }

    private void validateCancelDecline(Person person, Element element)
    {

        String reasonCancelledFromMsg = getElement(element, ZEN_5);
        ;
        String cancelRemarksFromMsg = getElement(element, ZEN_6);
        ;

        String reasonCancelled = null;
        String cancelRemarks = null;

        //Get CancelDecline object
        CancelDecline cancel = person.getCancelDecline();

        validateNotNull(reasonCancelledFromMsg, cancel, "CancelDecline is null");

        if (cancel != null)
        {
            assertNotNull("CancelDeclineReason is null", cancel.getReason());
            reasonCancelled = cancel.getReason().getCode();
            cancelRemarks = cancel.getRemarks();

            assertEquals("reasonCancelled does not match",
                    reasonCancelledFromMsg, reasonCancelled);
            assertEquals("cancelRemarks does not match", cancelRemarksFromMsg,
                    cancelRemarks);
        }
    }
}