package gov.va.med.esr.messaging.parser;

import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.person.Person;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * 
 * @author Rajiv Patnaik Created on Aug 8, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZEMTestDataValidator extends BaseSegmentsTestDataValidator
        implements XMLSegmentTagNameConstants
{
    /**
     * @throws Exception
     */
    public ZEMTestDataValidator() throws Exception
    {
        super();
        // TODO Auto-generated constructor stub
    }

    public void validateZEM(Document document, Person person)
    {
        NodeList nodeList = document.getElementsByTagName(ZEM);
        Element veteranElement = null;
        for (int i = 0; i < nodeList.getLength(); i++)
        {
            Element element = (Element) nodeList.item(i);

            //1 if veteran, 2 if spouse
            String personType = getElement(element, ZEM_2);
            if ("1".equals(person))
            {
                veteranElement = element;
                break;
            }
        }//end of zelNodes

        //Validate for the Veteran only, TODO ..validate spouse ZEM data
        if (veteranElement != null)
        {
            validateData(person, veteranElement);
        }
    }

    private void validateData(Person person, Element element)
    {
        //For ORUZ07, Validate Seq 1-3 only.
        String employmentStatusFromMsg = getElement(element, ZEM_3);
        EmploymentStatus empStatus = person.getEmployment().getEmploymentStatus();
        validateNotNull(employmentStatusFromMsg, empStatus,
                "Employment Status is null");
        assertEquals("Employment Status code does not match",
                employmentStatusFromMsg, empStatus.getCode());

    }
}