package gov.va.med.esr.messaging.parser;

import java.util.Date;
import java.util.Iterator;
import java.util.Set;

import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.builder.message.DateFormatter;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * 
 * @author Rajiv Patnaik Created on Aug 8, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZCTTestDataValidator extends BaseSegmentsTestDataValidator
        implements XMLSegmentTagNameConstants
{
 
    public void validateZCT(Document document, Person person)
    {
        NodeList nodeList = document.getElementsByTagName("zct");
        //Only one Emergency Contact
        Element element = (Element) nodeList.item(0);        
    }
    
    private void validateData(Person person, Element element)
    {
        Association contact = null;
        Set associations = person.getAssociations();
        //TODO After Associations BOM is finalised
        if(associations != null)
        {
            for (Iterator iter = associations.iterator(); iter.hasNext();)
            {
                Association association = (Association) iter.next();
                if(AssociationType.CODE_EMERGENCY_CONTACT.getName().equals(association.getType().getCode()))
                {
                    contact = association;
                }
            }
        }
        
        if(contact != null) 
        {
            String lastUpdateDateFromMSg = getElement(element, ZCT_10);
            
            String relationship = contact.getRelationship();
            Name name = contact.getRepresentativeName();
            
            Date lastUpdateDate = contact.getLastUpdateDate();
            assertEquals("Last Updated Date does not match ", lastUpdateDateFromMSg, DateFormatter.formatDate(lastUpdateDate));
        }
        
    }
}