package gov.va.med.esr.messaging.parser;

import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.lookup.Diagnosis;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.builder.message.DateFormatter;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.builder.BuilderException;

import java.util.Iterator;
import java.util.Set;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * 
 * @author Rajiv Patnaik Created on Aug 9, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZCDTestDataValidator extends BaseSegmentsTestDataValidator
        implements XMLSegmentTagNameConstants
{

    public void validateZCD(Document document, Person person,
            PersonHelperService personHelperService) throws Exception
    {
        NodeList nodeList = document.getElementsByTagName(ZCD);
        for (int i = 0; i < nodeList.getLength(); i++)
        {
            Element element = (Element) nodeList.item(i);
            validateData(person, element, personHelperService);
        }
    }

    private void validateData(Person person, Element element,
            PersonHelperService personHelperService) throws BuilderException,
            ServiceException
    {

        String reviewDateFromMSg = getElement(element, ZCD_2);
        String decidedByFromMSg = getElement(element, ZCD_3);
        String determinationFacilityFromMSg = getElement(element, ZCD_4);
        //decisonDate
        String determinationMethodFromMSg = getSubElementData(element, ZCD_6,
                CE_1);
        String diagnosisFromMSg = getSubElementData(element, ZCD_7, CE_1);
        String catastrophicallyDisabledFromMSg = getElement(element, ZCD_12);

        //Get CatastrophicDisability object
        CatastrophicDisability catastrophicDisability = (CatastrophicDisability) personHelperService
                .getClinicalDetermination(CatastrophicDisability.class, person);

        validateNotNull(determinationFacilityFromMSg, catastrophicDisability,
                "CatastrophicDisability is null");

        if (catastrophicDisability != null)
        {
            //Set common variables used for all repeating ZCD segments.
            String reviewDate = DateFormatter.formatDate(catastrophicDisability
                    .getReviewDate());
            assertEquals("reviewDate does not match", reviewDateFromMSg,
                    reviewDate);

            String decidedBy = catastrophicDisability.getDeterminedBy();
            assertEquals("DeterminedBy does not match", decidedByFromMSg,
                    decidedBy);

            String determinationFacility = (catastrophicDisability
                    .getDeterminationFacility() != null) ? catastrophicDisability
                    .getDeterminationFacility().getStationNumber()
                    : null;
            assertEquals("DeterminationFacility does not match",
                    determinationFacilityFromMSg, determinationFacility);

            String determinationMethod = catastrophicDisability
                    .getDeterminationMethod()== null? null: catastrophicDisability
                            .getDeterminationMethod().getCode();
            assertEquals("DeterminationMethod does not match",
                    determinationMethodFromMSg, determinationMethod);

            Boolean isCatastrophicallyDisabled = catastrophicDisability
                    .getCatastrophicallyDisabled();
            assertEquals("CatastrophicallyDisabled does not match",
                    buildBoolean(catastrophicallyDisabledFromMSg),
                    isCatastrophicallyDisabled);

            //Build ZCD for Diagnosis.
            if(diagnosisFromMSg != null)
            {
                Set diagnoses = catastrophicDisability.getDiagnoses();
                CDDiagnosis cdDiagnosisToTest = null;
                if (diagnoses != null)
                {
                    Iterator iterDiagnoses = diagnoses.iterator();
                    while (iterDiagnoses.hasNext())
                    {
                        CDDiagnosis cdDiagnosis = (CDDiagnosis) iterDiagnoses
                                .next();
                        String diagnosisCode = cdDiagnosis.getDiagnosis()
                                .getCode();

                        if (diagnosisFromMSg != null
                                && diagnosisFromMSg.equals(diagnosisCode))
                        {
                            cdDiagnosisToTest = cdDiagnosis;
                        }
                    }
                }
                //If there is a diagnosis in message, the CDDiagnosis should not be null
                assertNotNull("Diagnosis does not match", cdDiagnosisToTest);
            }
            //Build Conditions

            //Build procedures
        }
    }

}