package gov.va.med.esr.messaging.parser;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.PersonHelperService;

/**
 * 
 * @author Rajiv Patnaik Created on Aug 9, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ZBTTestDataValidator extends BaseSegmentsTestDataValidator
        implements XMLSegmentTagNameConstants
{

    public void validateZBT(Document document, Person person,
            PersonHelperService personHelperService, VAFacility site)
            throws Exception
    {

        NodeList nodeList = document.getElementsByTagName(ZBT);
        //There is only one node for ZBT
        Element element = (Element) nodeList.item(0);

        String dateCertifiedFromMsg = getSubElementData(element, ZBT_2, TS_1);
        String isEligibleFromMsg = getElement(element, ZBT_3);
        String amountCertifiedFromMsg = getElement(element, ZBT_4);
        String travelClaimDate = getSubElementData(element, ZBT_7, TS_1);

        if (dateCertifiedFromMsg != null || isEligibleFromMsg != null
                || amountCertifiedFromMsg != null || travelClaimDate != null)
        {
            //IncomeTest incomeTest = personHelperService
             //       .getCurrentIncomeTest(person);
            //assertNotNull("IncomeTest is null", incomeTest);

            BeneficiaryTravel beneficiaryTravel = person.getBeneficiaryTravel(
                    new Integer(20030000), site);
            assertNotNull("BeneficiaryTravel is null", beneficiaryTravel);

            validateDate(beneficiaryTravel.getDateCertified(),
                    dateCertifiedFromMsg, "DateCertified is null",
                    "DateCertified does not match");

            assertEquals("isElgible does  not match",
                    buildBoolean(isEligibleFromMsg), beneficiaryTravel
                            .getEligible());

            assertEquals("AmountCertified does  not match",
                    amountCertifiedFromMsg, beneficiaryTravel
                            .getAmountCertified().toString());

            validateDate(beneficiaryTravel.getClaimDate(), 
                    travelClaimDate == null ? null:
                        travelClaimDate .substring(0, 8), "ClaimDate is null",
                    	"ClaimDate does not match");

        }

    }
}

