package gov.va.med.esr.messaging.parser;

import java.io.StringReader;
import java.util.Iterator;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.service.MessageProcessServiceUtil;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;
import gov.va.med.esr.messaging.xml.XmlFormatter;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.hl7.BatchMessage;
import gov.va.med.fw.hl7.Message;

/**
 * 
 * @author Rajiv Patnaik Created on Oct 4, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class Z05ParserTest extends AbstractMessagingTest
{
    public Z05ParserTest(String name)
    {
        super(name);
    }

    public void testBuild() throws Exception
    {
        //Create a BatchMessage object
        BatchMessage batchMessage = (BatchMessage) super.createORUZ05Message();

        //Parses the message into segments
        batchMessage.getSegments();

        //Parses the message into different messages each containing its
        // respective segments
        List messages = batchMessage.getMessages();

        //Get a formatter to parse the Message and convert it to a XMLstring
        XmlFormatter messageFormatter = (XmlFormatter) applicationContext.getBean("inbound.oruz07.xmlFormatter");

        Z05Parser parser = (Z05Parser) applicationContext
                .getBean("inbound.z05Parser");

        //Save the person so that it gets a database identifier.Without this
        //the parser returns null.
        PersonService personService = (PersonService) applicationContext.getBean("personService");
        Person person = personService.getPerson(CommonEntityKeyFactory
                .createPersonIdEntityKey("373975270"));

        //Right now there is only one message in the BatchMessage object
        for (Iterator iter = messages.iterator(); iter.hasNext();)
        {
            Message message = (Message) iter.next();
            //Parse the message and overlay the info on top of the retrieved
            // Person from database
            person = parser.build(person, message);
            assertNotNull("Person from parser is null", person);

            //Call the XMLFormatter to convert the raw message into XML
            String messageAsXML = MessageProcessServiceUtil
                    .getFormattedMessageBody(messageFormatter.build(message
                            .getMessageData()));

            //Build a DOM tree out of the XML doc
            DocumentBuilder builder = DocumentBuilderFactory.newInstance()
                    .newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(
                    messageAsXML)));

            //Now start validating the Person object to see that each segment
            // has been built corrrectly
            new PIDTestDataValidator().validatePID(document, person);
            new ZPDTestDataValidator().validateZPD(document, person);
            //new ZGD
        }
    }

}